/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.replication.impl;

import com.day.cq.replication.AccessDeniedException;
import com.day.cq.replication.Agent;
import com.day.cq.replication.AgentFilter;
import com.day.cq.replication.AgentManager;
import com.day.cq.replication.AgentNotFoundException;
import com.day.cq.replication.Preprocessor;
import com.day.cq.replication.ReplicationAction;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationContent;
import com.day.cq.replication.ReplicationException;
import com.day.cq.replication.ReplicationLog;
import com.day.cq.replication.ReplicationOptions;
import com.day.cq.replication.Replicator;
import com.day.cq.security.User;
import com.day.cq.security.UserResolver;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.Value;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicatorImpl
implements Replicator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private EventAdmin eventAdmin;
    private SlingRepository repository;
    private AgentManager agentMgr;
    static final String DISTRIBUTE_EVENTS = "distribute_events";
    private boolean distributeEvents;
    private UserResolver userResolver;
    private final Map<String, Preprocessor> preprocessors = new HashMap<String, Preprocessor>();
    private final Map<String, ServiceReference> unhandledPreprocessors = new HashMap<String, ServiceReference>();
    private ComponentContext context;
    private final Lock lock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(ComponentContext context) {
        this.lock.lock();
        try {
            this.distributeEvents = (Boolean)context.getProperties().get(DISTRIBUTE_EVENTS);
            this.context = context;
            for (ServiceReference ref : this.unhandledPreprocessors.values()) {
                this.registerPreprocessor(ref);
            }
            this.unhandledPreprocessors.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deactivate(ComponentContext context) {
        this.lock.lock();
        try {
            this.context = null;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindPreprocessor(ServiceReference ref) {
        this.lock.lock();
        try {
            if (this.context == null) {
                this.unhandledPreprocessors.put((String)ref.getProperty("service.pid"), ref);
            } else {
                this.registerPreprocessor(ref);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindPreprocessor(ServiceReference ref) {
        this.lock.lock();
        try {
            this.unregisterPreprocessor(ref);
            this.unhandledPreprocessors.remove(ref.getProperty("service.pid"));
        }
        finally {
            this.lock.unlock();
        }
    }

    private void registerPreprocessor(ServiceReference ref) {
        String key = (String)ref.getProperty("service.pid");
        Object service = this.context.locateService("preprocessor", ref);
        if (service != null) {
            this.preprocessors.put(key, (Preprocessor)service);
            this.logger.debug("Registering service {} : {}", (Object)key, service);
        }
    }

    private void unregisterPreprocessor(ServiceReference ref) {
        String key = (String)ref.getProperty("service.pid");
        this.preprocessors.remove(key);
        this.logger.debug("Unregistering service {}.", (Object)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Preprocessor[] getPreprocessors() {
        this.lock.lock();
        try {
            Collection<Preprocessor> values = this.preprocessors.values();
            Preprocessor[] preprocessorArray = values.toArray(new Preprocessor[values.size()]);
            return preprocessorArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void replicate(Session session, ReplicationActionType type, String path) throws ReplicationException {
        this.replicate(session, type, path, null);
    }

    @Override
    public void replicate(Session session, ReplicationActionType type, String path, ReplicationOptions options) throws ReplicationException {
        long start = System.currentTimeMillis();
        if (options == null) {
            options = new ReplicationOptions();
        }
        LinkedList<Agent> agents = new LinkedList<Agent>();
        AgentFilter filter = options.getFilter();
        if (filter == null) {
            filter = AgentFilter.DEFAULT;
        }
        boolean noStatusUpdate = true;
        boolean noVersions = true;
        boolean isPureCacheInvalidation = true;
        for (Agent agent : this.agentMgr.getAgents().values()) {
            if (!agent.isValid() || !filter.isIncluded(agent) || !agent.isEnabled() && type != ReplicationActionType.TEST) continue;
            agents.add(agent);
            noStatusUpdate &= agent.getConfiguration().noStatusUpdate();
            noVersions &= agent.getConfiguration().noVersions();
            isPureCacheInvalidation &= agent.isCacheInvalidator();
        }
        if (agents.size() == 0) {
            if (filter != AgentFilter.DEFAULT) {
                throw new AgentNotFoundException("Replication triggered, but no agent found!");
            }
            this.logger.info("Replication triggered, but no agent found or selected.");
            return;
        }
        if (noStatusUpdate || isPureCacheInvalidation || type == ReplicationActionType.TEST) {
            options.setSuppressStatusUpdate(true);
        }
        if (noVersions || type == ReplicationActionType.TEST) {
            options.setSuppressVersions(true);
        }
        this.logger.info("Setting up replication with options: {}", (Object)options);
        String rev = options.getRevision();
        ReplicationAction action = new ReplicationAction(type, path, 0L, session.getUserID(), rev);
        User user = this.userResolver.resolveUser(session);
        if (user == null) {
            this.logger.error("Unable to resolve user for session with userid: {}", (Object)session.getUserID());
            throw new AccessDeniedException(path);
        }
        if (!user.hasPermissionOn("wcm/core/privileges/replicate", action.getPath())) {
            this.logger.warn("User {} has not enough permissions to replicate {}", (Object)action.getUserId(), (Object)path);
            throw new AccessDeniedException(path);
        }
        long setup = System.currentTimeMillis();
        for (Preprocessor p : this.getPreprocessors()) {
            p.preprocess(action, options);
        }
        long preprocessed = System.currentTimeMillis();
        Session systemSession = null;
        try {
            systemSession = this.repository.loginAdministrative(null);
            Map<String, ReplicationContent> contents = this.buildContents(systemSession, action, agents);
            long built = System.currentTimeMillis();
            int numSuccess = 0;
            for (Agent agent : agents) {
                ReplicationLog log = agent.getLog();
                ReplicationContent content = contents.get(agent.getId());
                try {
                    if (content == null) continue;
                    agent.replicate(action, content, options);
                    ++numSuccess;
                }
                catch (Exception e) {
                    log.error("Error during replication %s", e.toString());
                    this.logger.error("Error during replication.", (Throwable)e);
                    if (content == null) continue;
                    content.release(agent.getId());
                }
            }
            long queued = System.currentTimeMillis();
            if (numSuccess > 0) {
                if (!options.isSuppressStatusUpdate()) {
                    this.updateStatus(systemSession, action);
                }
                if (this.eventAdmin != null) {
                    this.eventAdmin.postEvent(action.toEvent(this.distributeEvents));
                }
            }
            long end = System.currentTimeMillis();
            this.logger.info("Processed replication: setup {}ms, pre {}ms, build {}ms, queued {}ms, status {}ms, total {}ms", new Object[]{setup - start, preprocessed - setup, built - preprocessed, queued - built, end - queued, end - start});
        }
        catch (RepositoryException e) {
            this.logger.error("Repository error while replicating.", (Throwable)e);
            throw new ReplicationException((Exception)((Object)e));
        }
        finally {
            if (systemSession != null) {
                systemSession.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ReplicationContent> buildContents(Session systemSession, ReplicationAction action, List<Agent> agents) {
        HashMap<ContentKey, ReplicationContent> contents = new HashMap<ContentKey, ReplicationContent>();
        HashMap<String, ReplicationContent> ret = new HashMap<String, ReplicationContent>();
        for (Agent agent : agents) {
            String userId = agent.getConfiguration().getAgentUserId();
            ContentKey key = new ContentKey(userId, agent.getConfiguration().getSerializationType());
            ReplicationContent content = (ReplicationContent)contents.get(key);
            ReplicationLog log = agent.getLog();
            if (content == null) {
                Session agentSession = systemSession;
                if (userId != null) {
                    try {
                        agentSession = systemSession.impersonate((Credentials)new SimpleCredentials(userId, new char[0]));
                        log.info("Using user %s for building content.", userId);
                    }
                    catch (RepositoryException e) {
                        log.error("Error while impersonating to user '%s'. using system session.", userId);
                    }
                }
                try {
                    if (systemSession.itemExists(action.getPath()) && !agentSession.itemExists(action.getPath())) {
                        log.info("User does not see %s. ignoring agent.", action.getPath());
                    }
                    content = agent.buildContent(agentSession, action);
                    contents.put(key, content);
                }
                catch (Exception e) {
                    log.error("Error while building replication content %s", e.toString());
                    this.logger.error("Error while building replication content.", (Throwable)e);
                }
                finally {
                    if (agentSession != systemSession) {
                        agentSession.logout();
                    }
                }
            } else {
                try {
                    content = agent.getContent(content.getFacade());
                }
                catch (Exception e) {
                    log.error("Error while retrieving existing replication content %s", e.toString());
                    this.logger.error("Error while retrieving existing content.", (Throwable)e);
                }
            }
            if (content == null) continue;
            ret.put(agent.getId(), content);
        }
        return ret;
    }

    private void updateStatus(Session session, ReplicationAction action) {
        if (action.getType() == ReplicationActionType.ACTIVATE || action.getType() == ReplicationActionType.DEACTIVATE || action.getType() == ReplicationActionType.DELETE) {
            try {
                Calendar c = Calendar.getInstance();
                c.setTimeInMillis(action.getTime());
                this.update(session, action.getPath(), action.getType(), action.getUserId(), c);
                if ((action.getType() == ReplicationActionType.DEACTIVATE || action.getType() == ReplicationActionType.DELETE) && session.nodeExists(action.getPath())) {
                    this.deactivateChildNodes(session, session.getNode(action.getPath()), action.getType(), action.getUserId(), c);
                }
            }
            catch (RepositoryException e) {
                this.logger.error("Unable to update replication status.", (Throwable)e);
            }
        }
    }

    private void deactivateChildNodes(Session session, Node node, ReplicationActionType type, String userId, Calendar date) throws RepositoryException {
        NodeIterator ni = node.getNodes();
        while (ni.hasNext()) {
            Node current = ni.nextNode();
            if (!current.isNodeType("nt:hierarchyNode")) continue;
            this.update(session, current.getPath(), type, userId, date);
            this.deactivateChildNodes(session, current, type, userId, date);
        }
    }

    private void update(Session session, String path, ReplicationActionType type, String userId, Calendar date) throws RepositoryException {
        if (session.itemExists(path)) {
            Node node = (Node)session.getItem(path);
            if (node.hasNode("jcr:content")) {
                node = node.getNode("jcr:content");
            }
            if (!node.isNodeType("cq:ReplicationStatus") && node.canAddMixin("cq:ReplicationStatus")) {
                node.addMixin("cq:ReplicationStatus");
            }
            node.setProperty("cq:lastReplicationAction", type.getName());
            node.setProperty("cq:lastReplicatedBy", userId);
            node.setProperty("cq:lastReplicated", date);
            node.setProperty("cq:lastPublishedBy", (Value)null);
            node.setProperty("cq:lastPublished", (Value)null);
            node.save();
        }
    }

    protected void bindEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    protected void unbindEventAdmin(EventAdmin eventAdmin) {
        if (this.eventAdmin == eventAdmin) {
            this.eventAdmin = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindAgentMgr(AgentManager agentManager) {
        this.agentMgr = agentManager;
    }

    protected void unbindAgentMgr(AgentManager agentManager) {
        if (this.agentMgr == agentManager) {
            this.agentMgr = null;
        }
    }

    protected void bindUserResolver(UserResolver userResolver) {
        this.userResolver = userResolver;
    }

    protected void unbindUserResolver(UserResolver userResolver) {
        if (this.userResolver == userResolver) {
            this.userResolver = null;
        }
    }

    private static final class ContentKey {
        private final String userId;
        private final String serType;

        private ContentKey(String userId, String serType) {
            this.userId = userId == null ? "" : userId;
            this.serType = serType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ContentKey that = (ContentKey)o;
            if (!this.serType.equals(that.serType)) {
                return false;
            }
            return this.userId.equals(that.userId);
        }

        public int hashCode() {
            int result = this.userId.hashCode();
            result = 31 * result + this.serType.hashCode();
            return result;
        }
    }
}

