/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.replication.impl;

import com.day.cq.replication.Agent;
import com.day.cq.replication.AgentManager;
import com.day.cq.replication.ReplicationAction;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationContent;
import com.day.cq.replication.ReplicationException;
import com.day.cq.replication.ReplicationLog;
import com.day.cq.replication.content.durbo.DurboImporter;
import com.day.durbo.DurboInput;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.commons.io.IOUtils;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReverseReplicator
implements Runnable,
DurboImporter.Hook {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private SlingRepository repository;
    private AgentManager agentMgr;
    private final Lock lock = new ReentrantLock();
    private final Condition guard = this.lock.newCondition();
    private static final String FREQUENCY_PROPERTY = "frequency";
    private long frequency;
    private boolean running;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(ComponentContext ctx) {
        Long frequency = (Long)ctx.getProperties().get(FREQUENCY_PROPERTY);
        if (frequency == null) {
            frequency = 30000L;
        }
        this.frequency = frequency;
        this.lock.lock();
        try {
            if (this.running) {
                this.logger.error("service already running. refuse to initialize twice.");
            } else {
                Thread t = new Thread((Runnable)this, "Reverse Replication Processor");
                t.setDaemon(true);
                this.running = true;
                t.start();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deactivate(ComponentContext ctx) {
        this.lock.lock();
        try {
            this.running = false;
            this.guard.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.lock.lock();
        try {
            while (this.running) {
                try {
                    this.guard.await(this.frequency, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    this.logger.warn("Condition interrupted.", (Throwable)e);
                }
                if (!this.running) {
                    return;
                }
                this.lock.unlock();
                try {
                    this.poll();
                }
                catch (ReplicationException e) {
                    String msg = "Error during poll.";
                    this.logger.warn(msg, (Throwable)e);
                }
                finally {
                    this.lock.lock();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void poll() throws ReplicationException {
        LinkedList<Agent> agents = new LinkedList<Agent>();
        for (Agent agent : this.agentMgr.getAgents().values()) {
            if (!agent.isValid() || !agent.isEnabled() || !agent.getConfiguration().usedForReverseReplication()) continue;
            agents.add(agent);
        }
        if (agents.isEmpty()) {
            return;
        }
        ReplicationAction action = new ReplicationAction(ReplicationActionType.REVERSE, "", 0L, "", null);
        Session session = null;
        try {
            session = this.repository.loginAdministrative(null);
            for (Agent agent : agents) {
                Session agentSession = session;
                ReplicationLog log = agent.getLog();
                String userId = agent.getConfiguration().getAgentUserId();
                if (userId != null) {
                    try {
                        agentSession = session.impersonate((Credentials)new SimpleCredentials(userId, new char[0]));
                        log.info("Using user %s for building content.", userId);
                    }
                    catch (RepositoryException e) {
                        log.error("Error while impersonating to user '%s'. using system session.", userId);
                    }
                }
                try {
                    this.poll(agent, agentSession, action);
                }
                catch (Exception e) {
                    log.error("Error while polling agent %s: %s", agent.getId(), e.toString());
                    this.logger.error("Error while poling agent " + agent.getId(), (Throwable)e);
                }
                finally {
                    if (agentSession == session) continue;
                    agentSession.logout();
                }
            }
        }
        catch (RepositoryException e) {
            throw new ReplicationException("Error while accessing repository", (Exception)((Object)e));
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void poll(Agent agent, Session agentSession, ReplicationAction action) throws ReplicationException {
        ReplicationContent[] pages = agent.poll(action);
        if (pages != null && pages.length > 0) {
            Calendar lastPoll = agent.getLastPollTimeline();
            if (lastPoll == null) {
                lastPoll = Calendar.getInstance();
                lastPoll.setTimeInMillis(0L);
            }
            for (ReplicationContent page : pages) {
                try {
                    if (page.getLastModified() + 1L > lastPoll.getTimeInMillis()) {
                        lastPoll.setTimeInMillis(page.getLastModified() + 1L);
                    }
                    this.importPage(page, agentSession);
                }
                finally {
                    page.destroy();
                }
            }
            agent.setNextPollTimeline(lastPoll);
        }
    }

    private void importPage(ReplicationContent page, Session agentSession) throws ReplicationException {
        InputStream in = null;
        try {
            in = page.getInputStream();
            DurboImporter importer = new DurboImporter();
            importer.setHook(this);
            importer.createPage(agentSession, null, new DurboInput(in));
        }
        catch (IOException e) {
            String msg = "Unable to open input stream on replication content.";
            throw new ReplicationException(msg, e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public void beforeSave(Node node) throws RepositoryException {
        Calendar date = Calendar.getInstance();
        String userId = node.getSession().getUserID();
        ReplicationActionType type = ReplicationActionType.ACTIVATE;
        if (node.hasNode("jcr:content")) {
            Node content = node.getNode("jcr:content");
            try {
                if (!content.isNodeType("cq:ReplicationStatus") && content.canAddMixin("cq:ReplicationStatus")) {
                    content.addMixin("cq:ReplicationStatus");
                }
                content.setProperty("cq:lastReplicationAction", type.getName());
                content.setProperty("cq:lastReplicatedBy", userId);
                content.setProperty("cq:lastReplicated", date);
            }
            catch (RepositoryException e) {
                this.logger.warn("unable to update replication status.", (Throwable)e);
            }
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindAgentMgr(AgentManager agentManager) {
        this.agentMgr = agentManager;
    }

    protected void unbindAgentMgr(AgentManager agentManager) {
        if (this.agentMgr == agentManager) {
            this.agentMgr = null;
        }
    }
}

