/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.replication.impl.queue;

import com.day.cq.replication.ReplicationAction;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationContentFacade;
import java.util.Calendar;
import java.util.Date;
import java.util.Dictionary;
import org.apache.sling.event.EventPropertiesMap;
import org.osgi.service.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationJob {
    private static final Logger log = LoggerFactory.getLogger(ReplicationJob.class);
    public static final String JOB_TOPIC = "com/day/cq/replication/job";
    private static final int JOB_TOPIC_LENGTH = "com/day/cq/replication/job".length();
    private static final String PROPERTY_REPLICATION_CONTENT = "replicationContent";
    @Deprecated
    private static final String PROPERTY_REPLICATION_ACTION = "replicationAction";
    public static final String PROPERTY_CQ_ACTION_PATH = "cq:path";
    public static final String PROPERTY_CQ_ACTION_REV = "cq:revision";
    public static final String PROPERTY_CQ_ACTION_TIME = "cq:time";
    public static final String PROPERTY_CQ_ACTION_TYPE = "cq:type";
    public static final String PROPERTY_CQ_ACTION_USER = "cq:user";
    public static final String NODE_PROPERTY_LAST_PUBLISHED = "cq:lastPublished";
    public static final String NODE_PROPERTY_LAST_PUBLISHED_BY = "cq:lastPublishedBy";
    public static final String NODE_PROPERTY_LAST_REPLICATED = "cq:lastReplicated";
    public static final String NODE_PROPERTY_LAST_REPLICATED_BY = "cq:lastReplicatedBy";
    public static final String NODE_PROPERTY_LAST_REPLICATION_ACTION = "cq:lastReplicationAction";
    public static final String NODE_PROPERTY_LAST_REPLICATION_STATUS = "cq:lastReplicationStatus";
    public static final String NODE_TYPE = "cq:ReplicationStatus";
    private final Event event;
    private ReplicationAction action;

    public ReplicationJob(Event event) {
        this.event = event;
        if (!event.getTopic().startsWith("com/day/cq/replication/job/")) {
            throw new IllegalArgumentException("Invalid topic for replication job: " + event.getTopic());
        }
    }

    public ReplicationJob(String queueName, long retryDelay, ReplicationAction action, ReplicationContentFacade content) {
        EventPropertiesMap props = new EventPropertiesMap();
        props.put("event.job.topic", "com/day/cq/replication/job/" + queueName);
        props.put("event.job.retrydelay", retryDelay);
        if (content != null) {
            props.put(PROPERTY_REPLICATION_CONTENT, content);
            log.debug("Creating replication job {} (action: {}) with content {} ", new Object[]{props.get("event.job.id"), action, content});
        } else {
            log.debug("Creating replication job {} (action: {}) without content", new Object[]{props.get("event.job.id"), action});
        }
        this.action = action;
        props.put(PROPERTY_CQ_ACTION_PATH, action.getPath());
        if (action.getRevision() != null) {
            props.put(PROPERTY_CQ_ACTION_REV, action.getRevision());
        }
        props.put(PROPERTY_CQ_ACTION_TIME, action.getTime());
        props.put(PROPERTY_CQ_ACTION_TYPE, action.getType().name());
        props.put(PROPERTY_CQ_ACTION_USER, action.getUserId());
        this.event = new Event("org/apache/sling/event/job", (Dictionary)props);
    }

    public String getEventId() {
        return (String)this.event.getProperty("slingevent:eventId");
    }

    public String getPath() {
        ReplicationAction action;
        String path = (String)this.event.getProperty(PROPERTY_CQ_ACTION_PATH);
        if (path == null && (action = this.getAction()) != null) {
            path = action.getPath();
        }
        return path;
    }

    public String getQueueName() {
        String name = (String)this.event.getProperty("event.job.topic");
        if (name == null || !name.startsWith("com/day/cq/replication/job/")) {
            log.error("Invalid queue name: {}", (Object)name);
            return null;
        }
        return name.substring(JOB_TOPIC_LENGTH + 1);
    }

    public Event getEvent() {
        return this.event;
    }

    public ReplicationContentFacade getContent() {
        return (ReplicationContentFacade)this.event.getProperty(PROPERTY_REPLICATION_CONTENT);
    }

    public ReplicationAction getAction() {
        if (this.action == null) {
            this.action = (ReplicationAction)this.event.getProperty(PROPERTY_REPLICATION_ACTION);
            if (this.action == null) {
                Object lastMod = this.event.getProperty(PROPERTY_CQ_ACTION_TIME);
                long time = 0L;
                if (lastMod instanceof Date) {
                    time = ((Date)lastMod).getTime();
                } else if (lastMod instanceof Calendar) {
                    time = ((Calendar)lastMod).getTimeInMillis();
                } else if (lastMod instanceof Long) {
                    time = (Long)lastMod;
                }
                this.action = new ReplicationAction(ReplicationActionType.fromName((String)this.event.getProperty(PROPERTY_CQ_ACTION_TYPE)), (String)this.event.getProperty(PROPERTY_CQ_ACTION_PATH), time, (String)this.event.getProperty(PROPERTY_CQ_ACTION_USER), (String)this.event.getProperty(PROPERTY_CQ_ACTION_REV));
            }
        }
        return this.action;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ReplicationJob");
        sb.append("{event=").append(this.event);
        sb.append('}');
        return sb.toString();
    }
}

