/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.replication.transport;

import com.day.cq.replication.AgentConfig;
import com.day.cq.replication.ReplicationAction;
import com.day.cq.replication.ReplicationContent;
import com.day.cq.replication.ReplicationContentFactory;
import com.day.cq.replication.ReplicationException;
import com.day.cq.replication.ReplicationLog;
import com.day.cq.replication.ReplicationResult;
import com.day.cq.replication.ReplicationTransaction;
import com.day.cq.replication.TransportContext;
import com.day.cq.replication.TransportHandler;
import com.day.cq.replication.UnrecoverableReplicationException;
import com.day.cq.replication.transport.EasySSLProtocolSocketFactory;
import com.day.durbo.DurboInput;
import com.day.text.Text;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Http
implements TransportHandler {
    public static final String DEFAULT_HTTP_METHOD = "POST";
    private static final String PN_TIMELINE = "timeline";
    public static final String[] DEFAULT_HTTP_HEADERS = new String[]{"Action: {action}", "Path: {path}", "Handle: {path}"};

    @Override
    public boolean canHandle(AgentConfig config) {
        String uri = config == null ? null : config.getTransportURI();
        return uri != null && (uri.startsWith("http://") || uri.startsWith("https://"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReplicationResult deliver(TransportContext ctx, ReplicationTransaction tx) throws ReplicationException {
        State state = (State)ctx.getAttribute(Http.class.getName());
        if (state == null) {
            HttpClient client = this.createHttpClient(ctx.getName(), ctx.getConfig(), tx.getLog());
            state = new State(client);
            ctx.setAttribute(Http.class.getName(), state);
        }
        if (state.action != null) {
            throw new ReplicationException("Only 1 replication per agent allowed. already replicating : " + state.action);
        }
        state.action = tx.getAction();
        try {
            ReplicationResult replicationResult = this.deliver(state.client, ctx.getConfig(), tx.getLog(), tx.getAction(), tx.getContent());
            return replicationResult;
        }
        finally {
            state.action = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReplicationResult poll(TransportContext ctx, ReplicationTransaction tx, List<ReplicationContent> result, ReplicationContentFactory factory) throws ReplicationException {
        State state = (State)ctx.getAttribute(Http.class.getName());
        if (state == null) {
            HttpClient client = this.createHttpClient(ctx.getName(), ctx.getConfig(), tx.getLog());
            state = new State(client);
            ctx.setAttribute(Http.class.getName(), state);
        }
        if (state.action != null) {
            throw new ReplicationException("Only 1 retrieval per agent allowed. already retrieving : " + state.action);
        }
        state.action = tx.getAction();
        try {
            ReplicationResult replicationResult = this.poll(state.client, ctx.getConfig(), tx.getLog(), tx.getAction(), result, factory);
            return replicationResult;
        }
        finally {
            state.action = null;
        }
    }

    private HttpClient createHttpClient(String name, AgentConfig config, ReplicationLog log) {
        String localAddress;
        ValueMap conf;
        String version;
        log.info("Create new HttpClient for %s", name);
        HttpClient client = new HttpClient();
        String user = config.getTransportUser();
        if (user != null && user.length() > 0) {
            String pass = config.getTransportPassword();
            if (pass == null) {
                pass = "";
            }
            log.info("* Auth User: %s", user);
            client.getParams().setAuthenticationPreemptive(true);
            client.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(user, pass));
        }
        if ("0.9".equals(version = (String)(conf = config.getProperties()).get("protocolVersion", (Object)"1.1"))) {
            log.info("* HTTP Version: 0.9");
            client.getParams().setVersion(HttpVersion.HTTP_0_9);
        } else if ("1.0".equals(version)) {
            log.info("* HTTP Version: 1.0");
            client.getParams().setVersion(HttpVersion.HTTP_1_0);
        } else {
            log.info("* HTTP Version: 1.1");
            client.getParams().setVersion(HttpVersion.HTTP_1_1);
        }
        int timeout = (Integer)conf.get("protocolConnectTimeout", (Object)0);
        if (timeout > 0) {
            log.info("* Connect Timeout: %d", timeout);
            client.getHttpConnectionManager().getParams().setConnectionTimeout(timeout);
        }
        if ((timeout = ((Integer)conf.get("protocolSocketTimeout", (Object)0)).intValue()) > 0) {
            log.info("* Socket Timeout: %d", timeout);
            client.getParams().setSoTimeout(timeout);
        }
        if ((localAddress = (String)conf.get("protocolInterface", (Object)"")).length() > 0) {
            try {
                client.getHostConfiguration().setLocalAddress(InetAddress.getByName(localAddress));
            }
            catch (UnknownHostException e) {
                log.info("Cannot set local address to %s: %s", localAddress, e.toString());
            }
        }
        String proxyHost = (String)conf.get("proxyHost", (Object)"");
        int proxyPort = (Integer)conf.get("proxyPort", (Object)0);
        if (proxyHost.length() > 0 && proxyPort > 0) {
            log.info("* Proxy Host: %s", proxyHost);
            log.info("* Proxy Port: %d", proxyPort);
            client.getHostConfiguration().setProxy(proxyHost, proxyPort);
            String proxyUser = (String)conf.get("proxyUser", (Object)"");
            String proxyPass = (String)conf.get("proxyPassword", (Object)"");
            String ntlmHost = (String)conf.get("proxyNTLMHost", (Object)"");
            String ntlmDomain = (String)conf.get("proxyNTLMDomain", (Object)"");
            if (proxyUser.length() > 0) {
                UsernamePasswordCredentials creds;
                log.info("* Proxy User: %s", proxyUser);
                if (ntlmHost.length() > 0) {
                    log.info("* Proxy NTLM Host: %s", ntlmHost);
                    log.info("* Proxy NTLM Domain: %s", ntlmDomain);
                    creds = new NTCredentials(proxyUser, proxyPass, ntlmHost, ntlmDomain);
                } else {
                    creds = new UsernamePasswordCredentials(proxyUser, proxyPass);
                }
                client.getState().setProxyCredentials(AuthScope.ANY, (Credentials)creds);
            }
        }
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("path", "/");
        props.put("action", "activate");
        StrSubstitutor replace = new StrSubstitutor(props, "{", "}");
        try {
            URI uri = new URI(replace.replace(config.getTransportURI()));
            if (uri.getScheme().equals("https")) {
                boolean allowRelaxed = (Boolean)conf.get("protocolHTTPSRelaxed", (Object)false);
                boolean allowExpired = (Boolean)conf.get("protocolHTTPExpired", (Object)false);
                log.info("* Accept self-certified SSL certificates: %s", allowRelaxed);
                log.info("* Accept expired SSL certificates: %s", allowExpired);
                Protocol myhttps = Protocol.getProtocol((String)"https");
                if (allowRelaxed) {
                    myhttps = new Protocol("https", (SecureProtocolSocketFactory)new EasySSLProtocolSocketFactory(allowExpired), 443);
                }
                client.getHostConfiguration().setHost(uri.getHost(), uri.getPort(), myhttps);
            } else {
                client.getHostConfiguration().setHost(uri.getHost(), uri.getPort());
            }
        }
        catch (URISyntaxException e) {
            log.error("Transport uri not valid: " + e);
        }
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReplicationResult deliver(HttpClient httpClient, AgentConfig config, ReplicationLog log, ReplicationAction action, ReplicationContent content) throws ReplicationException {
        Header[] hdrs;
        String[] headers;
        GetMethod httpMethod;
        String relUri;
        URI uri;
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("path", action.getPath());
        props.put("action", action.getType().getName());
        StrSubstitutor replace = new StrSubstitutor(props, "{", "}");
        try {
            uri = new URI(replace.replace(config.getTransportURI()));
            relUri = new URI(null, null, uri.getPath(), uri.getQuery(), uri.getFragment()).toString();
        }
        catch (URISyntaxException e) {
            throw new ReplicationException(e);
        }
        String method = (String)config.getProperties().get("protocolHTTPMethod", (Object)DEFAULT_HTTP_METHOD);
        if ("GET".equals(method)) {
            httpMethod = new GetMethod(relUri);
        } else if (DEFAULT_HTTP_METHOD.equals(method)) {
            httpMethod = new PostMethod(relUri);
        } else if ("PUT".equals(method)) {
            httpMethod = new PutMethod(relUri);
        } else {
            throw new ReplicationException("Unsupported http method " + method);
        }
        httpMethod.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(0, false));
        for (String header : headers = (String[])config.getProperties().get("protocolHTTPHeaders", (Object)DEFAULT_HTTP_HEADERS)) {
            int idx = (header = replace.replace(header)).indexOf(58);
            if (idx <= 0) continue;
            String name = header.substring(0, idx).trim();
            String value = header.substring(idx + 1).trim();
            if (name.equalsIgnoreCase("host")) {
                httpMethod.getParams().setVirtualHost(value);
            } else {
                httpMethod.addRequestHeader(name, value);
            }
            log.debug("adding header: %s:%s", name, value);
        }
        log.debug("deserialize content for delivery");
        long contentLength = 0L;
        InputStream contentStream = null;
        if (content == null || content.getContentLength() == 0L) {
            if (content == null) {
                log.debug("No message body: No content to deliver");
            } else {
                log.debug("No message body: Content %s is empty", content);
            }
            httpMethod.addRequestHeader("Content-Length", "0");
            httpMethod.addRequestHeader("Content-Type", "application/octet-stream");
        } else {
            try {
                EntityEnclosingMethod eMethod = (EntityEnclosingMethod)httpMethod;
                contentLength = content.getContentLength();
                String contentType = content.getContentType();
                contentStream = content.getInputStream();
                InputStreamRequestEntity re = new InputStreamRequestEntity(contentStream, contentLength, contentType);
                eMethod.setRequestEntity((RequestEntity)re);
                log.debug("set %d bytes of post body.", contentLength);
            }
            catch (IOException e) {
                IOUtils.closeQuietly(contentStream);
                throw new UnrecoverableReplicationException(method + " can't read replication content " + content, e);
            }
            catch (ClassCastException e) {
                IOUtils.closeQuietly(contentStream);
                throw new ReplicationException(method + " can't have message body. Use POST or PUT", e);
            }
        }
        Conversation conv = new Conversation(uri.getHost() + ":" + uri.getPort(), method, uri.getPath());
        for (Header hdr1 : hdrs = httpMethod.getRequestHeaders()) {
            conv.out(hdr1.getName() + ": " + hdr1.getValue());
        }
        String vHost = httpMethod.getParams().getVirtualHost();
        if (vHost != null) {
            conv.out("Host: " + vHost);
        }
        if (contentLength > 0L) {
            conv.out("...spooling " + contentLength + " bytes...");
        }
        try {
            log.info("Sending %s request to %s", method, uri);
            httpClient.executeMethod((HttpMethod)httpMethod);
        }
        catch (IOException e) {
            log.error("Error while sending request: %s", e);
            httpMethod.releaseConnection();
            this.error(log, action, conv, e);
            ReplicationResult i$ = new ReplicationResult(false, 0, e.getMessage());
            return i$;
        }
        finally {
            IOUtils.closeQuietly((InputStream)contentStream);
        }
        conv.addLine("--");
        conv.in(httpMethod.getStatusLine().toString());
        for (Header hdr : hdrs = httpMethod.getResponseHeaders()) {
            conv.in(hdr.getName() + ": " + hdr.getValue());
        }
        InputStream in = null;
        try {
            in = httpMethod.getResponseBodyAsStream();
            if (in != null) {
                int read;
                byte[] buffer = new byte[8192];
                int pos = 0;
                conv.in("");
                while ((read = in.read(buffer, pos, buffer.length - pos)) >= 0) {
                    pos += read;
                    int start = 0;
                    for (int i = 0; i < pos; ++i) {
                        if (buffer[i] != 13 && buffer[i] != 10) continue;
                        conv.in(new String(buffer, start, i - start));
                        while (i < pos && (buffer[i] == 13 || buffer[i] == 10)) {
                            ++i;
                        }
                        start = i;
                    }
                    if (start == 0) {
                        conv.in(new String(buffer, 0, pos));
                        pos = 0;
                        continue;
                    }
                    System.arraycopy(buffer, start, buffer, 0, pos - start);
                    pos -= start;
                }
            } else {
                log.info("send: No data in response");
            }
        }
        catch (IOException e) {
            log.info("IOException while reading response: %s", e.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignore) {}
            }
        }
        conv.end();
        int statusCode = httpMethod.getStatusCode();
        String statusMsg = httpMethod.getStatusText();
        log.info("sent. Response: %d %s", statusCode, statusMsg);
        httpMethod.releaseConnection();
        if (statusCode != 200) {
            this.error(log, action, conv, null);
            log.info("Replication (%s) of %s not successful.", new Object[]{action.getType(), action.getPath()});
        } else {
            Iterator<String> citer = conv.messages();
            while (citer.hasNext()) {
                log.info(citer.next());
            }
            log.info("Replication (%s) of %s successful.", new Object[]{action.getType(), action.getPath()});
        }
        return new ReplicationResult(statusCode == 200, statusCode, statusMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReplicationResult poll(HttpClient httpClient, AgentConfig config, ReplicationLog log, ReplicationAction action, List<ReplicationContent> result, ReplicationContentFactory factory) throws ReplicationException {
        String statusMsg;
        int statusCode;
        Conversation conv;
        GetMethod httpMethod;
        block28: {
            Header[] hdrs;
            String[] headers;
            String relUri;
            URI uri;
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("path", action.getPath());
            props.put("action", action.getType().getName());
            StrSubstitutor replace = new StrSubstitutor(props, "{", "}");
            try {
                uri = new URI(replace.replace(config.getTransportURI()));
                relUri = new URI(null, null, uri.getPath(), uri.getQuery(), uri.getFragment()).toString();
            }
            catch (URISyntaxException e) {
                throw new ReplicationException(e);
            }
            String method = (String)config.getProperties().get("protocolHTTPMethod", (Object)DEFAULT_HTTP_METHOD);
            StringBuffer queryString = new StringBuffer();
            if ("GET".equals(method)) {
                String revision;
                httpMethod = new GetMethod(relUri);
                if (httpMethod.getQueryString() != null) {
                    queryString.append(httpMethod.getQueryString());
                }
                if ((revision = action.getRevision()) != null) {
                    if (queryString.length() > 0) {
                        queryString.append("&");
                    }
                    queryString.append(PN_TIMELINE).append("=").append(Text.escape((String)revision));
                    httpMethod.setQueryString(queryString.toString());
                }
            } else {
                throw new ReplicationException("Unsupported http method " + method);
            }
            httpMethod.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(0, false));
            for (String header : headers = (String[])config.getProperties().get("protocolHTTPHeaders", (Object)DEFAULT_HTTP_HEADERS)) {
                int idx = (header = replace.replace(header)).indexOf(58);
                if (idx <= 0) continue;
                String name = header.substring(0, idx).trim();
                String value = header.substring(idx + 1).trim();
                if (name.equalsIgnoreCase("host")) {
                    httpMethod.getParams().setVirtualHost(value);
                } else {
                    httpMethod.addRequestHeader(name, value);
                }
                log.debug("adding header: %s:%s", name, value);
            }
            String qs = queryString.toString();
            if (qs.length() > 0) {
                qs = "?" + qs;
            }
            conv = new Conversation(uri.getHost() + ":" + uri.getPort(), method, uri.getPath() + qs);
            for (Header hdr1 : hdrs = httpMethod.getRequestHeaders()) {
                conv.out(hdr1.getName() + ": " + hdr1.getValue());
            }
            try {
                log.info("Sending %s request to %s", method, uri);
                httpClient.executeMethod((HttpMethod)httpMethod);
            }
            catch (IOException e) {
                log.error("Error while sending request: %s", e);
                httpMethod.releaseConnection();
                this.error(log, action, conv, e);
                return new ReplicationResult(false, 0, e.getMessage());
            }
            conv.addLine("--");
            conv.in(httpMethod.getStatusLine().toString());
            for (Header hdr : hdrs = httpMethod.getResponseHeaders()) {
                conv.in(hdr.getName() + ": " + hdr.getValue());
            }
            conv.end();
            statusCode = httpMethod.getStatusCode();
            statusMsg = httpMethod.getStatusText();
            log.info("sent. Response: %d %s", statusCode, statusMsg);
            if (statusCode == 200) {
                InputStream in = null;
                try {
                    in = httpMethod.getResponseBodyAsStream();
                    if (in != null) {
                        DurboInput input = new DurboInput(in);
                        DurboInput.Element element = input.read();
                        if (!"outbox".equals(element.name())) {
                            String msg = "Not an outbox.";
                            throw new ReplicationException(msg);
                        }
                        long lastModified = 0L;
                        while (true) {
                            if ((element = input.read()) == null) {
                                break block28;
                            }
                            if (!element.isProperty()) continue;
                            DurboInput.Property p = (DurboInput.Property)element;
                            if ("jcr:lastModified".equals(element.name())) {
                                lastModified = ISO8601.parse((String)p.getValues()[0].getString()).getTimeInMillis();
                                continue;
                            }
                            if (!"jcr:data".equals(element.name())) continue;
                            result.add(this.createReplicationContent(factory, lastModified, p.getValues()[0].getStream()));
                        }
                    }
                    log.info("send: No data in response");
                }
                catch (IOException e) {
                    log.info("IOException while reading response: %s", e.getMessage());
                }
                finally {
                    IOUtils.closeQuietly((InputStream)in);
                }
            }
        }
        httpMethod.releaseConnection();
        if (statusCode != 200) {
            this.error(log, action, conv, null);
            return new ReplicationResult(false, statusCode, statusMsg);
        }
        Iterator<String> citer = conv.messages();
        while (citer.hasNext()) {
            log.info(citer.next());
        }
        log.info("Reverse replication successful.");
        return new ReplicationResult(true, statusCode, statusMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReplicationContent createReplicationContent(ReplicationContentFactory factory, long lastModified, InputStream in) throws IOException {
        File f = File.createTempFile("durbo", ".ser");
        FileOutputStream out = null;
        boolean spooled = false;
        try {
            out = FileUtils.openOutputStream((File)f);
            IOUtils.copy((InputStream)in, (OutputStream)out);
            spooled = true;
            ReplicationContent replicationContent = factory.create("application/cq5-replication-durbo", f, lastModified, true);
            return replicationContent;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((OutputStream)out);
            if (!spooled) {
                f.delete();
            }
        }
    }

    private void error(ReplicationLog log, ReplicationAction action, Conversation conv, Exception e) {
        String msg;
        Iterator<String> iter = conv.messages();
        String string = msg = iter.hasNext() ? "Conversation follows" : "No Conversation !";
        if (e == null) {
            log.error("Replication (%s) of %s not successful. %s", new Object[]{action.getType(), action.getPath(), msg});
        } else {
            log.error("Replication (%s) of %s not successful: %s %s", new Object[]{action.getType(), action.getPath(), e, msg});
        }
        while (iter.hasNext()) {
            log.error(iter.next());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Conversation {
        private static final Logger log = LoggerFactory.getLogger(Conversation.class);
        private final List<String> messages = new ArrayList<String>();

        private Conversation(String host, String method, String path) {
            this.addLine("------------------------------------------------");
            this.addLine("Sending message to " + host);
            this.out(method + " " + path + " HTTP/1.0");
        }

        public void end() {
            this.addLine("Message sent.");
            this.addLine("------------------------------------------------");
        }

        public void addLine(String line) {
            this.messages.add(line);
            log.debug(line);
        }

        public void out(String line) {
            this.addLine(">> " + line);
        }

        public void in(String line) {
            this.addLine("<< " + line);
        }

        public Iterator<String> messages() {
            return this.messages.iterator();
        }
    }

    private static class State
    implements TransportContext.Discardable {
        private HttpClient client;
        private ReplicationAction action;

        private State(HttpClient client) {
            this.client = client;
        }

        public void discard() {
            if (this.client != null) {
                HttpConnectionManager cMgr = this.client.getHttpConnectionManager();
                if (cMgr instanceof MultiThreadedHttpConnectionManager) {
                    ((MultiThreadedHttpConnectionManager)cMgr).shutdown();
                } else {
                    cMgr.closeIdleConnections(0L);
                }
                this.client = null;
            }
        }
    }
}

