/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.replication;

import com.day.cq.replication.AgentConfig;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationLog;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import org.apache.sling.event.EventPropertiesMap;
import org.apache.sling.event.EventUtil;
import org.osgi.service.event.Event;

public class ReplicationAction
implements Serializable {
    private static final long serialVersionUID = -151606943486007293L;
    public static final String EVENT_TOPIC = "com/day/cq/replication";
    public static final String PROPERTY_MODIFICATION_DATE = "modificationDate";
    public static final String PROPERTY_USER_ID = "userId";
    public static final String PROPERTY_PATH = "path";
    public static final String PROPERTY_TYPE = "type";
    public static final String PROPERTY_REVISION = "revision";
    private final ReplicationActionType type;
    private final String path;
    private final long time;
    private final String userId;
    private String revision;
    private transient AgentConfig config;
    private transient ReplicationLog log;

    public ReplicationAction(ReplicationActionType type, String path, long time, String userId, String revision) {
        if (type == null) {
            throw new IllegalArgumentException("Type must not be null.");
        }
        if (path == null) {
            throw new IllegalArgumentException("Path must not be null.");
        }
        if (userId == null) {
            throw new IllegalArgumentException("Userid must not be null.");
        }
        this.type = type;
        this.path = path;
        this.time = time == 0L ? System.currentTimeMillis() : time;
        this.userId = userId;
        this.revision = revision;
    }

    public ReplicationActionType getType() {
        return this.type;
    }

    public String getPath() {
        return this.path;
    }

    public String getRevision() {
        return this.revision;
    }

    public long getTime() {
        return this.time;
    }

    public String getUserId() {
        return this.userId;
    }

    public AgentConfig getConfig() {
        return this.config;
    }

    public void setConfig(AgentConfig config) {
        this.config = config;
    }

    public ReplicationLog getLog() {
        return this.log;
    }

    public void setLog(ReplicationLog log) {
        this.log = log;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ReplicationAction");
        sb.append("{type=").append((Object)this.type);
        sb.append(", path='").append(this.path).append('\'');
        sb.append(", time=").append(this.time);
        sb.append(", userId='").append(this.userId).append('\'');
        sb.append(", revision='").append(this.revision).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public static ReplicationAction fromEvent(Event evt) {
        if (!evt.getTopic().equals(EVENT_TOPIC)) {
            return null;
        }
        Object lastMod = evt.getProperty(PROPERTY_MODIFICATION_DATE);
        long time = 0L;
        if (lastMod instanceof Date) {
            time = ((Date)lastMod).getTime();
        } else if (lastMod instanceof Calendar) {
            time = ((Calendar)lastMod).getTimeInMillis();
        } else if (lastMod instanceof Long) {
            time = (Long)lastMod;
        }
        return new ReplicationAction(ReplicationActionType.fromName((String)evt.getProperty(PROPERTY_TYPE)), (String)evt.getProperty(PROPERTY_PATH), time, (String)evt.getProperty(PROPERTY_USER_ID), (String)evt.getProperty(PROPERTY_REVISION));
    }

    public EventPropertiesMap createProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(PROPERTY_TYPE, this.type.toString());
        properties.put(PROPERTY_PATH, this.path);
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(this.time);
        properties.put(PROPERTY_MODIFICATION_DATE, c);
        properties.put(PROPERTY_USER_ID, this.userId);
        if (this.revision != null) {
            properties.put(PROPERTY_REVISION, this.revision);
        }
        return new EventPropertiesMap(properties);
    }

    public Event toEvent() {
        return this.toEvent(false);
    }

    public Event toEvent(boolean distribute) {
        if (distribute) {
            return EventUtil.createDistributableEvent((String)EVENT_TOPIC, (Dictionary)this.createProperties());
        }
        return new Event(EVENT_TOPIC, (Dictionary)this.createProperties());
    }
}

