/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.replication.impl;

import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.replication.Agent;
import com.day.cq.replication.AgentConfig;
import com.day.cq.replication.AgentManager;
import com.day.cq.replication.ReplicationContent;
import com.day.cq.replication.ReplicationContentFacade;
import com.day.cq.replication.ReplicationContentFactory;
import com.day.cq.replication.impl.AbstractReplicationContent;
import com.day.cq.replication.impl.AgentConfigImpl;
import com.day.cq.replication.impl.AgentImpl;
import com.day.cq.replication.impl.FileContentFactory;
import com.day.cq.replication.impl.ServiceTracker;
import com.day.cq.replication.impl.queue.QueueListener;
import com.day.cq.replication.impl.queue.ReplicationJob;
import com.day.cq.replication.impl.queue.ReplicationQueueImpl;
import com.day.text.Text;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.sling.event.EventUtil;
import org.apache.sling.event.jobs.JobManager;
import org.apache.sling.event.jobs.JobProcessor;
import org.apache.sling.event.jobs.JobUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.resource.JcrPropertyMap;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentManagerImpl
implements AgentManager,
EventListener,
EventHandler,
JobProcessor {
    private static final Logger log = LoggerFactory.getLogger(AgentManagerImpl.class);
    private static final Set<String> IGNORED_PROPERTIES = new HashSet<String>();
    private static final String AGENT_CONFIG_ROOT_PATH = "/etc/replication";
    private static final String CONTENT_PATH = "/var/replication/data";
    private JobManager jobManager;
    private EventAdmin eventAdmin;
    private SlingRepository repository;
    private SlingSettingsService settingsService;
    private ServiceTracker serviceTracker;
    private Session session;
    private File dataDir;
    private boolean useFileStorage = false;
    private String dataRoot;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private Map<String, AgentImpl> agents = new LinkedHashMap<String, AgentImpl>();

    protected void activate(ComponentContext context) {
        this.lock.writeLock().lock();
        try {
            this.agents.clear();
            this.session = this.repository.loginAdministrative(null);
            this.session.getWorkspace().getObservationManager().addEventListener((EventListener)this, 31, AGENT_CONFIG_ROOT_PATH, true, null, null, true);
            if (this.useFileStorage) {
                File dir;
                String shared = this.repository.getDescriptor("com.day.crx.cluster.home");
                if (shared == null) {
                    log.info("No shared directory information available from repository.");
                    dir = new File(context.getBundleContext().getProperty("sling.home"));
                    File tmp = new File(dir.getParentFile(), "repository");
                    if (tmp.isDirectory() && (tmp = new File(tmp, "shared")).isDirectory()) {
                        dir = tmp;
                    }
                } else {
                    log.info("Using shared directory information from repository: {}", (Object)shared);
                    dir = new File(shared);
                }
                this.dataDir = new File(dir, "replication");
                log.info("Data directory is {}", (Object)this.dataDir.getPath());
            } else {
                String nodeId = this.settingsService.getSlingId();
                if (nodeId == null || nodeId.length() == 0) {
                    log.warn("No sling id? using random.");
                    nodeId = UUID.randomUUID().toString();
                }
                this.dataRoot = "/var/replication/data/" + nodeId;
                log.info("Repository content root: {}", (Object)this.dataRoot);
            }
            log.info("AgentManager service activated");
        }
        catch (RepositoryException e) {
            throw new IllegalStateException("Error while initializing agent manager", e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deactivate(ComponentContext context) {
        block6: {
            this.lock.writeLock().lock();
            try {
                for (AgentImpl agent : this.agents.values()) {
                    agent.stop();
                    agent.getContentFactory().close();
                }
                this.agents.clear();
                if (this.session == null) break block6;
                try {
                    this.session.getWorkspace().getObservationManager().removeEventListener((EventListener)this);
                }
                catch (RepositoryException repositoryException) {
                    // empty catch block
                }
                this.session.logout();
                this.session = null;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    public void onEvent(EventIterator events) {
        HashSet<String> paths = new HashSet<String>();
        while (events.hasNext()) {
            Event evt = events.nextEvent();
            try {
                String path = evt.getPath();
                if (evt.getType() != 1 && evt.getType() != 2) {
                    String name = Text.getName((String)path);
                    if (IGNORED_PROPERTIES.contains(name)) continue;
                    path = Text.getRelativeParent((String)path, (int)1);
                }
                if (path.endsWith("/jcr:content")) {
                    paths.add(Text.getRelativeParent((String)path, (int)1));
                    continue;
                }
                paths.add(path);
            }
            catch (RepositoryException e) {
                log.warn("Error while reading observation information: " + (Object)((Object)e));
            }
        }
        try {
            this.update(paths);
        }
        catch (RepositoryException e) {
            log.error("error while updating agents.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Agent> getAgents() {
        this.lock.readLock().lock();
        try {
            if (this.agents.isEmpty()) {
                this.lock.readLock().unlock();
                try {
                    Node root = this.session.getRootNode().getNode(AGENT_CONFIG_ROOT_PATH.substring(1));
                    this.scan(root);
                }
                catch (RepositoryException e) {
                    log.error("Unable to read replication agents: " + (Object)((Object)e));
                }
                finally {
                    this.lock.readLock().lock();
                }
            }
            LinkedHashMap<String, Agent> agents = new LinkedHashMap<String, Agent>();
            for (AgentImpl agent : this.agents.values()) {
                agents.put(agent.getId(), agent);
            }
            LinkedHashMap<String, Agent> linkedHashMap = agents;
            return linkedHashMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private void scan(Node node) throws RepositoryException {
        NodeIterator iter = node.getNodes();
        while (iter.hasNext()) {
            Node n = iter.nextNode();
            if (n.getName().equals("jcr:content")) continue;
            this.update(n);
            this.scan(n);
        }
    }

    private void update(Set<String> paths) throws RepositoryException {
        for (String path : paths) {
            if (this.session.itemExists(path)) {
                Node node = this.session.getRootNode().getNode(path.substring(1));
                this.update(node);
                continue;
            }
            this.remove(path);
        }
    }

    private boolean isRunModeActive(String[] runModesToCheck) {
        boolean result = false;
        for (String m : runModesToCheck) {
            if ((m = m.trim()).equals("*")) {
                result = true;
                break;
            }
            if (!this.settingsService.getRunModes().contains(m)) continue;
            result = true;
            break;
        }
        return result;
    }

    private AgentConfig loadConfig(Node node) throws RepositoryException {
        if (node.hasNode("jcr:content")) {
            Node parent = node.getParent();
            String[] runModes = null;
            while (runModes == null && parent.getDepth() > 0 && !parent.getPath().equals(AGENT_CONFIG_ROOT_PATH)) {
                String name = parent.getName();
                if (name.equals("agents")) {
                    runModes = new String[]{};
                } else if (name.startsWith("agents.")) {
                    String[] segs = Text.explode((String)name, (int)46);
                    runModes = new String[segs.length - 1];
                    System.arraycopy(segs, 1, runModes, 0, runModes.length);
                }
                parent = parent.getParent();
            }
            String path = node.getPath();
            if (runModes == null) {
                log.info("Possible agent at {} has no runmode.", (Object)path);
            } else {
                if (this.isRunModeActive(runModes)) {
                    log.info("Possible agent at {} is active.", (Object)path);
                    Node content = node.getNode("jcr:content");
                    JcrPropertyMap props = new JcrPropertyMap(content);
                    HashMap<String, Object> properties = new HashMap<String, Object>((Map<String, Object>)props);
                    return new AgentConfigImpl(properties, content.getPath());
                }
                log.info("Possible agent at {} is not active.", (Object)node.getPath());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(Node node) throws RepositoryException {
        AgentConfig config = this.loadConfig(node);
        String path = node.getPath();
        if (config == null) {
            this.remove(path);
        } else {
            this.lock.writeLock().lock();
            try {
                AgentImpl agent = this.agents.remove(path);
                if (agent == null) {
                    ReplicationContentFactory factory;
                    String id = Text.getName((String)path);
                    log.info("AgentConfig at {} added.", (Object)path);
                    if (this.dataDir == null) {
                        Session agentSession = this.repository.loginAdministrative(null);
                        factory = new RepositoryContentFactory(agentSession, id);
                    } else {
                        factory = new FileContentFactory(this.dataDir, id);
                    }
                    agent = new AgentImpl(id, config, this.serviceTracker, this, factory);
                } else {
                    log.info("AgentConfig at {} updated.", (Object)path);
                    agent.update(config);
                }
                this.agents.put(path, agent);
                NodeIterator iter = node.getParent().getNodes();
                while (iter.hasNext()) {
                    String p = iter.nextNode().getPath();
                    agent = this.agents.remove(p);
                    if (agent == null) continue;
                    this.agents.put(p, agent);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(String path) {
        AgentImpl agent;
        this.lock.writeLock().lock();
        try {
            agent = this.agents.remove(path);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (agent != null) {
            log.info("AgentConfig at {} removed.", (Object)path);
            agent.destroy();
        }
    }

    private Node getOutboxNode(String agentId) throws RepositoryException {
        String path = "/var/replication/data/" + agentId;
        if (this.session.nodeExists(path)) {
            return this.session.getNode(path);
        }
        return JcrUtil.createPath((String)path, (String)"sling:Folder", (String)"sling:Folder", (Session)this.session, (boolean)true);
    }

    private Node getNewStorageNode() throws RepositoryException {
        String name = UUID.randomUUID().toString();
        String path = this.dataRoot + "/" + name.substring(0, 2);
        Node parent = null;
        int num = 0;
        while (parent == null) {
            try {
                if (this.session.nodeExists(path)) {
                    parent = this.session.getNode(path);
                    continue;
                }
                parent = JcrUtil.createPath((String)path, (String)"sling:Folder", (String)"sling:Folder", (Session)this.session, (boolean)true);
            }
            catch (RepositoryException e) {
                log.warn("Error while creating storage parent", (Throwable)e);
                this.session.refresh(false);
                if (num++ > 10) {
                    throw e;
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e1) {}
            }
        }
        return JcrUtil.createUniqueNode(parent, (String)name, (String)"nt:file", (Session)this.session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Calendar getLastPollTime(String agentId) {
        this.lock.writeLock().lock();
        try {
            Node ob = this.getOutboxNode(agentId);
            if (!ob.hasProperty("cq:lastPoll")) return null;
            Calendar calendar = ob.getProperty("cq:lastPoll").getDate();
            this.lock.writeLock().unlock();
            return calendar;
        }
        catch (RepositoryException e) {
            log.error("Error while fetching last poll time for agent {}", (Object)agentId, (Object)e);
            return null;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setLastPollTime(String agentId, Calendar time) {
        this.lock.writeLock().lock();
        try {
            try {
                Node ob = this.getOutboxNode(agentId);
                ob.setProperty("cq:lastPoll", time);
                ob.save();
            }
            catch (RepositoryException e) {
                log.error("Error while fetching last poll time for agent {}", (Object)agentId, (Object)e);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void handleEvent(org.osgi.service.event.Event event) {
        if (EventUtil.isLocal((org.osgi.service.event.Event)event)) {
            JobUtil.processJob((org.osgi.service.event.Event)event, (JobProcessor)this);
        }
    }

    public boolean process(org.osgi.service.event.Event jobEvent) {
        ReplicationJob job = new ReplicationJob(jobEvent);
        String queueName = job.getQueueName();
        Agent a = this.getAgents().get(queueName);
        if (a == null) {
            log.error("Job contains unknown agent: {}. Discarding Job {}", (Object)queueName, (Object)job);
            return true;
        }
        ReplicationQueueImpl queue = (ReplicationQueueImpl)a.getQueue();
        if (queue == null) {
            log.error("Job contains agent which is not started: {}. waiting {}", (Object)queueName, (Object)job);
            return false;
        }
        log.info("Processing job for agent {}", (Object)queueName);
        try {
            long start = System.currentTimeMillis();
            boolean ret = queue.process(job);
            long end = System.currentTimeMillis();
            log.info("Job for agent {} processed in {}ms. {}", new Object[]{queueName, String.valueOf(end - start), ret ? "Ok." : "Failed."});
            return ret;
        }
        catch (Throwable e) {
            log.error("Error during processing of replication.", e);
            return false;
        }
    }

    public ReplicationQueueImpl createQueue(String name, QueueListener listener) {
        ReplicationQueueImpl q = new ReplicationQueueImpl(this.eventAdmin, this.jobManager, name);
        q.open(listener);
        return q;
    }

    static {
        IGNORED_PROPERTIES.add("cq:name");
        IGNORED_PROPERTIES.add("cq:siblingOrder");
        IGNORED_PROPERTIES.add("cq:parentPath");
        IGNORED_PROPERTIES.add("cq:childrenOrder");
        IGNORED_PROPERTIES.add("jcr:baseVersion");
        IGNORED_PROPERTIES.add("jcr:isCheckedOut");
        IGNORED_PROPERTIES.add("jcr:predecessors");
    }

    protected void bindJobManager(JobManager jobManager) {
        this.jobManager = jobManager;
    }

    protected void unbindJobManager(JobManager jobManager) {
        if (this.jobManager == jobManager) {
            this.jobManager = null;
        }
    }

    protected void bindEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    protected void unbindEventAdmin(EventAdmin eventAdmin) {
        if (this.eventAdmin == eventAdmin) {
            this.eventAdmin = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindSettingsService(SlingSettingsService slingSettingsService) {
        this.settingsService = slingSettingsService;
    }

    protected void unbindSettingsService(SlingSettingsService slingSettingsService) {
        if (this.settingsService == slingSettingsService) {
            this.settingsService = null;
        }
    }

    protected void bindServiceTracker(ServiceTracker serviceTracker) {
        this.serviceTracker = serviceTracker;
    }

    protected void unbindServiceTracker(ServiceTracker serviceTracker) {
        if (this.serviceTracker == serviceTracker) {
            this.serviceTracker = null;
        }
    }

    private class RepositoryContentFactory
    implements ReplicationContentFactory {
        private final String agentId;
        private final Session agentSession;

        private RepositoryContentFactory(Session agentSession, String agentId) throws RepositoryException {
            this.agentSession = agentSession;
            this.agentId = agentId;
            log.info("RepositoryContentFactory for {} initialized.", (Object)agentId);
        }

        public ReplicationContent create(String mimeType, File file, boolean isTemp) throws IOException {
            return this.create(mimeType, file, file.lastModified(), isTemp);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ReplicationContent create(String mimeType, File file, long lastModified, boolean isTemp) throws IOException {
            AgentManagerImpl.this.lock.writeLock().lock();
            try {
                if (AgentManagerImpl.this.session == null) {
                    log.warn("Service already stopped. unable to create replication content.");
                    throw new IOException("Service Stopped.");
                }
                Node fileNode = AgentManagerImpl.this.getNewStorageNode();
                Node contentNode = fileNode.addNode("jcr:content", "nt:unstructured");
                contentNode.setProperty("jcr:mimeType", mimeType);
                Calendar mod = Calendar.getInstance();
                mod.setTimeInMillis(lastModified);
                contentNode.setProperty("jcr:lastModified", mod);
                long size = file.length();
                Binary binary = null;
                try {
                    binary = AgentManagerImpl.this.session.getValueFactory().createBinary((InputStream)FileUtils.openInputStream((File)file));
                    contentNode.setProperty("jcr:data", binary);
                }
                finally {
                    if (binary != null) {
                        binary.dispose();
                    }
                }
                AgentManagerImpl.this.session.save();
                String path = fileNode.getPath();
                if (isTemp) {
                    FileUtils.deleteQuietly((File)file);
                }
                log.info("Created new repository content at {} (size={}, lastmod={})", new Object[]{path, size, ISO8601.format((Calendar)mod)});
                RepositoryContent repositoryContent = new RepositoryContent(path, mimeType);
                return repositoryContent;
            }
            catch (RepositoryException e) {
                IOException e1 = new IOException(e.toString());
                e1.initCause(e);
                throw e1;
            }
            finally {
                AgentManagerImpl.this.lock.writeLock().unlock();
            }
        }

        public ReplicationContent create(ReplicationContentFacade facade) {
            if (facade == null) {
                return ReplicationContent.VOID;
            }
            return new RepositoryContent(facade);
        }

        public void close() {
            if (this.agentSession.isLive()) {
                this.agentSession.logout();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class RepositoryContent
        extends AbstractReplicationContent {
            private static final long serialVersionUID = 6506881886574345693L;

            RepositoryContent(String path, String contentType) {
                super(path, contentType);
            }

            RepositoryContent(ReplicationContentFacade facade) {
                super(facade);
            }

            @Override
            public InputStream getInputStream() throws IOException {
                try {
                    return this.getNode(RepositoryContentFactory.this.agentSession).getProperty("jcr:content/jcr:data").getBinary().getStream();
                }
                catch (RepositoryException e) {
                    IOException e1 = new IOException(e.toString());
                    e1.initCause(e);
                    throw e1;
                }
            }

            @Override
            public long getContentLength() {
                try {
                    return this.getNode(RepositoryContentFactory.this.agentSession).getProperty("jcr:content/jcr:data").getBinary().getSize();
                }
                catch (Exception e) {
                    log.warn("unable to retrieve content length of " + this.facade.getPath(), (Throwable)e);
                    return -1L;
                }
            }

            @Override
            public long getLastModified() {
                try {
                    return this.getNode(RepositoryContentFactory.this.agentSession).getProperty("jcr:content/jcr:lastModified").getDate().getTimeInMillis();
                }
                catch (Exception e) {
                    log.warn("unable to retrieve last modified date of " + this.facade.getPath(), (Throwable)e);
                    return -1L;
                }
            }

            private Node getNode(Session s) throws IOException {
                try {
                    if (!s.isLive()) {
                        log.warn("Service already stopped. unable to create replication content.");
                        throw new IOException("Service Stopped.");
                    }
                    if (!s.nodeExists(this.facade.getPath())) {
                        throw new FileNotFoundException(this.facade.getPath());
                    }
                    return s.getNode(this.facade.getPath());
                }
                catch (RepositoryException e) {
                    IOException e1 = new IOException(e.toString());
                    e1.initCause(e);
                    throw e1;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            @Override
            public void acquire(String agentName) {
                AgentManagerImpl.this.lock.writeLock().lock();
                try {
                    int attempts = 0;
                    while (true) {
                        if (attempts < 10) {
                            if (AgentManagerImpl.this.session == null || !AgentManagerImpl.this.session.isLive()) {
                                log.warn("Service already stopped. unable to update replication content.");
                                return;
                            }
                            if (!AgentManagerImpl.this.session.nodeExists(this.facade.getPath())) {
                                log.warn("Replication content node does not exist {}.", (Object)this.facade.getPath());
                                return;
                            }
                            Node node = AgentManagerImpl.this.session.getNode(this.facade.getPath() + "/jcr:content");
                            HashSet<String> ret = new HashSet<String>();
                            if (node.hasProperty("cq:agents")) {
                                for (Value v : node.getProperty("cq:agents").getValues()) {
                                    ret.add(v.getString());
                                }
                            }
                            if (ret.add(agentName)) {
                                node.setProperty("cq:agents", ret.toArray(new String[ret.size()]));
                                try {
                                    AgentManagerImpl.this.session.save();
                                    return;
                                }
                                catch (RepositoryException e) {
                                    AgentManagerImpl.this.session.refresh(false);
                                    ++attempts;
                                }
                                continue;
                            }
                            return;
                        }
                        log.error("Unable to update 'agents' property of {} after {} attempts", (Object)this.facade.getPath(), (Object)attempts);
                        break;
                        {
                            catch (RepositoryException e) {
                                log.warn("unable to update agents of " + this.facade.getPath(), (Throwable)e);
                                break;
                            }
                            finally {
                                continue;
                            }
                        }
                        break;
                    }
                }
                finally {
                    AgentManagerImpl.this.lock.writeLock().unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void release(String agentName) {
                AgentManagerImpl.this.lock.writeLock().lock();
                try {
                    int attempts = 0;
                    HashSet<String> ret = new HashSet<String>();
                    while (attempts++ < 10) {
                        if (AgentManagerImpl.this.session == null || !AgentManagerImpl.this.session.isLive()) {
                            log.warn("Service already stopped. unable to update replication content.");
                            return;
                        }
                        if (!AgentManagerImpl.this.session.nodeExists(this.facade.getPath())) {
                            log.warn("Replication content node does not exist {}.", (Object)this.facade.getPath());
                            return;
                        }
                        ret.clear();
                        Node node = AgentManagerImpl.this.session.getNode(this.facade.getPath() + "/jcr:content");
                        if (node.hasProperty("cq:agents")) {
                            for (Value v : node.getProperty("cq:agents").getValues()) {
                                ret.add(v.getString());
                            }
                        }
                        if (!ret.remove(agentName) || ret.isEmpty()) break;
                        node.setProperty("cq:agents", ret.toArray(new String[ret.size()]));
                        try {
                            AgentManagerImpl.this.session.save();
                            break;
                        }
                        catch (RepositoryException e) {
                            AgentManagerImpl.this.session.refresh(false);
                        }
                    }
                    if (attempts == 10) {
                        log.error("Unable to update 'agents' property of {} after {} attempts", (Object)this.facade.getPath(), (Object)attempts);
                    }
                    if (ret.isEmpty()) {
                        this.destroyLocked();
                    }
                }
                catch (RepositoryException e) {
                    log.warn("unable to update agents of " + this.facade.getPath(), (Throwable)e);
                }
                finally {
                    AgentManagerImpl.this.lock.writeLock().unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Collection<String> getAcquiredBy() {
                AgentManagerImpl.this.lock.readLock().lock();
                try {
                    if (AgentManagerImpl.this.session == null || !AgentManagerImpl.this.session.isLive()) {
                        log.warn("Service already stopped. unable to create replication content.");
                        Set<String> set = Collections.emptySet();
                        return set;
                    }
                    if (!AgentManagerImpl.this.session.nodeExists(this.facade.getPath())) {
                        log.warn("Replication content node does not exist {}.", (Object)this.facade.getPath());
                        Set<String> set = Collections.emptySet();
                        return set;
                    }
                    Node node = AgentManagerImpl.this.session.getNode(this.facade.getPath() + "/jcr:content");
                    HashSet<String> ret = new HashSet<String>();
                    if (node.hasProperty("cq:agents")) {
                        for (Value v : node.getProperty("cq:agents").getValues()) {
                            ret.add(v.getString());
                        }
                    }
                    HashSet<String> hashSet = ret;
                    return hashSet;
                }
                catch (RepositoryException e) {
                    log.warn("unable to retrieve agents of " + this.facade.getPath(), (Throwable)e);
                    Set<String> set = Collections.emptySet();
                    return set;
                }
                finally {
                    AgentManagerImpl.this.lock.readLock().unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void destroy() {
                AgentManagerImpl.this.lock.writeLock().lock();
                try {
                    this.destroyLocked();
                }
                finally {
                    AgentManagerImpl.this.lock.writeLock().unlock();
                }
            }

            private void destroyLocked() {
                if (AgentManagerImpl.this.session == null || !AgentManagerImpl.this.session.isLive()) {
                    log.warn("Service already stopped. unable to destroy replication content.");
                    return;
                }
                int num = 0;
                while (num++ < 10) {
                    try {
                        if (!AgentManagerImpl.this.session.nodeExists(this.facade.getPath())) continue;
                        AgentManagerImpl.this.session.removeItem(this.facade.getPath());
                        AgentManagerImpl.this.session.save();
                        return;
                    }
                    catch (RepositoryException e) {
                        log.warn("Unable to destroy replication content", (Throwable)e);
                        try {
                            AgentManagerImpl.this.session.refresh(false);
                        }
                        catch (RepositoryException repositoryException) {}
                    }
                }
                log.error("Unable to delete replication content of {} after {} attempts", (Object)this.facade.getPath(), (Object)num);
            }
        }
    }
}

