/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.replication.impl;

import com.day.cq.commons.SymmetricCrypt;
import java.util.List;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.SlingPostProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigPostProcessor
implements SlingPostProcessor {
    public void process(SlingHttpServletRequest request, List<Modification> changes) throws Exception {
        Session session = null;
        for (Modification mod : changes) {
            switch (mod.getType()) {
                case MODIFY: 
                case CREATE: {
                    String path = mod.getSource();
                    if (!path.startsWith("/etc/replication/") || !path.endsWith("transportPassword") || session != null) break;
                    session = (Session)request.getResourceResolver().adaptTo(Session.class);
                    this.fix(session.getProperty(path));
                }
            }
        }
    }

    private void fix(Property p) throws RepositoryException {
        String pwd = p.getString();
        if (pwd.length() > 0 && !pwd.startsWith("{DES}")) {
            p.setValue(SymmetricCrypt.encrypt((String)pwd));
        }
    }
}

