/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.replication.impl;

import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationException;
import com.day.cq.replication.content.durbo.DurboImporter;
import com.day.jcr.vault.fs.api.ProgressTrackerListener;
import com.day.jcr.vault.fs.spi.ServiceProviderFactory;
import com.day.jcr.vault.packaging.ImportOptions;
import com.day.jcr.vault.packaging.JcrPackage;
import com.day.jcr.vault.packaging.JcrPackageManager;
import com.day.jcr.vault.packaging.PackagingService;
import com.day.jcr.vault.util.DefaultProgressListener;
import java.io.PrintWriter;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.SlingHttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationReceiver {
    private static final Logger log = LoggerFactory.getLogger(ReplicationReceiver.class);
    private final ReplicationActionType type;
    private final String path;
    private PrintWriter writer;

    public ReplicationReceiver(ReplicationActionType type, String path) {
        this.type = type;
        this.path = path;
    }

    public void setWriter(PrintWriter writer) {
        this.writer = writer;
    }

    public void receive(SlingHttpServletRequest request, boolean createVersion) throws ReplicationException {
        Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
        Node page = null;
        if (this.type == ReplicationActionType.ACTIVATE) {
            page = new DurboImporter().createPage(request, this.path);
        }
        this.onReceived(session, page);
    }

    public void onReceived(Session session, Node page) throws ReplicationException {
        try {
            switch (this.type) {
                case ACTIVATE: {
                    this.onActivate(page);
                    break;
                }
                case DELETE: {
                    this.onDelete(session);
                    break;
                }
                case DEACTIVATE: {
                    this.onDeactivate(session);
                    break;
                }
                case TEST: {
                    this.onTest();
                    break;
                }
                default: {
                    throw new ReplicationException("Unknown ReplicationActionType: " + (Object)((Object)this.type));
                }
            }
            if (this.writer != null) {
                this.writer.print("ReplicationAction " + this.type.toString() + " ok.");
            }
        }
        catch (ReplicationException e) {
            log.error("Unable to receive replication.", (Throwable)e);
            throw e;
        }
    }

    private void onActivate(Node page) throws ReplicationException {
        try {
            if (page.getPath().startsWith("/etc/packages/") && page.isNodeType("nt:file")) {
                this.writer.printf("Content package received at %s. Starting import.%n", this.path);
                JcrPackageManager packMgr = PackagingService.getPackageManager((Session)page.getSession());
                JcrPackage pack = packMgr.open(page);
                ImportOptions opts = new ImportOptions();
                opts.setListener((ProgressTrackerListener)new DefaultProgressListener(this.writer));
                opts.setNtInstaller(ServiceProviderFactory.getProvider().getDefaultNodeTypeInstaller(page.getSession()));
                pack.extract(opts);
            }
        }
        catch (Exception e) {
            log.error("Error while unpacking package at " + this.path, (Throwable)e);
        }
    }

    private void onDelete(Session session) throws ReplicationException {
        try {
            if (session.itemExists(this.path)) {
                session.getItem(this.path).remove();
                session.save();
            }
        }
        catch (RepositoryException e) {
            throw new ReplicationException((Exception)((Object)e));
        }
    }

    private void onDeactivate(Session session) throws ReplicationException {
        try {
            if (session.itemExists(this.path)) {
                session.getItem(this.path).remove();
                session.save();
            }
        }
        catch (RepositoryException e) {
            throw new ReplicationException((Exception)((Object)e));
        }
    }

    private void onTest() {
    }
}

