/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.replication.impl;

import com.day.cq.replication.AgentManager;
import com.day.cq.replication.ReplicationStatus;
import com.day.cq.replication.impl.ReplicationStatusImpl;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicationStatusAdapterFactory
implements AdapterFactory {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Class<Resource> RESOURCE_CLASS = Resource.class;
    private static final Class<ReplicationStatus> REPLICATION_STATUS_CLASS = ReplicationStatus.class;
    protected static final String[] ADAPTER_CLASSES = new String[]{REPLICATION_STATUS_CLASS.getName()};
    protected static final String[] ADAPTABLE_CLASSES = new String[]{RESOURCE_CLASS.getName()};
    private AgentManager agentManager;

    public <AdapterType> AdapterType getAdapter(Object adaptable, Class<AdapterType> type) {
        if (adaptable instanceof Resource) {
            return this.getAdapter((Resource)adaptable, type);
        }
        this.logger.warn("Unable to handle adaptable {}", (Object)adaptable.getClass().getName());
        return null;
    }

    private <AdapterType> AdapterType getAdapter(Resource resource, Class<AdapterType> type) {
        if (type == REPLICATION_STATUS_CLASS) {
            Resource contentResource = resource.getResourceResolver().getResource(resource.getPath() + '/' + "jcr:content");
            if (contentResource == null) {
                contentResource = resource;
            }
            return (AdapterType)new ReplicationStatusImpl(this.agentManager, resource.getPath(), contentResource);
        }
        this.logger.debug("Unable to adapt resource to type {}", (Object)type.getName());
        return null;
    }

    protected void bindAgentManager(AgentManager agentManager) {
        this.agentManager = agentManager;
    }

    protected void unbindAgentManager(AgentManager agentManager) {
        if (this.agentManager == agentManager) {
            this.agentManager = null;
        }
    }
}

