/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.replication.impl;

import com.day.cq.replication.Agent;
import com.day.cq.replication.AgentManager;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationQueue;
import com.day.cq.replication.ReplicationStatus;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicationStatusImpl
implements ReplicationStatus {
    private final AgentManager agentMgr;
    private final String path;
    private final ValueMap properties;
    private List<ReplicationQueue.Entry> status;
    private List<ReplicationQueue.Entry> pending;
    private Boolean delivered;

    public ReplicationStatusImpl(AgentManager agentMgr, String path, Resource resource) {
        this.agentMgr = agentMgr;
        this.path = path;
        this.properties = ResourceUtil.getValueMap((Resource)resource);
    }

    @Override
    public List<ReplicationQueue.Entry> getQueueStatus() {
        if (this.status == null) {
            this.status = new LinkedList<ReplicationQueue.Entry>();
            for (Agent agent : this.agentMgr.getAgents().values()) {
                ReplicationQueue queue = agent.getQueue();
                if (queue == null) continue;
                for (ReplicationQueue.Entry entry : queue.entries(this.path)) {
                    this.status.add(entry);
                }
            }
        }
        return this.status;
    }

    @Override
    public boolean isPending() {
        return !this.getPending().isEmpty();
    }

    @Override
    public List<ReplicationQueue.Entry> getPending() {
        if (this.pending == null) {
            this.pending = new LinkedList<ReplicationQueue.Entry>();
            ReplicationActionType type = this.getLastReplicationAction();
            Calendar last = this.getLastPublished();
            if (type != null && last != null) {
                long time = last.getTimeInMillis();
                for (ReplicationQueue.Entry s : this.getQueueStatus()) {
                    if (s.getAction().getType() != type || s.getAction().getTime() != time) continue;
                    this.pending.add(s);
                }
            }
        }
        return this.pending;
    }

    @Override
    public boolean isActivated() {
        return this.getLastReplicationAction() == ReplicationActionType.ACTIVATE;
    }

    @Override
    public boolean isDeactivated() {
        return this.getLastReplicationAction() == ReplicationActionType.DEACTIVATE;
    }

    @Override
    public boolean isDelivered() {
        if (this.delivered == null) {
            ReplicationActionType type = this.getLastReplicationAction();
            this.delivered = type == ReplicationActionType.ACTIVATE ? Boolean.valueOf(!this.isPending()) : (type == ReplicationActionType.DEACTIVATE || type == ReplicationActionType.DELETE ? Boolean.valueOf(this.isPending()) : Boolean.valueOf(false));
        }
        return this.delivered;
    }

    @Override
    public boolean isPublished() {
        return this.isDelivered();
    }

    @Override
    public Calendar getLastPublished() {
        if (this.properties.containsKey((Object)"cq:lastReplicated")) {
            return (Calendar)this.properties.get("cq:lastReplicated", Calendar.class);
        }
        return (Calendar)this.properties.get("cq:lastPublished", Calendar.class);
    }

    @Override
    public String getLastPublishedBy() {
        if (this.properties.containsKey((Object)"cq:lastReplicatedBy")) {
            return (String)this.properties.get("cq:lastReplicatedBy", String.class);
        }
        return (String)this.properties.get("cq:lastPublishedBy", String.class);
    }

    @Override
    public ReplicationActionType getLastReplicationAction() {
        return ReplicationActionType.fromName((String)this.properties.get("cq:lastReplicationAction", String.class));
    }
}

