/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.replication.transport;

import com.day.cq.replication.AgentConfig;
import com.day.cq.replication.OutboxManager;
import com.day.cq.replication.ReplicationContent;
import com.day.cq.replication.ReplicationContentFactory;
import com.day.cq.replication.ReplicationException;
import com.day.cq.replication.ReplicationResult;
import com.day.cq.replication.ReplicationTransaction;
import com.day.cq.replication.TransportContext;
import com.day.cq.replication.TransportHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryTransportHandler
implements TransportHandler {
    private static final String URI_PREFIX = "repo://";
    private static final ReplicationResult OK = new ReplicationResult(true, 200, "OK");
    protected OutboxManager outboxManager;

    @Override
    public boolean canHandle(AgentConfig config) {
        String uri = config == null ? null : config.getTransportURI();
        return uri != null && uri.startsWith(URI_PREFIX);
    }

    @Override
    public ReplicationResult deliver(TransportContext ctx, ReplicationTransaction tx) throws ReplicationException {
        InputStream in;
        ReplicationContent rc = tx.getContent();
        if (rc == null) {
            return OK;
        }
        try {
            in = tx.getContent().getInputStream();
            if (in == null) {
                return OK;
            }
        }
        catch (IOException e) {
            String msg = "Unable to get content input stream.";
            throw new ReplicationException(msg, e);
        }
        this.outboxManager.put(in);
        return new ReplicationResult(true, 200, "OK");
    }

    @Override
    public ReplicationResult poll(TransportContext ctx, ReplicationTransaction tx, List<ReplicationContent> result, ReplicationContentFactory factory) throws ReplicationException {
        String msg = "Unsupported operation.";
        throw new ReplicationException(msg);
    }

    protected void bindOutboxManager(OutboxManager outboxManager) {
        this.outboxManager = outboxManager;
    }

    protected void unbindOutboxManager(OutboxManager outboxManager) {
        if (this.outboxManager == outboxManager) {
            this.outboxManager = null;
        }
    }
}

