/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.replication.content.durbo;

import com.day.cq.replication.ContentBuilder;
import com.day.cq.replication.ReplicationAction;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationContent;
import com.day.cq.replication.ReplicationContentFactory;
import com.day.cq.replication.ReplicationException;
import com.day.cq.replication.content.durbo.DurboUtil;
import com.day.durbo.DurboNamespaceResolver;
import com.day.durbo.DurboOutput;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessControlException;
import java.util.ArrayList;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import org.apache.commons.io.IOUtils;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DurboContentBuilder
implements ContentBuilder {
    private static final String PN_CHILDREN_ORDER = "cq:childrenOrder";
    private static final String PN_SIBLING_ORDER = "cq:siblingOrder";
    public static final String NAME = "durbo";
    public static final String TITLE = "Durbo";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private SlingRepository repository;

    public String getName() {
        return NAME;
    }

    public String getTitle() {
        return TITLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplicationContent create(Session session, ReplicationAction action, ReplicationContentFactory factory) throws ReplicationException {
        ReplicationContent replicationContent;
        block14: {
            if (action.getType() != ReplicationActionType.ACTIVATE) {
                return ReplicationContent.VOID;
            }
            Node node = (Node)session.getItem(action.getPath());
            if (action.getRevision() == null) {
                return this.create(factory, node);
            }
            Session admin = null;
            try {
                admin = this.repository.loginAdministrative(null);
                node = admin.getNode(node.getPath());
                replicationContent = this.create(factory, node, action.getRevision());
                if (admin == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (admin != null) {
                        try {
                            admin.logout();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                catch (AccessControlException e) {
                    this.log.error("agent cannot access {}: {}", (Object)action.getPath(), (Object)e.getMessage());
                    throw new ReplicationException("Agent is unable to access " + action.getPath(), e);
                }
                catch (IOException io) {
                    this.log.error("IO exception occurred during serialization of page {}.", (Object)action.getPath());
                    throw new ReplicationException("RepositoryException during serialization", io);
                }
                catch (RepositoryException e) {
                    this.log.error("Repository exception occurred during serialization of page {}.", (Object)action.getPath());
                    throw new ReplicationException("RepositoryException during serialization", (Exception)((Object)e));
                }
            }
            try {
                admin.logout();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return replicationContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReplicationContent create(ReplicationContentFactory factory, Node node) throws IOException, RepositoryException {
        ReplicationContent replicationContent;
        block13: {
            File blob = null;
            FileOutputStream os = null;
            try {
                String siblingOrder;
                String childrenOrder = DurboUtil.putNodeNames(node);
                StringBuffer nodeTypesBuffer = new StringBuffer();
                Session admin = null;
                try {
                    admin = this.repository.loginAdministrative(null);
                    Node parentNode = admin.getNode(node.getPath()).getParent();
                    siblingOrder = DurboUtil.putNodeNames(parentNode);
                    while (parentNode.getDepth() > 0) {
                        if (nodeTypesBuffer.length() > 0) {
                            nodeTypesBuffer.append(',');
                        }
                        nodeTypesBuffer.append(parentNode.getPrimaryNodeType().getName());
                        parentNode = parentNode.getParent();
                    }
                }
                finally {
                    if (admin != null) {
                        admin.logout();
                    }
                }
                blob = File.createTempFile("cq5", ".durbo");
                os = new FileOutputStream(blob);
                DurboOutput output = new DurboOutput((OutputStream)os, (DurboNamespaceResolver)new DefaultDurboNamespaceResolver(node.getSession()), 2.1);
                output.writeProperty("startPath", node.getPath());
                output.writeProperty("orderSiblings", siblingOrder);
                output.writeProperty("orderChildren", childrenOrder);
                if (nodeTypesBuffer.length() > 0) {
                    output.writeProperty("parentNodeTypes", nodeTypesBuffer.toString());
                }
                this.write(output, node);
                output.close();
                ((OutputStream)os).close();
                os = null;
                replicationContent = factory.create("application/cq5-replication-durbo", blob, true);
                if (os == null) break block13;
            }
            catch (Throwable throwable) {
                if (os != null) {
                    IOUtils.closeQuietly(os);
                    if (blob != null) {
                        blob.delete();
                    }
                }
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)os);
            if (blob != null) {
                blob.delete();
            }
        }
        return replicationContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReplicationContent create(ReplicationContentFactory factory, Node node, String revision) throws RepositoryException, IOException, ReplicationException {
        ReplicationContent replicationContent;
        block20: {
            File blob = null;
            FileOutputStream os = null;
            try {
                boolean rootIsVersioned;
                VersionHistory history;
                Node content = node.hasNode("jcr:content") ? node.getNode("jcr:content") : null;
                StringBuffer nodeTypesBuffer = new StringBuffer();
                if (node.isNodeType("mix:versionable")) {
                    history = node.getVersionHistory();
                    rootIsVersioned = true;
                } else if (content != null && content.isNodeType("mix:versionable")) {
                    history = content.getVersionHistory();
                    rootIsVersioned = false;
                } else {
                    throw new ReplicationException("Content node is not versionable at " + node.getPath());
                }
                Version version = null;
                try {
                    version = history.getVersion(revision);
                }
                catch (VersionException e) {
                    // empty catch block
                }
                if (version == null) {
                    try {
                        version = history.getVersionByLabel(revision);
                    }
                    catch (VersionException e) {
                        // empty catch block
                    }
                }
                if (version == null) {
                    throw new ReplicationException("Version " + revision + " not found for path " + node.getPath());
                }
                Node root = version.getNode("jcr:frozenNode");
                content = rootIsVersioned ? root.getNode("jcr:content") : root;
                String childrenOrder = content.hasProperty(PN_CHILDREN_ORDER) ? content.getProperty(PN_CHILDREN_ORDER).getString() : DurboUtil.putNodeNames(node);
                Node parentNode = node.getParent();
                String siblingOrder = content.hasProperty(PN_SIBLING_ORDER) ? content.getProperty(PN_SIBLING_ORDER).getString() : DurboUtil.putNodeNames(parentNode);
                while (parentNode.getDepth() > 0) {
                    if (nodeTypesBuffer.length() > 0) {
                        nodeTypesBuffer.append(',');
                    }
                    nodeTypesBuffer.append(parentNode.getPrimaryNodeType().getName());
                    parentNode = parentNode.getParent();
                }
                blob = File.createTempFile("cq5", ".durbo");
                os = new FileOutputStream(blob);
                DurboOutput output = new DurboOutput((OutputStream)os, (DurboNamespaceResolver)new DefaultDurboNamespaceResolver(node.getSession()), 2.1);
                output.writeProperty("startPath", node.getPath());
                output.writeProperty("orderSiblings", siblingOrder);
                output.writeProperty("orderChildren", childrenOrder);
                if (nodeTypesBuffer.length() > 0) {
                    output.writeProperty("parentNodeTypes", nodeTypesBuffer.toString());
                }
                if (rootIsVersioned) {
                    output.openNode(node.getName());
                    this.write(output, root, false);
                    output.openNode("jcr:content");
                    this.write(output, content, true);
                    output.closeNode();
                    output.closeNode();
                } else {
                    output.openNode(node.getName());
                    this.write(output, node, false);
                    output.openNode("jcr:content");
                    this.write(output, content, true);
                    output.closeNode();
                    output.closeNode();
                }
                output.close();
                ((OutputStream)os).close();
                os = null;
                replicationContent = factory.create("application/cq5-replication-durbo", blob, true);
                if (os == null) break block20;
            }
            catch (Throwable throwable) {
                if (os != null) {
                    IOUtils.closeQuietly(os);
                    if (blob != null) {
                        blob.delete();
                    }
                }
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)os);
            if (blob != null) {
                blob.delete();
            }
        }
        return replicationContent;
    }

    private void write(DurboOutput out, Node root) throws IOException, RepositoryException {
        out.openNode(root.getName());
        this.write(out, root, false);
        NodeIterator iter = root.getNodes();
        while (iter.hasNext()) {
            Node child = iter.nextNode();
            if (child.isNodeType("nt:hierarchyNode")) continue;
            out.openNode(child.getName());
            this.write(out, child, true);
            out.closeNode();
        }
        out.closeNode();
    }

    private void write(DurboOutput out, Node node, boolean recursive) throws IOException, RepositoryException {
        String[] mixinTypes;
        boolean isFrozen = this.isFrozenNode(node);
        out.writeProperty("jcr:primaryType", this.getPrimaryNodeType(node, isFrozen));
        if (node.isNodeType("mix:referenceable")) {
            out.writeProperty("jcr:uuid", this.getUUID(node, isFrozen));
        }
        if ((mixinTypes = this.getMixinNodeTypes(node, isFrozen)) != null && mixinTypes.length > 0) {
            StringBuffer mixinTypeNames = new StringBuffer();
            for (String mix : mixinTypes) {
                mixinTypeNames.append(mix);
                mixinTypeNames.append(',');
            }
            out.writeProperty("jcr:mixinTypes", mixinTypeNames.toString());
        }
        PropertyIterator iter = node.getProperties();
        while (iter.hasNext()) {
            Property property = iter.nextProperty();
            String propertyName = property.getName();
            if (DurboUtil.IGNORED_PROPERTIES.contains(propertyName)) continue;
            out.writeProperty(property);
        }
        if (recursive) {
            iter = node.getNodes();
            while (iter.hasNext()) {
                Node child = iter.nextNode();
                out.openNode(child.getName());
                this.write(out, child, true);
                out.closeNode();
            }
        }
    }

    private String[] getMixinNodeTypes(Node node, boolean isFrozen) throws RepositoryException {
        ArrayList<String> mixinList;
        block3: {
            NodeType[] mixins;
            block2: {
                Value[] vals;
                mixinList = new ArrayList<String>();
                if (!isFrozen) break block2;
                if (!node.hasProperty("jcr:frozenMixinTypes")) break block3;
                for (Value val : vals = node.getProperty("jcr:frozenMixinTypes").getValues()) {
                    mixinList.add(val.getString());
                }
                break block3;
            }
            for (NodeType mixin : mixins = node.getMixinNodeTypes()) {
                mixinList.add(mixin.getName());
            }
        }
        return mixinList.toArray(new String[mixinList.size()]);
    }

    private String getUUID(Node node, boolean isFrozen) throws RepositoryException {
        return isFrozen ? node.getProperty("jcr:frozenUuid").getString() : node.getUUID();
    }

    private String getPrimaryNodeType(Node node, boolean isFrozen) throws RepositoryException {
        return isFrozen ? node.getProperty("jcr:frozenPrimaryType").getString() : node.getPrimaryNodeType().getName();
    }

    private boolean isFrozenNode(Node node) throws RepositoryException {
        return node.isNodeType("nt:frozenNode");
    }

    protected void activate(ComponentContext context) {
        this.log.info("Durbo Content Builder activated.");
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    private static class DefaultDurboNamespaceResolver
    implements DurboNamespaceResolver {
        private final Session session;

        private DefaultDurboNamespaceResolver(Session session) {
            this.session = session;
        }

        public String getURI(String prefix) throws NamespaceException {
            try {
                return this.session.getNamespaceURI(prefix);
            }
            catch (RepositoryException e) {
                throw new NamespaceException((Throwable)e);
            }
        }

        public String getPrefix(String uri) throws NamespaceException {
            try {
                return this.session.getNamespacePrefix(uri);
            }
            catch (RepositoryException e) {
                throw new NamespaceException((Throwable)e);
            }
        }
    }
}

