/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.replication.content.durbo;

import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.replication.ReplicationException;
import com.day.cq.replication.content.durbo.DurboUtil;
import com.day.durbo.DurboInput;
import com.day.durbo.io.RegionFileInputStream;
import com.day.text.Text;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeType;
import javax.servlet.ServletInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DurboImporter {
    private final Logger logger = LoggerFactory.getLogger(DurboImporter.class);
    private boolean useStableUUIDs = false;
    private Hook hook;
    private long tempFileThreshold = 0x100000L;
    public static final String NS_SV_PREFIX = "sv";
    public static final String NS_SV_URI = "http://www.jcp.org/jcr/sv/1.0";

    private Node createParentPath(Session session, String replicationPath, Map<String, DurboInput.Property> headerProps) throws RepositoryException {
        String parentNodeTypeValues = DurboUtil.getValue(headerProps, "parentNodeTypes", null);
        String[] parentNodeTypes = Text.explode((String)parentNodeTypeValues, (int)44);
        Node currentNode = session.getRootNode();
        String currentPath = replicationPath.substring(1);
        int pos = currentPath.lastIndexOf(47);
        if (pos != -1) {
            StringTokenizer st = new StringTokenizer(currentPath.substring(0, pos), "/");
            boolean useParentNodeType = st.countTokens() == parentNodeTypes.length;
            int index = parentNodeTypes.length - 1;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (!currentNode.hasNode(token)) {
                    if (useParentNodeType) {
                        this.logger.debug("Creating new page node {} at {} with node type {}.", new Object[]{token, currentNode.getPath(), parentNodeTypes[index]});
                        currentNode.addNode(token, parentNodeTypes[index]);
                    } else {
                        this.logger.debug("Creating new page node {} at {} with default node type.", (Object)token, (Object)currentNode.getPath());
                        currentNode.addNode(token);
                    }
                    currentNode.save();
                }
                currentNode = currentNode.getNode(token);
                --index;
            }
        }
        return currentNode;
    }

    public Node createPage(SlingHttpServletRequest request, String origPath) throws ReplicationException {
        this.logger.debug("Received new durbo request on path: {}", (Object)origPath);
        try {
            Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
            int len = request.getContentLength();
            ServletInputStream in = request.getInputStream();
            return this.createPage(session, origPath, (InputStream)in, len);
        }
        catch (IOException e) {
            throw new ReplicationException("I/O error during page import: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node createPage(Session session, String origPath, InputStream in, long len) throws ReplicationException {
        this.logger.debug("Received new durbo request on path: {}", (Object)origPath);
        File tmpFile = null;
        try {
            if (len <= 0L || len >= this.tempFileThreshold) {
                long now = System.currentTimeMillis();
                this.logger.info("Content size triggered creation of temp file: {}...", (Object)len);
                tmpFile = File.createTempFile("cqreplication", "tmp");
                FileOutputStream out = FileUtils.openOutputStream((File)tmpFile);
                try {
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)out);
                }
                IOUtils.closeQuietly((InputStream)in);
                this.logger.info("Temporary file created in {}ms ({} bytes)", (Object)(System.currentTimeMillis() - now), (Object)tmpFile.length());
                in = new RegionFileInputStream(tmpFile);
            }
            DurboInput input = new DurboInput(in);
            Node node = this.createPage(session, origPath, input);
            return node;
        }
        catch (IOException e) {
            throw new ReplicationException("Repository error during page import: " + e.getMessage(), e);
        }
        finally {
            try {
                if (session.hasPendingChanges()) {
                    session.refresh(false);
                }
            }
            catch (RepositoryException e1) {}
            IOUtils.closeQuietly((InputStream)in);
            if (tmpFile != null) {
                tmpFile.delete();
            }
        }
    }

    public Node createPage(Session session, String origPath, DurboInput input) throws ReplicationException {
        try {
            DurboInput.Element element;
            long start = System.currentTimeMillis();
            HashMap<String, DurboInput.Property> headerProps = new HashMap<String, DurboInput.Property>();
            do {
                if ((element = input.read()) == null || !element.isProperty()) continue;
                headerProps.put(element.name(), (DurboInput.Property)element);
            } while (element != null && element.isProperty());
            if (element == null) {
                throw new ReplicationException("Could not load syndication information, no node available.");
            }
            if (!(element instanceof DurboInput.Node)) {
                throw new ReplicationException("Could not load syndication information, node element expected.");
            }
            String path = DurboUtil.getValue(headerProps, "startPath", origPath);
            this.logger.debug("Starting page creation for durbo request on path: {}", (Object)path);
            Node parentNode = this.createParentPath(session, path, headerProps);
            this.logger.debug("writeback content...");
            Node page = this.traverse(input, (DurboInput.Node)element, parentNode, null);
            this.logger.debug("restore sibling order...");
            JcrUtil.setChildNodeOrder((Node)parentNode, (String[])DurboUtil.getNodeNames(headerProps, "orderSiblings"));
            this.logger.debug("restore children order...");
            JcrUtil.setChildNodeOrder((Node)page, (String[])DurboUtil.getNodeNames(headerProps, "orderChildren"));
            if (this.hook != null) {
                this.hook.beforeSave(page);
            }
            this.logger.debug("saving...");
            session.save();
            long end = System.currentTimeMillis();
            this.logger.info("imported content in {}ms for durbo request on path: {}", (Object)(end - start), (Object)path);
            return page;
        }
        catch (IOException e) {
            throw new ReplicationException("Repository error during page import: " + e.getMessage(), e);
        }
        catch (RepositoryException e) {
            throw new ReplicationException("Repository error during page import: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    private Node traverse(DurboInput input, DurboInput.Node element, Node parent, Map<String, Boolean> snsInfo) throws ReplicationException, RepositoryException, IOException {
        Node createdNode;
        String nodeName;
        DurboInput.Element pntElement = input.read();
        if (pntElement == null || !pntElement.isProperty() || !pntElement.name().equals("jcr:primaryType")) {
            throw new ReplicationException("Primary node type property is missing after node start.");
        }
        String primaryNodeType = pntElement.getString();
        String uuid = null;
        Set<String> mixinNodeTypes = Collections.emptySet();
        DurboInput.Element nextElement = input.read();
        String name = this.resolveName(parent.getSession(), nextElement);
        if (nextElement != null && nextElement.isProperty() && name.equals("jcr:uuid")) {
            uuid = nextElement.getString();
            nextElement = input.read();
            name = this.resolveName(parent.getSession(), nextElement);
        }
        if (nextElement != null && nextElement.isProperty() && name.equals("jcr:mixinTypes")) {
            mixinNodeTypes = new HashSet();
            mixinNodeTypes.addAll(Arrays.asList(Text.explode((String)nextElement.getString(), (int)44)));
            nextElement = input.read();
        }
        if (DurboUtil.IGNORED_NODES.contains(nodeName = this.resolveName(parent.getSession(), (DurboInput.Element)element))) {
            this.logger.info("skipping node {}", (Object)(parent.getPath() + "/" + nodeName));
            while (nextElement != null && !nextElement.isNodeEnd()) {
                if (nextElement.isNodeStart()) {
                    this.skip(input, nextElement);
                }
                nextElement = input.read();
            }
            return null;
        }
        if (DurboImporter.isAuthorizableNodeType(primaryNodeType)) {
            this.logger.info("authorizable node {}", (Object)(parent.getPath() + "/" + nodeName + " (" + primaryNodeType + ")"));
            ArrayList<DurboInput.Property> properties = new ArrayList<DurboInput.Property>();
            while (nextElement != null && nextElement.isProperty()) {
                properties.add((DurboInput.Property)nextElement);
                nextElement = input.read();
            }
            createdNode = this.addNode(parent, nodeName, primaryNodeType, mixinNodeTypes, uuid, properties);
        } else {
            createdNode = this.createNode(parent, nodeName, primaryNodeType, mixinNodeTypes, uuid, snsInfo);
        }
        Map<String, Boolean> childSNSInfo = this.prepareForSNS(createdNode);
        while (nextElement != null && !nextElement.isNodeEnd()) {
            name = this.resolveName(parent.getSession(), nextElement);
            this.logger.debug("traversing {} at {}", (Object)name, (Object)createdNode.getPath());
            if (nextElement.isProperty()) {
                Value[] values;
                DurboInput.Property property = (DurboInput.Property)nextElement;
                if (!(DurboUtil.IGNORED_PROPERTIES.contains(name) || createdNode.hasProperty(name) && createdNode.getProperty(name).getDefinition().isProtected() || (values = property.getJcrValues(parent.getSession().getValueFactory())) == null)) {
                    try {
                        if (property.isMultiple()) {
                            createdNode.setProperty(name, values);
                        } else if (values.length > 0) {
                            createdNode.setProperty(name, values[0]);
                        }
                    }
                    catch (ConstraintViolationException re) {
                        this.logger.info("Unable to set (protected) property '" + createdNode.getPath() + "/" + name + "' : " + (Object)((Object)re));
                    }
                }
            } else {
                DurboInput.Node node = (DurboInput.Node)nextElement;
                this.traverse(input, node, createdNode, childSNSInfo);
            }
            nextElement = input.read();
        }
        if (nextElement == null) {
            throw new ReplicationException("Unexpected end of stream.");
        }
        return createdNode;
    }

    private void skip(DurboInput input, DurboInput.Element element) throws IOException {
        element = input.read();
        while (element != null && !element.isNodeEnd()) {
            if (element.isNodeStart()) {
                this.skip(input, element);
            }
            element = input.read();
        }
    }

    private String resolveName(Session session, DurboInput.Element elem) throws RepositoryException {
        String uri = elem.uri();
        String localName = elem.localName();
        if (uri == null) {
            return localName;
        }
        String pfx = elem.prefix();
        if (!pfx.equals(uri)) {
            try {
                pfx = session.getNamespacePrefix(uri);
            }
            catch (NamespaceException e) {
                pfx = this.registerNamespace(session, pfx, uri);
            }
        }
        return pfx + ":" + localName;
    }

    private String registerNamespace(Session session, String pfxHint, String uri) throws RepositoryException {
        int i = 0;
        String pfx = pfxHint;
        NamespaceException error = null;
        while (i < 1000) {
            try {
                session.getWorkspace().getNamespaceRegistry().registerNamespace(pfx, uri);
                return pfx;
            }
            catch (NamespaceException e) {
                pfx = pfxHint + i++;
                error = e;
            }
        }
        throw new RepositoryException("Giving up automatic namespace registration after 1000 attemps.", error);
    }

    private Node createNode(Node parent, String name, String primaryNodeType, Set<String> mixinNodeTypes, String uuid, Map<String, Boolean> snsInfo) throws RepositoryException {
        Node createdNode;
        if (parent.hasNode(name) && (snsInfo == null || snsInfo.get(name) == Boolean.FALSE)) {
            Node childNode;
            NodeIterator nIter;
            Node currentChildNode = parent.getNode(name);
            boolean requiresRemoval = !currentChildNode.getPrimaryNodeType().getName().equals(primaryNodeType);
            boolean isRemovable = true;
            if (requiresRemoval |= this.useStableUUIDs && uuid != null && currentChildNode.isNodeType("mix:referenceable") && !currentChildNode.getUUID().equals(uuid)) {
                nIter = currentChildNode.getNodes();
                while (isRemovable && nIter.hasNext()) {
                    childNode = nIter.nextNode();
                    if (!childNode.isNodeType("nt:hierarchyNode") && !childNode.isNodeType("rep:Policy")) continue;
                    isRemovable = false;
                }
            }
            if (requiresRemoval) {
                if (isRemovable) {
                    this.logger.debug("Node at {} already exists with wrong node type/uuid. Recreating node.", (Object)currentChildNode.getPath());
                    currentChildNode.remove();
                    createdNode = this.addNode(parent, name, primaryNodeType, mixinNodeTypes, uuid);
                } else {
                    createdNode = currentChildNode;
                    this.logger.info("Node at {} already exists with wrong node type/uuid", (Object)createdNode.getPath());
                }
            } else {
                createdNode = currentChildNode;
                this.logger.debug("Node at {} already exists, not creating new one.", (Object)createdNode.getPath());
            }
            nIter = createdNode.getNodes();
            while (nIter.hasNext()) {
                childNode = nIter.nextNode();
                if (childNode.isNodeType("nt:hierarchyNode") || childNode.isNodeType("rep:Policy")) continue;
                childNode.remove();
            }
            PropertyIterator pIter = createdNode.getProperties();
            while (pIter.hasNext()) {
                Property childProp = pIter.nextProperty();
                if (childProp.getDefinition().isProtected() || childProp.getDefinition().isMandatory()) continue;
                childProp.remove();
            }
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Creating new node {} with node type: {}", (Object)(parent.getPath() + '/' + name), (Object)primaryNodeType);
            }
            createdNode = this.addNode(parent, name, primaryNodeType, mixinNodeTypes, uuid);
        }
        if (snsInfo != null) {
            snsInfo.put(name, true);
        }
        HashSet<String> mixins = new HashSet<String>();
        for (NodeType nt : createdNode.getMixinNodeTypes()) {
            String ntName = nt.getName();
            mixins.add(ntName);
            if (mixinNodeTypes.contains(ntName) || DurboUtil.IGNORED_MIXIN_TYPES.contains(ntName)) continue;
            createdNode.removeMixin(ntName);
        }
        for (String nt : mixinNodeTypes) {
            if (mixins.contains(nt)) continue;
            createdNode.addMixin(nt);
        }
        return createdNode;
    }

    private Node addNode(Node parent, String name, String primaryNodeType, Set<String> mixins, String uuid, List<DurboInput.Property> properties) throws RepositoryException, IOException {
        try {
            String[] prefixes;
            ContentHandler handler = parent.getSession().getImportContentHandler(parent.getPath(), 1);
            handler.startDocument();
            for (String prefix : prefixes = parent.getSession().getNamespacePrefixes()) {
                handler.startPrefixMapping(prefix, parent.getSession().getNamespaceURI(prefix));
            }
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute(NS_SV_URI, "name", "sv:name", "CDATA", name);
            this.startElement(handler, "node", attrs);
            this.property(handler, "jcr:primaryType", "Name", primaryNodeType);
            if (mixins.size() > 0) {
                this.property(handler, "jcr:mixinTypes", "Name", mixins.toArray(new String[mixins.size()]));
            }
            if (uuid != null) {
                this.property(handler, "jcr:uuid", "String", uuid);
            }
            ValueFactory vf = parent.getSession().getValueFactory();
            ArrayList<DurboInput.Property> binaries = new ArrayList<DurboInput.Property>();
            for (DurboInput.Property prop : properties) {
                if (2 == prop.getType()) {
                    this.logger.debug("binary property -> import postponed.");
                    binaries.add(prop);
                    continue;
                }
                Value[] vs = prop.getJcrValues(vf);
                String[] strvs = new String[vs.length];
                for (int i = 0; i < vs.length; ++i) {
                    strvs[i] = vs[i].getString();
                }
                this.property(handler, prop.name(), PropertyType.nameFromValue((int)prop.getType()), prop.isMultiple(), strvs);
            }
            this.endElement(handler, "node");
            handler.endDocument();
            Node n = parent.getNode(name);
            for (DurboInput.Property binary : binaries) {
                this.logger.debug("handling binary property (" + binary.name() + ").");
                Value[] vs = binary.getJcrValues(vf);
                if (binary.isMultiple()) {
                    n.setProperty(binary.name(), vs);
                    continue;
                }
                n.setProperty(binary.name(), vs[0]);
            }
            return n;
        }
        catch (SAXException e) {
            Exception root = e.getException();
            if (root instanceof RepositoryException) {
                throw (RepositoryException)((Object)root);
            }
            throw new RepositoryException("Error while creating node", (Throwable)root);
        }
    }

    private Node addNode(Node parent, String name, String primaryNodeType, Set<String> mixins, String uuid) throws RepositoryException {
        if (uuid == null || !this.useStableUUIDs) {
            return parent.addNode(name, primaryNodeType);
        }
        try {
            String[] prefixes;
            ContentHandler handler = parent.getSession().getImportContentHandler(parent.getPath(), 1);
            handler.startDocument();
            for (String prefix : prefixes = parent.getSession().getNamespacePrefixes()) {
                handler.startPrefixMapping(prefix, parent.getSession().getNamespaceURI(prefix));
            }
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute(NS_SV_URI, "name", "sv:name", "CDATA", name);
            this.startElement(handler, "node", attrs);
            this.property(handler, "jcr:primaryType", "Name", primaryNodeType);
            if (mixins.size() > 0) {
                this.property(handler, "jcr:mixinTypes", "Name", mixins.toArray(new String[mixins.size()]));
            }
            this.property(handler, "jcr:uuid", "String", uuid);
            this.endElement(handler, "node");
            handler.endDocument();
            return parent.getNode(name);
        }
        catch (SAXException e) {
            Exception root = e.getException();
            if (root instanceof RepositoryException) {
                throw (RepositoryException)((Object)root);
            }
            throw new RepositoryException("Error while creating node", (Throwable)root);
        }
    }

    protected void property(ContentHandler handler, String name, String type, String ... values) throws SAXException {
        this.property(handler, name, type, false, values);
    }

    protected void property(ContentHandler handler, String name, String type, boolean isMultiple, String ... values) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute(NS_SV_URI, "name", "sv:name", "CDATA", name);
        attrs.addAttribute(NS_SV_URI, "type", "sv:type", "CDATA", type);
        if (isMultiple) {
            attrs.addAttribute(NS_SV_URI, "multiple", "sv:multiple", "CDATA", "true");
        }
        this.startElement(handler, "property", attrs);
        for (String value : values) {
            attrs.clear();
            this.startElement(handler, "value", attrs);
            char[] valueChars = value.toCharArray();
            handler.characters(valueChars, 0, valueChars.length);
            this.endElement(handler, "value");
        }
        this.endElement(handler, "property");
    }

    protected void startElement(ContentHandler handler, String name, Attributes atts) throws SAXException {
        handler.startElement(NS_SV_URI, name, "sv:" + name, atts);
    }

    protected void endElement(ContentHandler handler, String name) throws SAXException {
        handler.endElement(NS_SV_URI, name, "sv:" + name);
    }

    private static boolean isAuthorizableNodeType(String ntName) {
        return "rep:User".equals(ntName) || "rep:Group".equals(ntName);
    }

    private Map<String, Boolean> prepareForSNS(Node parentNode) throws RepositoryException {
        HashMap<String, Boolean> info = new HashMap<String, Boolean>();
        NodeIterator iter = parentNode.getNodes();
        while (iter.hasNext()) {
            Node child = iter.nextNode();
            Boolean exists = (Boolean)info.get(child.getName());
            if (exists != null) {
                child.remove();
                continue;
            }
            info.put(child.getName(), false);
        }
        return info;
    }

    public Hook getHook() {
        return this.hook;
    }

    public void setHook(Hook hook) {
        this.hook = hook;
    }

    public void setTempFileThreshold(long size) {
        this.tempFileThreshold = size;
    }

    public static interface Hook {
        public void beforeSave(Node var1) throws RepositoryException;
    }
}

