/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.replication.impl;

import com.adobe.granite.crypto.CryptoException;
import com.adobe.granite.crypto.CryptoSupport;
import com.day.cq.replication.AgentConfig;
import java.io.ByteArrayOutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentConfigImpl
implements AgentConfig {
    private static final Logger log = LoggerFactory.getLogger(AgentConfigImpl.class);
    protected static final String DEFAULT_SERIALIZATION_TYPE = "durbo";
    protected static final long DEFAULT_RETRY_DELAY = 60000L;
    protected static final int DEFAULT_MAX_RETRIES = -1;
    protected static final String DEFAULT_LOG_LEVEL = "INFO";
    private final String configPath;
    private final ValueMap properties;
    private final CryptoSupport crypto;

    public AgentConfigImpl(Map<String, Object> props, String configPath, CryptoSupport crypto) {
        this.configPath = configPath;
        this.properties = new ValueMapDecorator(props);
        this.crypto = crypto;
    }

    @Override
    public ValueMap getProperties() {
        return this.properties;
    }

    @Override
    public String getConfigPath() {
        return this.configPath;
    }

    @Override
    public String getSerializationType() {
        return (String)this.properties.get("serializationType", (Object)DEFAULT_SERIALIZATION_TYPE);
    }

    @Override
    public String getName() {
        return (String)this.properties.get("jcr:title", String.class);
    }

    @Override
    public String getAgentUserId() {
        return (String)this.properties.get("userId", String.class);
    }

    @Override
    public String getLogLevel() {
        return (String)this.properties.get("logLevel", (Object)DEFAULT_LOG_LEVEL);
    }

    @Override
    public boolean isSpecific() {
        return (Boolean)this.properties.get("triggerSpecific", (Object)false) != false || this.isTriggeredOnDistribute() || this.usedForReverseReplication();
    }

    @Override
    public boolean isTriggeredOnModification() {
        return (Boolean)this.properties.get("triggerModified", (Object)false);
    }

    @Override
    public boolean isTriggeredOnOffTime() {
        return (Boolean)this.properties.get("triggerOnOffTime", (Object)false);
    }

    @Override
    public boolean isTriggeredOnDistribute() {
        return (Boolean)this.properties.get("triggerDistribute", (Object)false);
    }

    @Override
    public boolean usedForReverseReplication() {
        return (Boolean)this.properties.get("reverseReplication", (Object)false);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)this.properties.get("enabled", (Object)false);
    }

    @Override
    public int getMaxRetries() {
        return (Integer)this.properties.get("maxRetries", (Object)-1);
    }

    @Override
    public long getRetryDelay() {
        long delay = (Long)this.properties.get("retryDelay", (Object)60000L);
        return delay < 1000L ? 1000L : delay;
    }

    @Override
    public void checkValid() throws IllegalArgumentException {
        String uri = this.getTransportURI();
        if (uri == null) {
            throw new IllegalArgumentException("Transport URI is not specified.");
        }
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("path", "path");
        props.put("action", "activate");
        StrSubstitutor replace = new StrSubstitutor(props, "{", "}");
        try {
            new URI(replace.replace(uri));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Transport URI is malformed: " + e.getMessage());
        }
    }

    @Override
    public String getTransportURI() {
        return (String)this.properties.get((Object)"transportUri");
    }

    @Override
    public String getTransportUser() {
        return (String)this.properties.get((Object)"transportUser");
    }

    @Override
    public boolean noVersions() {
        return (Boolean)this.properties.get("noVersioning", (Object)false);
    }

    @Override
    public boolean noStatusUpdate() {
        return (Boolean)this.properties.get("noStatusUpdate", (Object)false);
    }

    @Override
    public String getTransportPassword() {
        String pwd = (String)this.properties.get("transportPassword", String.class);
        if (pwd != null) {
            String dec = AgentConfigImpl.legacyDecrypt(pwd);
            if (dec == null && this.crypto != null && this.crypto.isProtected(pwd)) {
                try {
                    dec = this.crypto.unprotect(pwd);
                }
                catch (CryptoException e) {
                    log.error("Error while unprotecting password: {}", (Object)e.toString());
                }
            }
            if (dec != null) {
                pwd = dec;
            }
        }
        return pwd;
    }

    static String legacyDecrypt(String s) {
        String PREFIX = "{DES}";
        int KEY_LENGTH = 8;
        if (!s.startsWith("{DES}")) {
            return null;
        }
        try {
            byte[] data = new byte[(s.length() - "{DES}".length()) / 2];
            int i = "{DES}".length();
            int b = 0;
            while (i < s.length()) {
                data[b] = (byte)(Integer.parseInt(s.substring(i, i + 2), 16) & 0xFF);
                i += 2;
                ++b;
            }
            SecretKeySpec key = new SecretKeySpec(data, 0, 8, "DES");
            Cipher cipher = Cipher.getInstance("DES");
            ByteArrayOutputStream out = new ByteArrayOutputStream(data.length);
            cipher.init(2, key);
            out.write(cipher.update(data, 8, data.length - 8));
            out.write(cipher.doFinal());
            return out.toString("utf-8");
        }
        catch (Exception e) {
            log.warn("Unable to decrypt data: " + e);
            return null;
        }
    }
}

