/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.replication.impl;

import com.day.cq.replication.Agent;
import com.day.cq.replication.AgentConfig;
import com.day.cq.replication.ContentBuilder;
import com.day.cq.replication.ListenerLogDelegator;
import com.day.cq.replication.PollingTransportHandler;
import com.day.cq.replication.ReplicationAction;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationContent;
import com.day.cq.replication.ReplicationContentFacade;
import com.day.cq.replication.ReplicationContentFactory;
import com.day.cq.replication.ReplicationException;
import com.day.cq.replication.ReplicationListener;
import com.day.cq.replication.ReplicationLog;
import com.day.cq.replication.ReplicationOptions;
import com.day.cq.replication.ReplicationQueue;
import com.day.cq.replication.ReplicationResult;
import com.day.cq.replication.ReplicationTransaction;
import com.day.cq.replication.ReverseReplication;
import com.day.cq.replication.TransportContext;
import com.day.cq.replication.TransportException;
import com.day.cq.replication.TransportHandler;
import com.day.cq.replication.UnrecoverableReplicationException;
import com.day.cq.replication.content.DispatcherFlushContentBuilder;
import com.day.cq.replication.impl.AgentManagerImpl;
import com.day.cq.replication.impl.ReplicationLogImpl;
import com.day.cq.replication.impl.ServiceTracker;
import com.day.cq.replication.impl.queue.QueueListener;
import com.day.cq.replication.impl.queue.ReplicationQueueImpl;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Session;
import org.apache.jackrabbit.util.ISO8601;

public class AgentImpl
implements Agent,
QueueListener,
ServiceTracker.Listener {
    private String configError;
    private TransportHandler transportHandler;
    private ContentBuilder contentBuilder;
    private AgentConfig config;
    private final String id;
    private final ServiceTracker serviceTracker;
    private final AgentManagerImpl agentMgr;
    private final ReplicationLogImpl log;
    private ReplicationQueueImpl queue;
    private final ReplicationContentFactory contentFactory;
    private InternalTransportContext ctx;
    private boolean expectReverseReplicationErrors = false;

    public AgentImpl(String id, AgentConfig config, ServiceTracker serviceTracker, AgentManagerImpl agentMgr, ReplicationContentFactory binFactory) {
        this.config = config;
        this.id = id;
        this.serviceTracker = serviceTracker;
        this.agentMgr = agentMgr;
        this.contentFactory = binFactory;
        this.log = new ReplicationLogImpl(id, ReplicationLog.Level.ERROR);
        this.update(config);
        this.serviceTracker.registerListener(this);
    }

    public ReplicationQueue getQueue() {
        return this.queue;
    }

    public String getId() {
        return this.id;
    }

    public void onBind(TransportHandler handler) {
        if (handler.canHandle(this.config)) {
            this.transportHandler = handler;
            this.log.info("Transport handler updated (%s)", handler.getClass().getName());
            this.start();
        }
    }

    public void onUnbind(TransportHandler handler) {
        if (handler == this.transportHandler) {
            this.transportHandler = null;
            this.log.info("Transport handler removed.");
            this.stop();
        }
    }

    public void onBind(ContentBuilder builder) {
        if (builder.getName().equals(this.config.getSerializationType())) {
            this.contentBuilder = builder;
            this.log.info("Content builder updated (%s).", builder.getClass().getName());
            this.start();
        }
    }

    public void onUnbind(ContentBuilder builder) {
        if (builder == this.contentBuilder) {
            this.contentBuilder = null;
            this.log.info("Content builder removed.");
            this.stop();
        }
    }

    ReplicationContentFactory getContentFactory() {
        return this.contentFactory;
    }

    public void update(AgentConfig newConfig) {
        if (this.stop()) {
            this.log.info("Agent stopped for configuration");
        }
        this.configError = null;
        this.config = newConfig;
        this.transportHandler = null;
        this.contentBuilder = null;
        this.log.info("Agent configuration updated at %s", this.config.getConfigPath());
        try {
            this.config.checkValid();
        }
        catch (IllegalArgumentException e) {
            this.configError = e.getMessage();
            this.log.error("Agent not valid. %s", this.configError);
            return;
        }
        this.transportHandler = this.serviceTracker.getTransportHandler(this.config);
        if (this.transportHandler == null) {
            this.log.error("Agent not valid yet, no transport handler for %s", this.config.getTransportURI());
        }
        this.contentBuilder = this.serviceTracker.getContentBuilder(this.config.getSerializationType());
        if (this.contentBuilder == null) {
            this.log.error("Agent not valid yet. No content builder for %s", this.config.getSerializationType());
        }
        this.ctx = new InternalTransportContext(this.config);
        this.log.setLevel(this.config.getLogLevel());
        this.log.info("Agent updated. State is %s and %svalid", this.isEnabled() ? "enabled" : "disabled", this.isValid() ? "" : "in");
        this.start();
    }

    public boolean start() {
        if (this.isEnabled() && this.isValid() && this.queue == null) {
            this.queue = this.agentMgr.createQueue(this.id, this);
            this.log.info("Agent started.");
            this.queue.forceRetry();
            return true;
        }
        return false;
    }

    public void destroy() {
        if (this.queue != null) {
            this.queue.close(true);
            this.queue = null;
            this.log.info("Agent Destroyed.");
        }
        if (this.contentFactory != null) {
            this.contentFactory.close();
        }
        this.serviceTracker.unregisterListener(this);
    }

    public boolean stop() {
        if (this.queue != null) {
            this.queue.close(false);
            this.queue = null;
            this.log.info("Agent stopped.");
            return true;
        }
        return false;
    }

    public boolean isEnabled() {
        return this.config.isEnabled();
    }

    public boolean isValid() {
        return this.configError == null && this.contentBuilder != null;
    }

    public void checkValid() throws IllegalArgumentException {
        if (this.configError != null) {
            throw new IllegalArgumentException(this.configError);
        }
        if (this.contentBuilder == null) {
            throw new IllegalArgumentException("ContentBuilder not available");
        }
    }

    public ReplicationLog getLog() {
        return this.log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplicationContent buildContent(Session session, ReplicationAction action) throws ReplicationException {
        this.log.info("Creating content for page %s", action.getPath());
        if (this.contentBuilder == null) {
            throw new ReplicationException("ContentBuilder not available");
        }
        action.setConfig(this.config);
        action.setLog(this.log);
        try {
            ReplicationContent content = this.contentBuilder.create(session, action, this.contentFactory);
            content.acquire(this.getId());
            ReplicationContent replicationContent = content;
            Object var6_5 = null;
            action.setLog(null);
            action.setConfig(null);
            return replicationContent;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            action.setLog(null);
            action.setConfig(null);
            throw throwable;
        }
    }

    public ReplicationContent getContent(ReplicationContentFacade facade) throws ReplicationException {
        ReplicationContent content = this.contentFactory.create(facade);
        content.acquire(this.getId());
        return content;
    }

    public boolean process(ReplicationQueueImpl.EntryData data) throws ReplicationException {
        try {
            ReplicationContent content = this.contentFactory.create(data.getContent());
            return this.doReplicate(data.getAction(), content, null, this.ctx);
        }
        catch (ReplicationException e) {
            this.log.error("Error during replication of %s: %s", data.getAction(), e.toString());
            return false;
        }
    }

    public void abort(ReplicationQueueImpl.EntryData data) {
        ReplicationContent content = this.contentFactory.create(data.getContent());
        if (content != null) {
            content.release(this.getId());
        }
    }

    private boolean doReplicate(final ReplicationAction action, final ReplicationContent content, ReplicationOptions opts, TransportContext ctx) throws ReplicationException {
        if (this.transportHandler == null) {
            throw new ReplicationException("Unable to replicate content with no transport handler. Check configuration.");
        }
        ReplicationListener listener = opts == null ? null : opts.getListener();
        final ListenerLogDelegator txLog = new ListenerLogDelegator(this.log, listener);
        ReplicationTransaction tx = new ReplicationTransaction(){

            public ReplicationAction getAction() {
                return action;
            }

            public ReplicationContent getContent() {
                return content;
            }

            public ReplicationLog getLog() {
                return txLog;
            }
        };
        try {
            if (listener != null) {
                listener.onStart(this, action);
            }
            ReplicationResult result = this.transportHandler.deliver(ctx, tx);
            if (listener != null) {
                listener.onEnd(this, action, result);
            }
            if (result.isSuccess()) {
                if (content != null) {
                    content.release(this.getId());
                }
                return true;
            }
            return false;
        }
        catch (UnrecoverableReplicationException e) {
            txLog.warn("Unrecoverable error occurred during replication. Aborting: " + e.getMessage(), e);
            if (listener != null) {
                listener.onError(this, action, e);
            }
            if (content != null) {
                content.release(this.getId());
            }
            return true;
        }
        catch (ReplicationException e) {
            if (listener != null) {
                listener.onError(this, action, e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replicate(ReplicationAction action, ReplicationContent content, ReplicationOptions opts) throws ReplicationException {
        if (opts.isSynchronous()) {
            InternalTransportContext ctx = new InternalTransportContext(this.config);
            try {
                this.doReplicate(action, content, opts, ctx);
                Object var6_5 = null;
                ctx.discard();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                ctx.discard();
                throw throwable;
            }
            if (content != null) {
                content.release(this.getId());
            }
        } else if (this.queue != null) {
            this.queue.addEntry(action, content == null ? null : content.getFacade(), this.config.getRetryDelay());
        }
    }

    public ReverseReplication[] poll(ReplicationAction action) throws ReplicationException {
        if (this.transportHandler == null) {
            String msg = "Unable to replicate content with no transport handler. Check configuration.";
            throw new ReplicationException(msg);
        }
        Calendar lastPoll = this.agentMgr.getLastPollTime(this.getId());
        String rev = lastPoll == null ? null : ISO8601.format((Calendar)lastPoll);
        final ReplicationAction newAction = new ReplicationAction(action.getType(), action.getPath(), action.getTime(), action.getUserId(), rev);
        ReplicationTransaction tx = new ReplicationTransaction(){

            public ReplicationAction getAction() {
                return newAction;
            }

            public ReplicationContent getContent() {
                return null;
            }

            public ReplicationLog getLog() {
                return new ReverseReplicationLog(AgentImpl.this.log);
            }
        };
        ReplicationResult result = ReplicationResult.OK;
        ReverseReplication[] ret = new ReverseReplication[]{};
        if (this.transportHandler instanceof PollingTransportHandler) {
            try {
                ret = ((PollingTransportHandler)((Object)this.transportHandler)).poll(this.ctx, tx, this.contentFactory);
            }
            catch (TransportException e) {
                result = e.getResult();
            }
        } else {
            ReplicationAction a = new ReplicationAction(ReplicationActionType.ACTIVATE, "", 0L, "", null);
            ArrayList<ReplicationContent> cs = new ArrayList<ReplicationContent>();
            result = this.transportHandler.poll(this.ctx, tx, cs, this.contentFactory);
            ret = new ReverseReplication[cs.size()];
            int i = 0;
            for (ReplicationContent c : cs) {
                ret[i++] = new ReverseReplication(c, a);
            }
        }
        for (ReverseReplication r : ret) {
            r.getContent().acquire(this.getId());
        }
        if (result.isSuccess()) {
            this.log.info("Fetched " + ret.length + " pages from " + this.getConfiguration().getTransportURI() + " since " + rev);
            this.expectReverseReplicationErrors = false;
            return ret;
        }
        this.expectReverseReplicationErrors = true;
        for (ReverseReplication r : ret) {
            r.getContent().release(this.getId());
        }
        return null;
    }

    public void setNextPollTimeline(Calendar time) {
        this.agentMgr.setLastPollTime(this.getId(), time);
    }

    public Calendar getLastPollTimeline() {
        return this.agentMgr.getLastPollTime(this.getId());
    }

    public boolean isCacheInvalidator() {
        return this.contentBuilder instanceof DispatcherFlushContentBuilder;
    }

    public AgentConfig getConfiguration() {
        return this.config;
    }

    private static class InternalTransportContext
    implements TransportContext {
        private final AgentConfig config;
        private final Map<String, TransportContext.Discardable> attrs = new HashMap<String, TransportContext.Discardable>();

        InternalTransportContext(AgentConfig config) {
            this.config = config;
        }

        public String getName() {
            return this.config.getName();
        }

        public AgentConfig getConfig() {
            return this.config;
        }

        public TransportContext.Discardable getAttribute(String name) {
            return this.attrs.get(name);
        }

        public TransportContext.Discardable setAttribute(String name, TransportContext.Discardable attr) {
            if (attr == null) {
                return this.attrs.remove(name);
            }
            return this.attrs.put(name, attr);
        }

        public void discard() {
            for (TransportContext.Discardable d : this.attrs.values()) {
                d.discard();
            }
            this.attrs.clear();
        }
    }

    private class ReverseReplicationLog
    extends ListenerLogDelegator {
        public ReverseReplicationLog(ReplicationLog log) {
            super(log, null);
        }

        public void info(String message) {
            if (AgentImpl.this.expectReverseReplicationErrors) {
                this.debug("Expected information: " + message);
            } else {
                super.info(message);
            }
        }

        public void warn(String message) {
            if (AgentImpl.this.expectReverseReplicationErrors) {
                this.debug("Expected warning: " + message);
            } else {
                super.warn(message);
            }
        }

        public void error(String message) {
            if (AgentImpl.this.expectReverseReplicationErrors) {
                this.debug("Expected error: " + message);
            } else {
                super.warn(message);
            }
        }
    }
}

