/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.replication.impl;

import com.adobe.granite.crypto.CryptoSupport;
import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.replication.Agent;
import com.day.cq.replication.AgentConfig;
import com.day.cq.replication.AgentManager;
import com.day.cq.replication.ReplicationContentFactory;
import com.day.cq.replication.impl.AgentConfigImpl;
import com.day.cq.replication.impl.AgentImpl;
import com.day.cq.replication.impl.ReplicationContentFactoryProvider;
import com.day.cq.replication.impl.ServiceTracker;
import com.day.cq.replication.impl.queue.QueueListener;
import com.day.cq.replication.impl.queue.ReplicationJob;
import com.day.cq.replication.impl.queue.ReplicationQueueImpl;
import com.day.text.Text;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.apache.sling.event.EventUtil;
import org.apache.sling.event.jobs.JobManager;
import org.apache.sling.event.jobs.JobProcessor;
import org.apache.sling.event.jobs.JobUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.resource.JcrPropertyMap;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentManagerImpl
implements AgentManager,
EventListener,
EventHandler,
JobProcessor {
    private static final Logger log = LoggerFactory.getLogger(AgentManagerImpl.class);
    private static final Set<String> IGNORED_PROPERTIES = new HashSet<String>();
    private static final String AGENT_CONFIG_ROOT_PATH = "/etc/replication";
    private static final String CONTENT_PATH = "/var/replication/data";
    private JobManager jobManager = null;
    private EventAdmin eventAdmin = null;
    private SlingRepository repository = null;
    private SlingSettingsService settingsService = null;
    private ServiceTracker serviceTracker = null;
    private ReplicationContentFactoryProvider factoryProvider = null;
    private CryptoSupport crypto = null;
    private Session session;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private Map<String, AgentImpl> agents = new LinkedHashMap<String, AgentImpl>();
    private Map<String, Agent> cachedAgents;

    protected void activate(ComponentContext context) {
        this.lock.writeLock().lock();
        try {
            this.session = this.repository.loginAdministrative(null);
            try {
                Node root = this.session.getRootNode().getNode(AGENT_CONFIG_ROOT_PATH.substring(1));
                this.scan(root);
            }
            catch (RepositoryException e) {
                log.error("Unable to read replication agents: " + (Object)((Object)e));
            }
            this.cacheAgents();
            this.session.getWorkspace().getObservationManager().addEventListener((EventListener)this, 31, AGENT_CONFIG_ROOT_PATH, true, null, null, true);
            log.info("AgentManager service activated");
        }
        catch (RepositoryException e) {
            throw new IllegalStateException("Error while initializing agent manager", e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void scan(Node node) throws RepositoryException {
        NodeIterator iter = node.getNodes();
        while (iter.hasNext()) {
            Node n = iter.nextNode();
            if (n.getName().equals("jcr:content")) continue;
            this.update(n);
            this.scan(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deactivate() {
        this.lock.writeLock().lock();
        try {
            if (this.session != null) {
                try {
                    this.session.getWorkspace().getObservationManager().removeEventListener((EventListener)this);
                }
                catch (RepositoryException e) {
                    // empty catch block
                }
                this.session.logout();
                this.session = null;
            }
            for (AgentImpl agent : this.agents.values()) {
                agent.stop();
                agent.getContentFactory().close();
            }
            this.agents.clear();
            this.cachedAgents = Collections.emptyMap();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(EventIterator events) {
        HashSet<String> paths = new HashSet<String>();
        while (events.hasNext()) {
            Event evt = events.nextEvent();
            try {
                String path = evt.getPath();
                if (evt.getType() != 1 && evt.getType() != 2) {
                    String name = Text.getName((String)path);
                    if (IGNORED_PROPERTIES.contains(name)) continue;
                    path = Text.getRelativeParent((String)path, (int)1);
                }
                if (path.endsWith("/jcr:content")) {
                    paths.add(Text.getRelativeParent((String)path, (int)1));
                    continue;
                }
                paths.add(path);
            }
            catch (RepositoryException e) {
                log.warn("Error while reading observation information: " + (Object)((Object)e));
            }
        }
        try {
            this.lock.writeLock().lock();
            for (String path : paths) {
                if (this.session.nodeExists(path)) {
                    Node node = this.session.getNode(path);
                    this.update(node);
                    continue;
                }
                this.remove(path);
            }
            this.cacheAgents();
        }
        catch (RepositoryException e) {
            log.error("error while updating agents.", (Throwable)e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public Map<String, Agent> getAgents() {
        return this.cachedAgents;
    }

    private void cacheAgents() {
        this.cachedAgents = new LinkedHashMap<String, Agent>();
        for (AgentImpl agent : this.agents.values()) {
            this.cachedAgents.put(agent.getId(), agent);
        }
        this.cachedAgents = Collections.unmodifiableMap(this.cachedAgents);
    }

    private boolean isRunModeActive(String[] runModesToCheck) {
        boolean result = false;
        for (String m : runModesToCheck) {
            if ((m = m.trim()).equals("*")) {
                result = true;
                break;
            }
            if (!this.settingsService.getRunModes().contains(m)) continue;
            result = true;
            break;
        }
        return result;
    }

    private AgentConfig loadConfig(Node node) throws RepositoryException {
        if (node.hasNode("jcr:content")) {
            Node parent = node.getParent();
            String[] runModes = null;
            while (runModes == null && parent.getDepth() > 0 && !parent.getPath().equals(AGENT_CONFIG_ROOT_PATH)) {
                String name = parent.getName();
                if (name.equals("agents")) {
                    runModes = new String[]{};
                } else if (name.startsWith("agents.")) {
                    String[] segs = Text.explode((String)name, (int)46);
                    runModes = new String[segs.length - 1];
                    System.arraycopy(segs, 1, runModes, 0, runModes.length);
                }
                parent = parent.getParent();
            }
            String path = node.getPath();
            if (runModes == null) {
                log.info("Possible agent at {} has no runmode.", (Object)path);
            } else {
                if (this.isRunModeActive(runModes)) {
                    log.info("Possible agent at {} is active.", (Object)path);
                    Node content = node.getNode("jcr:content");
                    JcrPropertyMap props = new JcrPropertyMap(content);
                    HashMap<String, Object> properties = new HashMap<String, Object>((Map<String, Object>)props);
                    return new AgentConfigImpl(properties, content.getPath(), this.crypto);
                }
                log.info("Possible agent at {} is not active.", (Object)node.getPath());
            }
        }
        return null;
    }

    private void update(Node node) throws RepositoryException {
        AgentConfig config = this.loadConfig(node);
        String path = node.getPath();
        if (config == null) {
            this.remove(path);
        } else {
            AgentImpl agent = this.agents.remove(path);
            if (agent == null) {
                String id = Text.getName((String)path);
                log.info("AgentConfig at {} added.", (Object)path);
                ReplicationContentFactory factory = this.factoryProvider.create(id);
                agent = new AgentImpl(id, config, this.serviceTracker, this, factory);
            } else {
                log.info("AgentConfig at {} updated.", (Object)path);
                agent.update(config);
            }
            this.agents.put(path, agent);
            NodeIterator iter = node.getParent().getNodes();
            while (iter.hasNext()) {
                String p = iter.nextNode().getPath();
                agent = this.agents.remove(p);
                if (agent == null) continue;
                this.agents.put(p, agent);
            }
        }
    }

    private void remove(String path) {
        AgentImpl agent = this.agents.remove(path);
        if (agent != null) {
            log.info("AgentConfig at {} removed.", (Object)path);
            agent.destroy();
        }
    }

    private Node getOutboxNode(String agentId) throws RepositoryException {
        String path = "/var/replication/data/" + agentId;
        if (this.session.nodeExists(path)) {
            return this.session.getNode(path);
        }
        return JcrUtil.createPath((String)path, (String)"sling:Folder", (String)"sling:Folder", (Session)this.session, (boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Calendar getLastPollTime(String agentId) {
        this.lock.writeLock().lock();
        try {
            Node ob = this.getOutboxNode(agentId);
            if (!ob.hasProperty("cq:lastPoll")) return null;
            Calendar calendar = ob.getProperty("cq:lastPoll").getDate();
            this.lock.writeLock().unlock();
            return calendar;
        }
        catch (RepositoryException e) {
            log.error("Error while fetching last poll time for agent {}", (Object)agentId, (Object)e);
            return null;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setLastPollTime(String agentId, Calendar time) {
        this.lock.writeLock().lock();
        try {
            try {
                Node ob = this.getOutboxNode(agentId);
                ob.setProperty("cq:lastPoll", time);
                ob.save();
            }
            catch (RepositoryException e) {
                log.error("Error while fetching last poll time for agent {}", (Object)agentId, (Object)e);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void handleEvent(org.osgi.service.event.Event event) {
        if (EventUtil.isLocal((org.osgi.service.event.Event)event)) {
            JobUtil.processJob((org.osgi.service.event.Event)event, (JobProcessor)this);
        }
    }

    public boolean process(org.osgi.service.event.Event jobEvent) {
        ReplicationJob job = new ReplicationJob(jobEvent);
        String queueName = job.getQueueName();
        Agent a = this.getAgents().get(queueName);
        if (a == null) {
            log.error("Job contains unknown agent: {}. Discarding Job {}", (Object)queueName, (Object)job);
            return true;
        }
        ReplicationQueueImpl queue = (ReplicationQueueImpl)a.getQueue();
        if (queue == null) {
            log.error("Job contains agent which is not started: {}. waiting {}", (Object)queueName, (Object)job);
            return false;
        }
        log.info("Processing job for agent {}", (Object)queueName);
        try {
            long start = System.currentTimeMillis();
            boolean ret = queue.process(job);
            long end = System.currentTimeMillis();
            log.info("Job for agent {} processed in {}ms. {}", new Object[]{queueName, String.valueOf(end - start), ret ? "Ok." : "Failed."});
            return ret;
        }
        catch (Throwable e) {
            log.error("Error during processing of replication.", e);
            return false;
        }
    }

    public ReplicationQueueImpl createQueue(String name, QueueListener listener) {
        ReplicationQueueImpl q = new ReplicationQueueImpl(this.eventAdmin, this.jobManager, name);
        q.open(listener);
        return q;
    }

    static {
        IGNORED_PROPERTIES.add("cq:name");
        IGNORED_PROPERTIES.add("cq:siblingOrder");
        IGNORED_PROPERTIES.add("cq:parentPath");
        IGNORED_PROPERTIES.add("cq:childrenOrder");
        IGNORED_PROPERTIES.add("jcr:baseVersion");
        IGNORED_PROPERTIES.add("jcr:isCheckedOut");
        IGNORED_PROPERTIES.add("jcr:predecessors");
    }

    protected void bindJobManager(JobManager jobManager) {
        this.jobManager = jobManager;
    }

    protected void unbindJobManager(JobManager jobManager) {
        if (this.jobManager == jobManager) {
            this.jobManager = null;
        }
    }

    protected void bindEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    protected void unbindEventAdmin(EventAdmin eventAdmin) {
        if (this.eventAdmin == eventAdmin) {
            this.eventAdmin = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindSettingsService(SlingSettingsService slingSettingsService) {
        this.settingsService = slingSettingsService;
    }

    protected void unbindSettingsService(SlingSettingsService slingSettingsService) {
        if (this.settingsService == slingSettingsService) {
            this.settingsService = null;
        }
    }

    protected void bindServiceTracker(ServiceTracker serviceTracker) {
        this.serviceTracker = serviceTracker;
    }

    protected void unbindServiceTracker(ServiceTracker serviceTracker) {
        if (this.serviceTracker == serviceTracker) {
            this.serviceTracker = null;
        }
    }

    protected void bindFactoryProvider(ReplicationContentFactoryProvider replicationContentFactoryProvider) {
        this.factoryProvider = replicationContentFactoryProvider;
    }

    protected void unbindFactoryProvider(ReplicationContentFactoryProvider replicationContentFactoryProvider) {
        if (this.factoryProvider == replicationContentFactoryProvider) {
            this.factoryProvider = null;
        }
    }

    protected void bindCrypto(CryptoSupport cryptoSupport) {
        this.crypto = cryptoSupport;
    }

    protected void unbindCrypto(CryptoSupport cryptoSupport) {
        if (this.crypto == cryptoSupport) {
            this.crypto = null;
        }
    }
}

