/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.replication.impl;

import com.adobe.granite.crypto.CryptoException;
import com.adobe.granite.crypto.CryptoSupport;
import com.day.cq.replication.impl.AgentConfigImpl;
import java.util.List;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.SlingPostProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigPostProcessor
implements SlingPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(ConfigPostProcessor.class);
    private CryptoSupport crypto;

    public void process(SlingHttpServletRequest request, List<Modification> changes) throws Exception {
        Session session = null;
        for (Modification mod : changes) {
            switch (mod.getType()) {
                case MODIFY: 
                case CREATE: {
                    String path = mod.getSource();
                    if (!path.startsWith("/etc/replication/") || !path.endsWith("transportPassword") && !path.endsWith("proxyPassword")) break;
                    if (session == null) {
                        session = (Session)request.getResourceResolver().adaptTo(Session.class);
                    }
                    this.fix(session.getProperty(path));
                }
            }
        }
    }

    private void fix(Property p) throws RepositoryException {
        String pwd = p.getString();
        if (pwd.length() > 0 && !this.crypto.isProtected(pwd)) {
            String dec = AgentConfigImpl.legacyDecrypt(pwd);
            if (dec != null) {
                pwd = dec;
            }
            try {
                p.setValue(this.crypto.protect(pwd));
            }
            catch (CryptoException e) {
                log.error("Error during protecting password: {}", (Object)e.toString());
            }
        }
    }

    protected void bindCrypto(CryptoSupport cryptoSupport) {
        this.crypto = cryptoSupport;
    }

    protected void unbindCrypto(CryptoSupport cryptoSupport) {
        if (this.crypto == cryptoSupport) {
            this.crypto = null;
        }
    }
}

