/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.replication.impl;

import com.day.cq.replication.ReplicationContentFacade;
import com.day.cq.replication.impl.AbstractReplicationContent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileContent
extends AbstractReplicationContent {
    private static final long serialVersionUID = 5152314972876828947L;

    public FileContent(ReplicationContentFacade facade) {
        super(facade);
    }

    public FileContent(String filePath, String contentType, long size) {
        super(filePath, contentType, size);
    }

    @Override
    public long getLastModified() {
        File f = new File(this.facade.getPath());
        if (f.exists()) {
            return f.lastModified();
        }
        return -1L;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.facade.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acquire(String agentName) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            Status status = this.getStatus();
            if (status == null) {
                status = new Status();
            }
            if (status.agents.add(agentName)) {
                this.writeStatus(status);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(String agentName) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            Status status = this.getStatus();
            if (status != null) {
                if (status.agents.remove(agentName)) {
                    if (status.agents.isEmpty()) {
                        this.destroy();
                    } else {
                        this.writeStatus(status);
                    }
                } else if (status.agents.isEmpty()) {
                    this.destroy();
                }
            } else {
                this.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getAcquiredBy() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            Status status = this.getStatus();
            return status == null ? Collections.emptySet() : status.agents;
        }
    }

    @Override
    public void destroy() {
        FileUtils.deleteQuietly((File)new File(this.facade.getPath()));
        FileUtils.deleteQuietly((File)this.getStatusFile());
    }

    private File getStatusFile() {
        return new File(this.facade.getPath() + ".status");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStatus(Status status) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.getStatusFile());
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(status);
            oos.close();
        }
        catch (IOException ioe) {
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Status getStatus() {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.getStatusFile());
            ObjectInputStream ois = new ObjectInputStream(fis);
            Status result = (Status)ois.readObject();
            ois.close();
            Status status = result;
            return status;
        }
        catch (IOException ioe) {
            Status status = null;
            return status;
        }
        catch (ClassNotFoundException e) {
            Status status = null;
            return status;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    private static final class Status
    implements Serializable {
        private static final long serialVersionUID = 8607944593208680928L;
        public Set<String> agents = new HashSet<String>();

        private Status() {
        }
    }
}

