/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.replication.impl;

import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.replication.OutboxManager;
import com.day.cq.replication.ReplicationAction;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationException;
import com.day.durbo.DurboOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.io.input.ClosedInputStream;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.service.component.ComponentContext;

public class OutboxManagerImpl
implements OutboxManager {
    private static final String OUTBOX_PATH = "/var/replication/outbox";
    protected SlingRepository repository;
    private Session systemSession;

    protected void activate(ComponentContext context) {
        try {
            this.systemSession = this.repository.loginAdministrative(null);
        }
        catch (RepositoryException e) {
            throw new IllegalStateException("Error while initializing handler.", e);
        }
    }

    protected void deactivate(ComponentContext context) {
        if (this.systemSession != null) {
            this.systemSession.logout();
            this.systemSession = null;
        }
    }

    protected Node getOutboxNode(Session session, boolean create) throws RepositoryException {
        Node rootNode = session.getRootNode();
        Node outbox = null;
        String relPath = OUTBOX_PATH.substring(1);
        if (rootNode.hasNode(relPath)) {
            outbox = rootNode.getNode(relPath);
        }
        if (outbox == null && create) {
            outbox = JcrUtil.createPath((String)OUTBOX_PATH, (String)"sling:Folder", (String)"sling:Folder", (Session)session, (boolean)true);
        }
        return outbox;
    }

    public synchronized void put(InputStream in) throws ReplicationException {
        this.internalPut(in, null);
    }

    public synchronized void put(ReplicationAction action) throws ReplicationException {
        this.put(action, null);
    }

    public synchronized void put(ReplicationAction action, InputStream in) throws ReplicationException {
        if (in == null) {
            if (action.getType() == ReplicationActionType.ACTIVATE) {
                throw new ReplicationException("ACTIVATE requires replication content.");
            }
            in = ClosedInputStream.CLOSED_INPUT_STREAM;
        }
        this.internalPut(in, action);
    }

    private void internalPut(InputStream in, ReplicationAction action) throws ReplicationException {
        try {
            String nodename = String.valueOf(System.currentTimeMillis());
            Node outbox = this.getOutboxNode(this.systemSession, true);
            Node file = outbox.addNode(nodename, "nt:unstructured");
            Node content = file.addNode("jcr:content", "nt:unstructured");
            content.setProperty("jcr:data", in);
            content.setProperty("jcr:lastModified", Calendar.getInstance());
            content.setProperty("jcr:mimeType", "application/octet-stream");
            if (action != null) {
                content.setProperty("cq:repActionType", action.getType().name());
                content.setProperty("cq:repPath", action.getPath());
            }
            outbox.save();
        }
        catch (RepositoryException e) {
            try {
                this.systemSession.refresh(false);
            }
            catch (RepositoryException e2) {
                // empty catch block
            }
            String msg = "Unable to store content.";
            throw new ReplicationException(msg, (Exception)((Object)e));
        }
    }

    public synchronized void fetch(Session session, Calendar time, OutputStream out) throws ReplicationException {
        Node outbox = null;
        try {
            outbox = this.getOutboxNode(session, false);
        }
        catch (RepositoryException e) {
            String msg = "Unable to retrieve outbox node.";
            throw new ReplicationException(msg, (Exception)((Object)e));
        }
        try {
            if (outbox != null && time != null) {
                this.purge(outbox, time);
            }
        }
        catch (RepositoryException e) {
            try {
                session.refresh(false);
            }
            catch (RepositoryException e2) {
                // empty catch block
            }
            String msg = "Unable to purge old items.";
            throw new ReplicationException(msg, (Exception)((Object)e));
        }
        try {
            DurboOutput durboOut = new DurboOutput(out);
            durboOut.openNode("outbox");
            if (outbox != null) {
                NodeIterator files = outbox.getNodes();
                while (files.hasNext()) {
                    this.writeNode(files.nextNode(), durboOut);
                }
            }
            durboOut.closeNode();
            durboOut.close();
        }
        catch (IOException e) {
            String msg = "Unable to write items.";
            throw new ReplicationException(msg, e);
        }
        catch (RepositoryException e) {
            String msg = "Unable to iterate over outbox.";
            throw new ReplicationException(msg, (Exception)((Object)e));
        }
    }

    private void purge(Node outbox, Calendar time) throws RepositoryException {
        Node file;
        Node content;
        Calendar cal;
        ArrayList<String> outdated = new ArrayList<String>();
        NodeIterator files = outbox.getNodes();
        while (files.hasNext() && (cal = (content = (file = files.nextNode()).getNode("jcr:content")).getProperty("jcr:lastModified").getDate()).before(time)) {
            outdated.add(file.getName());
        }
        if (outdated.size() > 0) {
            for (String s : outdated) {
                outbox.getNode(s).remove();
            }
            outbox.save();
        }
    }

    private void writeNode(Node file, DurboOutput out) throws IOException, RepositoryException {
        Node content = file.getNode("jcr:content");
        out.openNode(file.getName());
        out.writeProperty(content.getProperty("jcr:lastModified"));
        OutboxManagerImpl.writeOptionalProperty(content, "cq:repActionType", out);
        OutboxManagerImpl.writeOptionalProperty(content, "cq:repPath", out);
        out.writeProperty(content.getProperty("jcr:data"));
        out.closeNode();
    }

    private static void writeOptionalProperty(Node parent, String propertyName, DurboOutput out) throws IOException, RepositoryException {
        if (parent.hasProperty(propertyName)) {
            out.writeProperty(parent.getProperty(propertyName));
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }
}

