/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.replication.impl;

import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.replication.ReplicationContent;
import com.day.cq.replication.ReplicationContentFacade;
import com.day.cq.replication.ReplicationContentFactory;
import com.day.cq.replication.impl.AbstractReplicationContent;
import com.day.cq.replication.impl.FileContentFactory;
import com.day.cq.replication.impl.ReplicationContentFactoryProvider;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationContentFactoryProviderImpl
implements ReplicationContentFactoryProvider {
    private static final Logger log = LoggerFactory.getLogger(ReplicationContentFactoryProviderImpl.class);
    private static final String CONTENT_PATH = "/var/replication/data";
    private SlingRepository repository = null;
    private SlingSettingsService settingsService = null;
    private String dataRoot;
    private File dataDir;
    private static final String OSGI_PROP_USE_FILE_STORAGE = "replication.content.useFileStorage";

    protected void activate(ComponentContext context) {
        boolean useFileStorage = OsgiUtil.toBoolean(context.getProperties().get(OSGI_PROP_USE_FILE_STORAGE), (boolean)false);
        if (useFileStorage) {
            File dir;
            String shared = this.repository.getDescriptor("com.day.crx.cluster.home");
            if (shared == null) {
                log.info("No shared directory information available from repository.");
                dir = new File(context.getBundleContext().getProperty("sling.home"));
                File tmp = new File(dir.getParentFile(), "repository");
                if (tmp.isDirectory() && (tmp = new File(tmp, "shared")).isDirectory()) {
                    dir = tmp;
                }
            } else {
                log.info("Using shared directory information from repository: {}", (Object)shared);
                dir = new File(shared);
            }
            this.dataDir = new File(dir, "replication");
            log.info("Data directory is {}", (Object)this.dataDir.getPath());
        } else {
            String nodeId = this.settingsService.getSlingId();
            if (nodeId == null || nodeId.length() == 0) {
                log.warn("No sling id? using random.");
                nodeId = UUID.randomUUID().toString();
            }
            this.dataRoot = "/var/replication/data/" + nodeId;
            log.info("Repository content root: {}", (Object)this.dataRoot);
        }
        log.info("ReplicationContentFactoryProvider service activated.");
    }

    protected void deactivate() {
    }

    public ReplicationContentFactory create(String agentId) throws RepositoryException {
        if (this.dataDir == null) {
            Session agentSession = this.repository.loginAdministrative(null);
            return new Factory(agentSession, agentId);
        }
        return new FileContentFactory(this.dataDir, agentId);
    }

    private void refreshAndWait(Session session) {
        try {
            session.refresh(false);
        }
        catch (RepositoryException e1) {
            // empty catch block
        }
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private Node getNewStorageNode(Session session) throws RepositoryException {
        String name = UUID.randomUUID().toString();
        String path = this.dataRoot + "/" + name.substring(0, 2);
        Node parent = null;
        int num = 0;
        while (parent == null) {
            try {
                if (session.nodeExists(path)) {
                    parent = session.getNode(path);
                    continue;
                }
                parent = JcrUtil.createPath((String)path, (String)"sling:Folder", (String)"sling:Folder", (Session)session, (boolean)true);
            }
            catch (RepositoryException e) {
                log.warn("Error while creating storage parent", (Throwable)e);
                session.refresh(false);
                if (num++ > 10) {
                    throw e;
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e1) {}
            }
        }
        return JcrUtil.createUniqueNode(parent, (String)name, (String)"nt:file", (Session)session);
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindSettingsService(SlingSettingsService slingSettingsService) {
        this.settingsService = slingSettingsService;
    }

    protected void unbindSettingsService(SlingSettingsService slingSettingsService) {
        if (this.settingsService == slingSettingsService) {
            this.settingsService = null;
        }
    }

    private class Factory
    implements ReplicationContentFactory {
        private final Session agentSession;

        private Factory(Session agentSession, String agentId) {
            this.agentSession = agentSession;
            log.info("RepositoryContentFactory for {} initialized.", (Object)agentId);
        }

        public ReplicationContent create(String mimeType, File file, boolean isTemp) throws IOException {
            return this.create(mimeType, file, file.lastModified(), isTemp);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public ReplicationContent create(String mimeType, File file, long lastModified, boolean isTemp) throws IOException {
            RepositoryContent repositoryContent;
            if (ReplicationContentFactoryProviderImpl.this.repository == null) {
                log.warn("Service already stopped. unable to create replication content.");
                throw new IOException("Service Stopped.");
            }
            Session session = null;
            try {
                try {
                    block13: {
                        session = ReplicationContentFactoryProviderImpl.this.repository.loginAdministrative(null);
                        int retries = 0;
                        RepositoryException error = null;
                        while (retries++ < 100) {
                            long size;
                            Calendar mod;
                            Node fileNode;
                            block12: {
                                fileNode = ReplicationContentFactoryProviderImpl.this.getNewStorageNode(session);
                                Node contentNode = fileNode.addNode("jcr:content", "nt:unstructured");
                                contentNode.setProperty("jcr:mimeType", mimeType);
                                mod = Calendar.getInstance();
                                mod.setTimeInMillis(lastModified);
                                contentNode.setProperty("jcr:lastModified", mod);
                                size = file.length();
                                Binary binary = null;
                                try {
                                    binary = session.getValueFactory().createBinary((InputStream)FileUtils.openInputStream((File)file));
                                    contentNode.setProperty("jcr:data", binary);
                                    repositoryContent = null;
                                    if (binary == null) break block12;
                                }
                                catch (Throwable throwable) {
                                    repositoryContent = null;
                                    if (binary == null) throw throwable;
                                    binary.dispose();
                                    throw throwable;
                                }
                                binary.dispose();
                            }
                            try {
                                session.save();
                                String path = fileNode.getPath();
                                if (isTemp) {
                                    FileUtils.deleteQuietly((File)file);
                                }
                                log.info("Created new repository content at {} (size={}, lastmod={})", new Object[]{path, size, ISO8601.format((Calendar)mod)});
                                repositoryContent = new RepositoryContent(path, mimeType, size);
                                break block13;
                            }
                            catch (RepositoryException e) {
                                error = e;
                                log.warn("Error storing repository content. retrying ({}/100): {}", (Object)e.toString());
                                ReplicationContentFactoryProviderImpl.this.refreshAndWait(session);
                            }
                        }
                        throw new RepositoryException("Unable to create content after 100 retries.", error);
                    }
                    Object var18_19 = null;
                    if (session == null) return repositoryContent;
                }
                catch (RepositoryException e) {
                    IOException e1 = new IOException(e.toString());
                    e1.initCause(e);
                    throw e1;
                }
            }
            catch (Throwable throwable) {
                Object var18_20 = null;
                if (session == null) throw throwable;
                session.logout();
                throw throwable;
            }
            session.logout();
            return repositoryContent;
        }

        public ReplicationContent create(ReplicationContentFacade facade) {
            if (facade == null) {
                return ReplicationContent.VOID;
            }
            return new RepositoryContent(facade);
        }

        public void close() {
            if (this.agentSession.isLive()) {
                this.agentSession.logout();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class RepositoryContent
        extends AbstractReplicationContent {
            private static final long serialVersionUID = 6506881886574345693L;

            RepositoryContent(String path, String contentType, long size) {
                super(path, contentType, size);
            }

            RepositoryContent(ReplicationContentFacade facade) {
                super(facade);
            }

            @Override
            public InputStream getInputStream() throws IOException {
                try {
                    return this.getNode(Factory.this.agentSession).getProperty("jcr:content/jcr:data").getBinary().getStream();
                }
                catch (RepositoryException e) {
                    IOException e1 = new IOException(e.toString());
                    e1.initCause(e);
                    throw e1;
                }
            }

            @Override
            public long getLastModified() {
                try {
                    return this.getNode(Factory.this.agentSession).getProperty("jcr:content/jcr:lastModified").getDate().getTimeInMillis();
                }
                catch (Exception e) {
                    log.warn("unable to retrieve last modified date of " + this.facade.getPath(), (Throwable)e);
                    return -1L;
                }
            }

            private Node getNode(Session s) throws IOException {
                try {
                    if (!s.isLive()) {
                        log.warn("Service already stopped. unable to create replication content.");
                        throw new IOException("Service Stopped.");
                    }
                    if (!s.nodeExists(this.facade.getPath())) {
                        throw new FileNotFoundException(this.facade.getPath());
                    }
                    return s.getNode(this.facade.getPath());
                }
                catch (RepositoryException e) {
                    IOException e1 = new IOException(e.toString());
                    e1.initCause(e);
                    throw e1;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void acquire(String agentName) {
                Session session;
                block16: {
                    block14: {
                        block15: {
                            block13: {
                                if (ReplicationContentFactoryProviderImpl.this.repository == null) {
                                    log.warn("Service already stopped. unable to update replication content.");
                                    return;
                                }
                                session = null;
                                try {
                                    try {
                                        session = ReplicationContentFactoryProviderImpl.this.repository.loginAdministrative(null);
                                        int attempts = 0;
                                        while (attempts++ < 10) {
                                            if (!session.nodeExists(this.facade.getPath())) {
                                                log.warn("Replication content node does not exist {}.", (Object)this.facade.getPath());
                                                Object var11_12 = null;
                                                if (session == null) return;
                                                break block13;
                                            }
                                            Node node = session.getNode(this.facade.getPath() + "/jcr:content");
                                            HashSet<String> ret = new HashSet<String>();
                                            if (node.hasProperty("cq:agents")) {
                                                for (Value v : node.getProperty("cq:agents").getValues()) {
                                                    ret.add(v.getString());
                                                }
                                            }
                                            if (!ret.add(agentName)) break block14;
                                            node.setProperty("cq:agents", ret.toArray(new String[ret.size()]));
                                            try {
                                                session.save();
                                                break block15;
                                            }
                                            catch (RepositoryException e) {
                                                ReplicationContentFactoryProviderImpl.this.refreshAndWait(session);
                                            }
                                        }
                                        log.error("Unable to update 'agents' property of {} after {} attempts", (Object)this.facade.getPath(), (Object)attempts);
                                        break block16;
                                    }
                                    catch (RepositoryException e) {
                                        log.warn("unable to update agents of " + this.facade.getPath(), (Throwable)e);
                                        Object var11_16 = null;
                                        if (session == null) return;
                                        session.logout();
                                        return;
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var11_17 = null;
                                    if (session == null) throw throwable;
                                    session.logout();
                                    throw throwable;
                                }
                            }
                            session.logout();
                            return;
                        }
                        Object var11_13 = null;
                        if (session == null) return;
                        session.logout();
                        return;
                    }
                    Object var11_14 = null;
                    if (session == null) return;
                    session.logout();
                    return;
                }
                Object var11_15 = null;
                if (session == null) return;
                session.logout();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void release(String agentName) {
                Session session;
                block15: {
                    block14: {
                        if (ReplicationContentFactoryProviderImpl.this.repository == null) {
                            log.warn("Service already stopped. unable to update replication content.");
                            return;
                        }
                        session = null;
                        try {
                            try {
                                session = ReplicationContentFactoryProviderImpl.this.repository.loginAdministrative(null);
                                int attempts = 0;
                                HashSet<String> ret = new HashSet<String>();
                                while (attempts++ < 10) {
                                    if (!session.nodeExists(this.facade.getPath())) {
                                        log.warn("Replication content node does not exist {}.", (Object)this.facade.getPath());
                                        Object var11_12 = null;
                                        if (session == null) return;
                                        break block14;
                                    }
                                    ret.clear();
                                    Node node = session.getNode(this.facade.getPath() + "/jcr:content");
                                    if (node.hasProperty("cq:agents")) {
                                        for (Value v : node.getProperty("cq:agents").getValues()) {
                                            ret.add(v.getString());
                                        }
                                    }
                                    if (!ret.remove(agentName) || ret.isEmpty()) break;
                                    node.setProperty("cq:agents", ret.toArray(new String[ret.size()]));
                                    try {
                                        session.save();
                                        break;
                                    }
                                    catch (RepositoryException e) {
                                        ReplicationContentFactoryProviderImpl.this.refreshAndWait(session);
                                    }
                                }
                                if (attempts == 10) {
                                    log.error("Unable to update 'agents' property of {} after {} attempts", (Object)this.facade.getPath(), (Object)attempts);
                                }
                                if (ret.isEmpty()) {
                                    this.destroy(session);
                                }
                                break block15;
                            }
                            catch (RepositoryException e) {
                                log.warn("unable to update agents of " + this.facade.getPath(), (Throwable)e);
                                Object var11_14 = null;
                                if (session == null) return;
                                session.logout();
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var11_15 = null;
                            if (session == null) throw throwable;
                            session.logout();
                            throw throwable;
                        }
                    }
                    session.logout();
                    return;
                }
                Object var11_13 = null;
                if (session == null) return;
                session.logout();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Collection<String> getAcquiredBy() {
                HashSet<String> hashSet;
                block12: {
                    Session session;
                    block10: {
                        Set<String> set;
                        block11: {
                            block8: {
                                Set<String> set2;
                                block9: {
                                    session = null;
                                    if (ReplicationContentFactoryProviderImpl.this.repository != null) break block8;
                                    log.warn("Service already stopped. unable to create replication content.");
                                    set2 = Collections.emptySet();
                                    Object var9_6 = null;
                                    if (session == null) break block9;
                                    session.logout();
                                }
                                return set2;
                            }
                            session = ReplicationContentFactoryProviderImpl.this.repository.loginAdministrative(null);
                            if (session.nodeExists(this.facade.getPath())) break block10;
                            log.warn("Replication content node does not exist {}.", (Object)this.facade.getPath());
                            set = Collections.emptySet();
                            Object var9_7 = null;
                            if (session == null) break block11;
                            session.logout();
                        }
                        return set;
                    }
                    try {
                        Node node = session.getNode(this.facade.getPath() + "/jcr:content");
                        HashSet<String> ret = new HashSet<String>();
                        if (node.hasProperty("cq:agents")) {
                            for (Value v : node.getProperty("cq:agents").getValues()) {
                                ret.add(v.getString());
                            }
                        }
                        hashSet = ret;
                        Object var9_8 = null;
                        if (session == null) break block12;
                    }
                    catch (RepositoryException e) {
                        Set<String> set;
                        block13: {
                            try {
                                log.warn("unable to retrieve agents of " + this.facade.getPath(), (Throwable)e);
                                set = Collections.emptySet();
                                Object var9_9 = null;
                                if (session == null) break block13;
                            }
                            catch (Throwable throwable) {
                                block14: {
                                    Object var9_10 = null;
                                    if (session == null) break block14;
                                    session.logout();
                                }
                                throw throwable;
                            }
                            session.logout();
                        }
                        return set;
                    }
                    session.logout();
                }
                return hashSet;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void destroy() {
                Session session;
                block7: {
                    block6: {
                        session = null;
                        try {
                            try {
                                if (ReplicationContentFactoryProviderImpl.this.repository == null) {
                                    log.warn("Service already stopped. unable to destroy replication content.");
                                    Object var4_2 = null;
                                    if (session == null) return;
                                    break block6;
                                }
                                session = ReplicationContentFactoryProviderImpl.this.repository.loginAdministrative(null);
                                this.destroy(session);
                                break block7;
                            }
                            catch (RepositoryException e) {
                                log.warn("Error while login.", (Throwable)e);
                                Object var4_4 = null;
                                if (session == null) return;
                                session.logout();
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var4_5 = null;
                            if (session == null) throw throwable;
                            session.logout();
                            throw throwable;
                        }
                    }
                    session.logout();
                    return;
                }
                Object var4_3 = null;
                if (session == null) return;
                session.logout();
            }

            private void destroy(Session session) {
                int num = 0;
                while (num++ < 10) {
                    try {
                        if (!session.nodeExists(this.facade.getPath())) continue;
                        session.removeItem(this.facade.getPath());
                        session.save();
                        return;
                    }
                    catch (RepositoryException e) {
                        log.warn("Unable to destroy replication content", (Throwable)e);
                        ReplicationContentFactoryProviderImpl.this.refreshAndWait(session);
                    }
                }
                log.error("Unable to delete replication content of {} after {} attempts", (Object)this.facade.getPath(), (Object)num);
            }
        }
    }
}

