/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.replication.impl;

import com.day.cq.replication.Agent;
import com.day.cq.replication.ReplicationLog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicationLogImpl
implements ReplicationLog {
    private final Logger logger;
    private ReplicationLog.Level level;
    private final String category;
    private int maxLines = 8192;
    private final LinkedList<String> lines = new LinkedList();

    public ReplicationLogImpl(String category, ReplicationLog.Level logLevel) {
        this.category = category;
        this.level = logLevel;
        this.logger = LoggerFactory.getLogger((String)(Agent.class.getName() + "." + category));
    }

    @Override
    public ReplicationLog.Level getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(ReplicationLog.Level level) {
        this.level = level;
    }

    public void setLevel(String level) {
        try {
            this.level = ReplicationLog.Level.valueOf(level.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public int getMaxLines() {
        return this.maxLines;
    }

    public void setMaxLines(int maxLines) {
        this.maxLines = maxLines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void log(ReplicationLog.Level level, String message) {
        if (level.cardinal < this.level.cardinal) {
            return;
        }
        StringBuffer log = new StringBuffer();
        log.append(System.currentTimeMillis());
        log.append(" - ");
        log.append(level.name());
        log.append(" - ");
        log.append(this.category);
        log.append(" : ");
        log.append(message);
        LinkedList<String> linkedList = this.lines;
        synchronized (linkedList) {
            this.lines.add(log.toString());
            while (this.lines.size() > this.maxLines) {
                this.lines.removeFirst();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getLines() {
        LinkedList<String> linkedList = this.lines;
        synchronized (linkedList) {
            return new ArrayList<String>(this.lines);
        }
    }

    @Override
    public void debug(String message) {
        this.logger.debug(message);
        this.log(ReplicationLog.Level.DEBUG, message);
    }

    @Override
    public void debug(String fmt, Object ... args) {
        this.debug(String.format(fmt, args));
    }

    @Override
    public void info(String message) {
        this.logger.info(message);
        this.log(ReplicationLog.Level.INFO, message);
    }

    @Override
    public void info(String fmt, Object ... args) {
        this.info(String.format(fmt, args));
    }

    @Override
    public void warn(String message) {
        this.logger.warn(message);
        this.log(ReplicationLog.Level.WARN, message);
    }

    @Override
    public void warn(String fmt, Object ... args) {
        this.warn(String.format(fmt, args));
    }

    @Override
    public void error(String message) {
        this.logger.error(message);
        this.log(ReplicationLog.Level.ERROR, message);
    }

    @Override
    public void error(String fmt, Object ... args) {
        this.error(String.format(fmt, args));
    }
}

