/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.replication.impl;

import com.day.cq.replication.ReplicationAction;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationException;
import com.day.cq.replication.ReplicationReceiver;
import com.day.cq.replication.content.durbo.DurboImporter;
import com.day.jcr.vault.fs.api.ProgressTrackerListener;
import com.day.jcr.vault.fs.spi.ServiceProviderFactory;
import com.day.jcr.vault.packaging.ImportOptions;
import com.day.jcr.vault.packaging.JcrPackage;
import com.day.jcr.vault.packaging.JcrPackageManager;
import com.day.jcr.vault.packaging.PackagingService;
import com.day.jcr.vault.util.DefaultProgressListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicationReceiverImpl
implements ReplicationReceiver {
    private static final Logger log = LoggerFactory.getLogger(ReplicationReceiverImpl.class);
    public static final String OSGI_PROP_TMPFILE_THRESHOLD = "receiver.tmpfile.threshold";
    private long tmpfileThreshold;

    protected void activate(Map<String, Object> props) {
        this.tmpfileThreshold = OsgiUtil.toLong((Object)props.get(OSGI_PROP_TMPFILE_THRESHOLD), (long)0x100000L);
        log.info("Receiver started. threshold set to {}", (Object)this.tmpfileThreshold);
    }

    @Override
    public void receive(Session session, ReplicationAction action, InputStream in, long size, Writer writer) throws ReplicationException, IOException {
        Node page = null;
        if (action.getType() == ReplicationActionType.ACTIVATE) {
            DurboImporter importer = new DurboImporter();
            importer.setTempFileThreshold(this.tmpfileThreshold);
            page = importer.createPage(session, action.getPath(), in, size);
        }
        new ReceiveListener(session, action, writer).onReceived(page);
    }

    private class ReceiveListener {
        private final Session session;
        private final ReplicationAction action;
        private final Writer writer;

        private ReceiveListener(Session session, ReplicationAction action, Writer writer) {
            this.session = session;
            this.action = action;
            this.writer = writer;
        }

        private void onReceived(Node page) throws ReplicationException, IOException {
            try {
                ReplicationActionType type = this.action.getType();
                switch (type) {
                    case ACTIVATE: {
                        this.onActivate(page);
                        break;
                    }
                    case DELETE: {
                        this.onDelete();
                        break;
                    }
                    case DEACTIVATE: {
                        this.onDeactivate();
                        break;
                    }
                    case TEST: {
                        this.onTest();
                        break;
                    }
                    default: {
                        throw new ReplicationException("Unknown ReplicationActionType: " + (Object)((Object)type));
                    }
                }
                if (this.writer != null) {
                    this.writer.write("ReplicationAction " + type.toString() + " ok.");
                }
            }
            catch (ReplicationException e) {
                log.error("Unable to receive replication.", (Throwable)e);
                throw e;
            }
        }

        private void onActivate(Node page) throws ReplicationException {
            String path = null;
            try {
                path = page.getPath();
            }
            catch (Exception e) {
                log.error("Error while retrieving path of node.", (Throwable)e);
            }
            try {
                if (path.startsWith("/etc/packages/") && page.isNodeType("nt:file")) {
                    this.writer.write("Content package received at " + path + ". Starting import.\n");
                    JcrPackageManager packMgr = PackagingService.getPackageManager((Session)page.getSession());
                    JcrPackage pack = packMgr.open(page);
                    ImportOptions opts = new ImportOptions();
                    opts.setListener((ProgressTrackerListener)new DefaultProgressListener(new PrintWriter(this.writer)));
                    opts.setNtInstaller(ServiceProviderFactory.getProvider().getDefaultNodeTypeInstaller(page.getSession()));
                    pack.extract(opts);
                }
            }
            catch (Exception e) {
                log.error("Error while unpacking package at " + path, (Throwable)e);
            }
        }

        private void onDelete() throws ReplicationException {
            try {
                String path = this.action.getPath();
                if (this.session.itemExists(path)) {
                    this.session.getItem(path).remove();
                    this.session.save();
                }
            }
            catch (RepositoryException e) {
                throw new ReplicationException((Exception)((Object)e));
            }
        }

        private void onDeactivate() throws ReplicationException {
            try {
                String path = this.action.getPath();
                if (this.session.itemExists(path)) {
                    this.session.getItem(path).remove();
                    this.session.save();
                }
            }
            catch (RepositoryException e) {
                throw new ReplicationException((Exception)((Object)e));
            }
        }

        private void onTest() {
        }
    }
}

