/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.replication.impl;

import com.day.cq.replication.Agent;
import com.day.cq.replication.AgentManager;
import com.day.cq.replication.ReplicationAction;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationContent;
import com.day.cq.replication.ReplicationException;
import com.day.cq.replication.ReplicationLog;
import com.day.cq.replication.Replicator;
import com.day.cq.replication.ReverseReplication;
import com.day.cq.replication.content.durbo.DurboImporter;
import com.day.durbo.DurboInput;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.sling.jcr.api.SlingRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReverseReplicator
implements Runnable,
DurboImporter.Hook {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private SlingRepository repository = null;
    private AgentManager agentMgr = null;
    private Replicator replicator = null;
    private final Lock lock = new ReentrantLock();
    private final Condition guard = this.lock.newCondition();
    private static final String FREQUENCY_PROPERTY = "frequency";
    public static final String ROOT_PATHS = "root-paths";
    private String[] rootPaths;
    private long frequency;
    private boolean running;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(Map<String, Object> config) {
        Long frequency = (Long)config.get(FREQUENCY_PROPERTY);
        if (frequency == null) {
            frequency = 30000L;
        }
        this.frequency = frequency;
        this.rootPaths = (String[])config.get(ROOT_PATHS);
        this.lock.lock();
        try {
            if (this.running) {
                this.logger.error("service already running. refuse to initialize twice.");
            } else {
                Thread t = new Thread((Runnable)this, "Reverse Replication Processor");
                t.setDaemon(true);
                this.running = true;
                t.start();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deactivate() {
        this.lock.lock();
        try {
            this.running = false;
            this.guard.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.lock.lock();
        try {
            while (this.running) {
                try {
                    this.guard.await(this.frequency, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    this.logger.warn("Condition interrupted.", (Throwable)e);
                }
                if (!this.running) {
                    return;
                }
                this.lock.unlock();
                try {
                    if (this.isMaster()) {
                        this.logger.debug("Running reverse replication, since this is the cluster master...");
                        this.poll();
                        continue;
                    }
                    this.logger.debug("Skipping reverse replication, since this is a cluster slave.");
                }
                catch (ReplicationException e) {
                    String msg = "Error during poll.";
                    this.logger.warn(msg, (Throwable)e);
                }
                finally {
                    this.lock.lock();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean isMaster() {
        String value = this.repository.getDescriptor("crx.cluster.master");
        return value == null || "true".equals(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void poll() throws ReplicationException {
        LinkedList<Agent> agents = new LinkedList<Agent>();
        for (Agent agent : this.agentMgr.getAgents().values()) {
            if (!agent.isValid() || !agent.isEnabled() || !agent.getConfiguration().usedForReverseReplication()) continue;
            agents.add(agent);
        }
        if (agents.isEmpty()) {
            return;
        }
        ReplicationAction action = new ReplicationAction(ReplicationActionType.REVERSE, "", 0L, "", null);
        Session session = null;
        try {
            session = this.repository.loginAdministrative(null);
            for (Agent agent : agents) {
                Session agentSession = session;
                ReplicationLog log = agent.getLog();
                String userId = agent.getConfiguration().getAgentUserId();
                if (userId != null) {
                    try {
                        agentSession = session.impersonate((Credentials)new SimpleCredentials(userId, new char[0]));
                        log.info("Using user %s for building content.", userId);
                    }
                    catch (RepositoryException e) {
                        log.error("Error while impersonating to user '%s'. using system session.", userId);
                    }
                }
                try {
                    this.poll(agent, agentSession, action);
                }
                catch (Exception e) {
                    log.error("Error while polling agent %s: %s", agent.getId(), e.toString());
                    this.logger.error("Error while poling agent " + agent.getId(), (Throwable)e);
                }
                finally {
                    if (agentSession == session) continue;
                    agentSession.logout();
                }
            }
        }
        catch (RepositoryException e) {
            throw new ReplicationException("Error while accessing repository", (Exception)((Object)e));
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void poll(Agent agent, Session agentSession, ReplicationAction action) throws ReplicationException {
        long lastModified2;
        ReverseReplication[] repsArray = agent.poll(action);
        if (repsArray == null || repsArray.length == 0) {
            return;
        }
        ReplicationLog log = agent.getLog();
        ArrayList<RevRepEntry> reps = new ArrayList<RevRepEntry>(repsArray.length);
        for (ReverseReplication rep : repsArray) {
            reps.add(new RevRepEntry(rep));
        }
        try {
            int numUnprocessed = reps.size();
            int lastSize = 0;
            int numRetries = 1;
            while (numUnprocessed > 0 && numRetries > 0) {
                numUnprocessed = this.importAll(reps, agentSession, log);
                if (numUnprocessed > 0) {
                    numRetries = lastSize == numUnprocessed ? --numRetries : 1;
                    if (numRetries > 0) {
                        log.info("Some of the polled replication data could not be imported. retrying with remaining " + numUnprocessed);
                    } else {
                        log.info("Some of the polled replication data could not be imported. Aborting.");
                    }
                }
                lastSize = numUnprocessed;
            }
            Object var12_12 = null;
            lastModified2 = 0L;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            long lastModified2 = 0L;
            for (RevRepEntry rep : reps) {
                if (!rep.success) {
                    if (lastModified2 != rep.lastModified) break;
                    --lastModified2;
                    break;
                }
                if (rep.lastModified <= lastModified2) continue;
                lastModified2 = rep.lastModified;
            }
            if (lastModified2 > 0L) {
                Calendar lastPoll = Calendar.getInstance();
                lastPoll.setTimeInMillis(lastModified2 + 1L);
                log.info("Setting last poll time to %s", ISO8601.format((Calendar)lastPoll));
                agent.setNextPollTimeline(lastPoll);
            } else {
                log.info("Not updating last poll time due to errors.");
            }
            for (RevRepEntry rep : reps) {
                if (rep.success) continue;
                rep.replication.getContent().destroy();
                log.error("Errors during importing reverse replicated content of %s", rep.replication.getAction().getPath());
            }
            throw throwable;
        }
        for (RevRepEntry rep : reps) {
            if (!rep.success) {
                if (lastModified2 != rep.lastModified) break;
                --lastModified2;
                break;
            }
            if (rep.lastModified <= lastModified2) continue;
            lastModified2 = rep.lastModified;
        }
        if (lastModified2 > 0L) {
            Calendar lastPoll = Calendar.getInstance();
            lastPoll.setTimeInMillis(lastModified2 + 1L);
            log.info("Setting last poll time to %s", ISO8601.format((Calendar)lastPoll));
            agent.setNextPollTimeline(lastPoll);
        } else {
            log.info("Not updating last poll time due to errors.");
        }
        for (RevRepEntry rep : reps) {
            if (rep.success) continue;
            rep.replication.getContent().destroy();
            log.error("Errors during importing reverse replicated content of %s", rep.replication.getAction().getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int importAll(List<RevRepEntry> reps, Session agentSession, ReplicationLog log) {
        int numErrors = 0;
        for (RevRepEntry rep : reps) {
            Object var12_13;
            if (rep.success) continue;
            ReverseReplication r = rep.replication;
            ReplicationContent c = r.getContent();
            rep.lastModified = c.getLastModified();
            try {
                switch (r.getAction().getType()) {
                    case ACTIVATE: {
                        try {
                            this.importPage(c, agentSession);
                            rep.success = true;
                            log.info("Successfully imported content at %s", r.getAction().getPath());
                        }
                        catch (ReplicationException e) {
                            log.info("Cannot import content at %s: %s", r.getAction().getPath(), e);
                            try {
                                agentSession.refresh(false);
                            }
                            catch (RepositoryException e1) {}
                        }
                        break;
                    }
                    case DELETE: {
                        try {
                            this.deletePage(r.getAction().getPath(), agentSession);
                            rep.success = true;
                        }
                        catch (ReplicationException e) {
                            log.info("Cannot delete %s: %s", r.getAction().getPath(), e);
                        }
                        break;
                    }
                    default: {
                        log.warn("Reverse replication not implemented for action: %s", new Object[]{r.getAction().getType()});
                    }
                }
                var12_13 = null;
            }
            catch (Throwable throwable) {
                var12_13 = null;
                if (rep.success) {
                    c.destroy();
                } else {
                    ++numErrors;
                }
                throw throwable;
            }
            if (rep.success) {
                c.destroy();
                continue;
            }
            ++numErrors;
            {
            }
        }
        return numErrors;
    }

    private void importPage(ReplicationContent page, Session agentSession) throws ReplicationException {
        InputStream in = null;
        try {
            try {
                in = page.getInputStream();
                DurboImporter importer = new DurboImporter();
                importer.setHook(this);
                importer.createPage(agentSession, null, new DurboInput(in));
            }
            catch (IOException e) {
                String msg = "Unable to open input stream on replication content.";
                throw new ReplicationException(msg, e);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            IOUtils.closeQuietly((InputStream)in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
    }

    private void deletePage(String path, Session agentSession) throws ReplicationException {
        this.logger.debug("Starting page deletion for durbo request on path: {}", (Object)path);
        try {
            if (agentSession.itemExists(path)) {
                agentSession.getItem(path).remove();
                this.logger.debug("Saving...");
                agentSession.save();
                this.logger.info("Page {} deleted.", (Object)path);
                if (this.liesUnderneath(path)) {
                    this.logger.info("Replicating deletion of {}.");
                    this.replicator.replicate(agentSession, ReplicationActionType.DELETE, path);
                }
            } else {
                this.logger.debug("Page {} does not exist.", (Object)path);
            }
        }
        catch (RepositoryException e) {
            String msg = String.format("Repository error during page deletion: %s", e.getMessage());
            throw new ReplicationException(msg, (Exception)((Object)e));
        }
    }

    private boolean liesUnderneath(String path) {
        for (String rootPath : this.rootPaths) {
            if (!path.startsWith(rootPath)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void beforeSave(Node node) throws RepositoryException {
        if (node == null) {
            return;
        }
        Calendar date = Calendar.getInstance();
        String userId = node.getSession().getUserID();
        ReplicationActionType type = ReplicationActionType.ACTIVATE;
        if (node.hasNode("jcr:content")) {
            Node content = node.getNode("jcr:content");
            try {
                if (!content.isNodeType("cq:ReplicationStatus") && content.canAddMixin("cq:ReplicationStatus")) {
                    content.addMixin("cq:ReplicationStatus");
                }
                content.setProperty("cq:lastReplicationAction", type.getName());
                content.setProperty("cq:lastReplicatedBy", userId);
                content.setProperty("cq:lastReplicated", date);
            }
            catch (RepositoryException e) {
                this.logger.warn("unable to update replication status.", (Throwable)e);
            }
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindAgentMgr(AgentManager agentManager) {
        this.agentMgr = agentManager;
    }

    protected void unbindAgentMgr(AgentManager agentManager) {
        if (this.agentMgr == agentManager) {
            this.agentMgr = null;
        }
    }

    protected void bindReplicator(Replicator replicator) {
        this.replicator = replicator;
    }

    protected void unbindReplicator(Replicator replicator) {
        if (this.replicator == replicator) {
            this.replicator = null;
        }
    }

    private static final class RevRepEntry {
        private final ReverseReplication replication;
        private boolean success;
        private long lastModified;

        private RevRepEntry(ReverseReplication replication) {
            this.replication = replication;
        }
    }
}

