/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.replication.impl;

import com.day.cq.replication.AgentConfig;
import com.day.cq.replication.ContentBuilder;
import com.day.cq.replication.TransportHandler;
import com.day.cq.replication.impl.ServiceTracker;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceTrackerImpl
implements ServiceTracker {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, ContentBuilder> contentBuilders = new HashMap<String, ContentBuilder>();
    private final Map<String, String> contentBuildersByName = new HashMap<String, String>();
    private final Map<String, TransportHandler> transportHandlers = new HashMap<String, TransportHandler>();
    private ComponentContext context;
    private final Map<String, ServiceDesc> unhandledServices = new HashMap<String, ServiceDesc>();
    private final Set<ServiceTracker.Listener> listeners = new HashSet<ServiceTracker.Listener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(ComponentContext context) {
        Map<String, ServiceDesc> map = this.unhandledServices;
        synchronized (map) {
            this.context = context;
            for (ServiceDesc ref : this.unhandledServices.values()) {
                this.register(ref.type, ref.ref);
            }
            this.unhandledServices.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deactivate(ComponentContext context) {
        Map<String, ServiceDesc> map = this.unhandledServices;
        synchronized (map) {
            this.context = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindContentBuilder(ServiceReference ref) {
        Map<String, ServiceDesc> map = this.unhandledServices;
        synchronized (map) {
            if (this.context == null) {
                ServiceDesc desc = new ServiceDesc();
                desc.type = ServiceDescType.CONTENTBUILDER;
                desc.ref = ref;
                this.unhandledServices.put((String)ref.getProperty("service.pid"), desc);
            } else {
                this.register(ServiceDescType.CONTENTBUILDER, ref);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindTransportHandler(ServiceReference ref) {
        Map<String, ServiceDesc> map = this.unhandledServices;
        synchronized (map) {
            if (this.context == null) {
                ServiceDesc desc = new ServiceDesc();
                desc.type = ServiceDescType.TRANSPORTHANDLER;
                desc.ref = ref;
                this.unhandledServices.put((String)ref.getProperty("service.pid"), desc);
            } else {
                this.register(ServiceDescType.TRANSPORTHANDLER, ref);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindContentBuilder(ServiceReference ref) {
        Map<String, ServiceDesc> map = this.unhandledServices;
        synchronized (map) {
            this.unregister(ServiceDescType.CONTENTBUILDER, ref);
            this.unhandledServices.remove(ref.getProperty("service.pid"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindTransportHandler(ServiceReference ref) {
        Map<String, ServiceDesc> map = this.unhandledServices;
        synchronized (map) {
            this.unregister(ServiceDescType.TRANSPORTHANDLER, ref);
            this.unhandledServices.remove(ref.getProperty("service.pid"));
        }
    }

    private void register(ServiceDescType type, ServiceReference ref) {
        String key = (String)ref.getProperty("service.pid");
        String name = (String)ref.getProperty("name");
        Object service = null;
        switch (type) {
            case CONTENTBUILDER: {
                service = this.context.locateService("contentBuilder", ref);
                if (service == null) break;
                this.contentBuilders.put(key, (ContentBuilder)service);
                this.contentBuildersByName.put(name, key);
                for (ServiceTracker.Listener l : this.listeners) {
                    l.onBind((ContentBuilder)service);
                }
                break;
            }
            case TRANSPORTHANDLER: {
                service = this.context.locateService("transportHandler", ref);
                if (service == null) break;
                this.transportHandlers.put(key, (TransportHandler)service);
                for (ServiceTracker.Listener l : this.listeners) {
                    l.onBind((TransportHandler)service);
                }
                break;
            }
        }
        if (service != null) {
            this.logger.debug("Registering service {} : {}", (Object)key, service);
        }
    }

    private void unregister(ServiceDescType type, ServiceReference ref) {
        String key = (String)ref.getProperty("service.pid");
        String name = (String)ref.getProperty("name");
        switch (type) {
            case CONTENTBUILDER: {
                ContentBuilder builder = this.contentBuilders.remove(key);
                this.contentBuildersByName.remove(name);
                if (builder == null) break;
                for (ServiceTracker.Listener l : this.listeners) {
                    l.onUnbind(builder);
                }
                break;
            }
            case TRANSPORTHANDLER: {
                TransportHandler handler = this.transportHandlers.remove(key);
                if (handler == null) break;
                for (ServiceTracker.Listener l : this.listeners) {
                    l.onUnbind(handler);
                }
                break;
            }
        }
        this.logger.debug("Unregistering service {}.", (Object)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentBuilder getContentBuilder(String name) {
        Map<String, ServiceDesc> map = this.unhandledServices;
        synchronized (map) {
            String serviceId = this.contentBuildersByName.get(name);
            if (serviceId != null) {
                return this.contentBuilders.get(serviceId);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransportHandler getTransportHandler(AgentConfig config) {
        Map<String, ServiceDesc> map = this.unhandledServices;
        synchronized (map) {
            for (TransportHandler handler : this.transportHandlers.values()) {
                if (!handler.canHandle(config)) continue;
                return handler;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(ServiceTracker.Listener listener) {
        Map<String, ServiceDesc> map = this.unhandledServices;
        synchronized (map) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterListener(ServiceTracker.Listener listener) {
        Map<String, ServiceDesc> map = this.unhandledServices;
        synchronized (map) {
            this.listeners.remove(listener);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ServiceDescType {
        CONTENTBUILDER,
        TRANSPORTHANDLER;

    }

    private static final class ServiceDesc {
        public ServiceDescType type;
        public ServiceReference ref;

        private ServiceDesc() {
        }
    }
}

