/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.replication.impl.queue;

import com.day.cq.replication.Agent;
import com.day.cq.replication.ReplicationAction;
import com.day.cq.replication.ReplicationContentFacade;
import com.day.cq.replication.ReplicationException;
import com.day.cq.replication.ReplicationQueue;
import com.day.cq.replication.impl.queue.QueueListener;
import com.day.cq.replication.impl.queue.ReplicationJob;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.apache.sling.event.jobs.JobManager;
import org.apache.sling.event.jobs.Queue;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicationQueueImpl
implements ReplicationQueue {
    private final Logger log;
    private final EventAdmin eventAdmin;
    private final JobManager jobManager;
    private final String name;
    private QueueListener agent;
    private final String queueTopic;
    private volatile long processingSince = 0L;

    public ReplicationQueueImpl(EventAdmin eventAdmin, JobManager mgr, String name) {
        this.eventAdmin = eventAdmin;
        this.name = name;
        this.log = LoggerFactory.getLogger((String)(Agent.class.getName() + "." + name + ".queue"));
        this.jobManager = mgr;
        this.queueTopic = "com/day/cq/replication/job/" + name;
    }

    private Queue getJobQueue() {
        Queue q = this.jobManager.getQueue(this.queueTopic);
        if (q == null) {
            this.log.warn("Queue {} not found.", (Object)this.queueTopic);
        }
        return q;
    }

    public void open(QueueListener agent) {
        this.agent = agent;
    }

    public void close(boolean clear) {
        if (clear) {
            this.clear();
        }
        this.agent = null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isPaused() {
        Queue q = this.getJobQueue();
        return q != null && q.isSuspended();
    }

    @Override
    public void setPaused(boolean paused) {
        Queue q = this.getJobQueue();
        if (q != null) {
            if (paused) {
                this.getJobQueue().suspend();
            } else {
                this.getJobQueue().resume();
            }
        }
    }

    @Override
    public List<ReplicationQueue.Entry> entries() {
        LinkedList<ReplicationQueue.Entry> entries = new LinkedList<ReplicationQueue.Entry>();
        int i = 0;
        for (Event evt : this.jobManager.queryJobs(JobManager.QueryType.ALL, this.queueTopic, new Map[0])) {
            ReplicationJob job = new ReplicationJob(evt);
            entries.add(new EntryImpl(job.getEventId(), job, i++));
        }
        return entries;
    }

    @Override
    public List<ReplicationQueue.Entry> entries(String path) {
        LinkedList<ReplicationQueue.Entry> entries = new LinkedList<ReplicationQueue.Entry>();
        int i = 0;
        for (Event evt : this.jobManager.queryJobs(JobManager.QueryType.ALL, this.queueTopic, new Map[0])) {
            ReplicationJob job = new ReplicationJob(evt);
            if (path.equals(job.getPath())) {
                entries.add(new EntryImpl(job.getEventId(), job, i));
            }
            ++i;
        }
        return entries;
    }

    @Override
    public ReplicationQueue.Entry getEntry(String path, Calendar after) {
        long time = after == null ? 0L : after.getTimeInMillis();
        for (ReplicationQueue.Entry e : this.entries(path)) {
            if (e.getAction().getTime() < time) continue;
            return e;
        }
        return null;
    }

    @Override
    public void clear() {
        Queue q = this.getJobQueue();
        if (q != null) {
            q.removeAll();
        }
    }

    @Override
    public void clear(Set<String> ids) {
        for (String id : ids) {
            this.jobManager.removeJob(id);
        }
    }

    @Override
    public boolean isBlocked() {
        return this.getStatus().getNextRetryTime() > 0L;
    }

    @Override
    public long nextRetryPeriod() {
        ReplicationQueue.Status st = this.getStatus();
        return st.getNextRetryTime() - st.getStatusTime();
    }

    @Override
    public long lastProcessTime() {
        return this.getStatus().getLastProcessTime();
    }

    @Override
    public ReplicationQueue.Status getStatus() {
        Queue q = this.getJobQueue();
        if (q == null) {
            return new StatusImpl(System.currentTimeMillis(), -1L, -1L, -1L);
        }
        return new StatusImpl(System.currentTimeMillis(), this.processingSince, q.getStatistics().getLastFinishedJobTime(), (Long)q.getState("isSleepingUntil"));
    }

    @Override
    public void forceRetry() {
        Queue q = this.getJobQueue();
        if (q != null) {
            q.resume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(ReplicationJob job) throws ReplicationException {
        EntryData data = new EntryData(job.getAction(), job.getContent());
        try {
            this.processingSince = System.currentTimeMillis();
            boolean bl = this.agent.process(data);
            return bl;
        }
        finally {
            this.processingSince = 0L;
        }
    }

    public void addEntry(ReplicationAction action, ReplicationContentFacade content, long retryDelay) {
        ReplicationJob job = new ReplicationJob(this.name, retryDelay, action, content);
        this.eventAdmin.postEvent(job.getEvent());
        this.log.info("Replication request queued for {} at {}.", (Object)this.name, (Object)action.getPath());
    }

    private static class StatusImpl
    implements ReplicationQueue.Status {
        private final long statusTime;
        private final long processingSince;
        private final long lastProcessTime;
        private final long nextRetryTime;

        private StatusImpl(long statusTime, long processingSince, long lastProcessTime, long nextRetryTime) {
            this.statusTime = statusTime;
            this.processingSince = processingSince;
            this.lastProcessTime = lastProcessTime;
            this.nextRetryTime = nextRetryTime;
        }

        public long getStatusTime() {
            return this.statusTime;
        }

        public long getProcessingSince() {
            return this.processingSince;
        }

        public long getLastProcessTime() {
            return this.lastProcessTime;
        }

        public long getNextRetryTime() {
            return this.nextRetryTime;
        }
    }

    private class EntryImpl
    implements ReplicationQueue.Entry {
        private final String id;
        private final ReplicationJob job;
        private EntryData data;
        private final int queuePos;

        private EntryImpl(String id, ReplicationJob job, int queuePos) {
            this.id = id;
            this.job = job;
            this.queuePos = queuePos;
        }

        public String getId() {
            return this.id;
        }

        public ReplicationQueue getQueue() {
            return ReplicationQueueImpl.this;
        }

        public ReplicationAction getAction() {
            try {
                EntryData data = this.getData();
                return data == null ? null : data.getAction();
            }
            catch (RepositoryException e) {
                ReplicationQueueImpl.this.log.error("Error while reading data: {}", (Object)e.toString());
                return null;
            }
        }

        public ReplicationContentFacade getContent() {
            try {
                EntryData data = this.getData();
                return data == null ? null : data.getContent();
            }
            catch (RepositoryException e) {
                ReplicationQueueImpl.this.log.error("Error while reading data: {}", (Object)e.toString());
                return null;
            }
        }

        public int getQueuePosition() {
            return this.queuePos;
        }

        public int getNumProcessed() {
            Integer retryCount = (Integer)this.job.getEvent().getProperty("event.job.retrycount");
            return retryCount == null ? 0 : retryCount;
        }

        public Calendar getLastProcessTime() {
            Date date = (Date)this.job.getEvent().getProperty("modificationDate");
            if (date != null) {
                Calendar c = Calendar.getInstance();
                c.setTime(date);
                return c;
            }
            return null;
        }

        public EntryData getData() throws RepositoryException {
            if (this.data == null) {
                this.data = new EntryData(this.job.getAction(), this.job.getContent());
            }
            return this.data;
        }
    }

    public static final class EntryData
    implements Serializable {
        private static final long serialVersionUID = 6772480983519180596L;
        private final ReplicationAction action;
        private final ReplicationContentFacade content;

        public EntryData(ReplicationAction action, ReplicationContentFacade content) {
            this.action = action;
            this.content = content;
        }

        public ReplicationAction getAction() {
            return this.action;
        }

        public ReplicationContentFacade getContent() {
            return this.content;
        }
    }
}

