/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.replication.impl.servlets;

import com.day.cq.replication.OutboxManager;
import com.day.cq.replication.ReplicationAction;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationException;
import com.day.cq.replication.ReplicationReceiver;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import javax.jcr.Session;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationServlet
extends SlingAllMethodsServlet {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String PN_TIMELINE = "timeline";
    private static final String PN_SINK = "sink";
    protected OutboxManager outboxManager;
    protected ReplicationReceiver receiver;

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/plain");
        response.setCharacterEncoding("utf-8");
        try {
            ReplicationActionType actionType = ReplicationActionType.fromName(request.getHeader("Action"));
            if (actionType == null) {
                throw new ReplicationException("Illegal action: " + request.getHeader("Action"));
            }
            String path = request.getHeader("Path");
            if (path == null || path.length() == 0) {
                throw new ReplicationException("No replication path.");
            }
            long start = System.currentTimeMillis();
            if ("true".equals(request.getParameter(PN_SINK))) {
                this.logger.info("Sinking replication {} of {}", (Object)actionType, (Object)path);
                ServletInputStream in = request.getInputStream();
                IOUtils.copy((InputStream)in, (OutputStream)new NullOutputStream());
                response.getWriter().print("ReplicationAction " + (Object)((Object)actionType) + " ok.");
            } else {
                Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
                ReplicationAction action = new ReplicationAction(actionType, path);
                this.receiver.receive(session, action, (InputStream)request.getInputStream(), request.getContentLength(), response.getWriter());
            }
            long end = System.currentTimeMillis();
            this.logger.info("Processed replication action in {}ms: {} of {}", new Object[]{end - start, actionType, path});
        }
        catch (Exception e) {
            response.setStatus(400);
            this.logger.error("Error during replication: " + e.getMessage(), (Throwable)e);
            response.getWriter().print("error: " + e.toString());
        }
    }

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        ReplicationActionType action = ReplicationActionType.fromName(request.getHeader("Action"));
        if (action == ReplicationActionType.TEST) {
            response.setStatus(200);
            response.setContentType("text/plain");
            response.setCharacterEncoding("utf-8");
            response.getWriter().println("ok");
            response.flushBuffer();
            return;
        }
        Calendar timeline = null;
        String timelineS = request.getParameter(PN_TIMELINE);
        if (timelineS != null) {
            timeline = ISO8601.parse((String)timelineS);
        }
        response.setContentType("application/octet-stream");
        try {
            Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
            this.outboxManager.fetch(session, timeline, (OutputStream)response.getOutputStream());
        }
        catch (ReplicationException e) {
            response.setStatus(400);
            this.logger.error("Error while fetching outbox: " + e.getMessage(), (Throwable)e);
        }
    }

    protected void bindOutboxManager(OutboxManager outboxManager) {
        this.outboxManager = outboxManager;
    }

    protected void unbindOutboxManager(OutboxManager outboxManager) {
        if (this.outboxManager == outboxManager) {
            this.outboxManager = null;
        }
    }

    protected void bindReceiver(ReplicationReceiver replicationReceiver) {
        this.receiver = replicationReceiver;
    }

    protected void unbindReceiver(ReplicationReceiver replicationReceiver) {
        if (this.receiver == replicationReceiver) {
            this.receiver = null;
        }
    }
}

