/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.replication.transport;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasyX509TrustManager
implements X509TrustManager {
    private X509TrustManager standardTrustManager = null;
    private boolean allowExpired;
    private static final Logger log = LoggerFactory.getLogger(EasyX509TrustManager.class);

    public EasyX509TrustManager(KeyStore keystore, boolean allowExpired) throws NoSuchAlgorithmException, KeyStoreException {
        this.allowExpired = allowExpired;
        TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        factory.init(keystore);
        TrustManager[] trustmanagers = factory.getTrustManagers();
        if (trustmanagers.length == 0) {
            throw new NoSuchAlgorithmException("no trust manager found");
        }
        this.standardTrustManager = (X509TrustManager)trustmanagers[0];
    }

    public void checkClientTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
        this.standardTrustManager.checkClientTrusted(certificates, authType);
    }

    public void checkServerTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
        if (certificates != null && log.isDebugEnabled()) {
            log.debug("Server certificate chain:");
            for (int i = 0; i < certificates.length; ++i) {
                log.debug("X509Certificate[{}] = {}", (Object)i, (Object)certificates[i]);
            }
        }
        if (certificates != null && certificates.length == 1) {
            if (!this.allowExpired) {
                certificates[0].checkValidity();
            }
        } else {
            this.standardTrustManager.checkServerTrusted(certificates, authType);
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.standardTrustManager.getAcceptedIssuers();
    }
}

