/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.replication.transport;

import com.day.cq.replication.AgentConfig;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationContent;
import com.day.cq.replication.ReplicationContentFactory;
import com.day.cq.replication.ReplicationException;
import com.day.cq.replication.ReplicationLog;
import com.day.cq.replication.ReplicationResult;
import com.day.cq.replication.ReplicationTransaction;
import com.day.cq.replication.TransportContext;
import com.day.cq.replication.TransportHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticTransportHandler
implements TransportHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String TRANSPORT_SCHEME = "static";
    private static final String PN_DIRECTORY = "directory";
    private static final String MT_ZIP = "application/zip";

    private void activate(ComponentContext context) {
        this.logger.info("Static Transport Handler started.");
    }

    private void deactivate(ComponentContext context) {
        this.logger.info("Static Transport Handler stopped.");
    }

    @Override
    public boolean canHandle(AgentConfig config) {
        if (config != null) {
            String uri = config.getTransportURI();
            String directory = (String)config.getProperties().get(PN_DIRECTORY, String.class);
            return uri.startsWith(TRANSPORT_SCHEME) && directory != null;
        }
        return false;
    }

    @Override
    public ReplicationResult deliver(TransportContext ctx, ReplicationTransaction tx) throws ReplicationException {
        URI transportUri;
        ReplicationLog log = tx.getLog();
        String s = ctx.getConfig().getTransportURI();
        try {
            transportUri = new URI(s);
        }
        catch (URISyntaxException e) {
            String msg = String.format("Syntax error in Transport URI %s: %s", s, e.getMessage());
            log.error(msg);
            return new ReplicationResult(false, 0, msg);
        }
        if (!transportUri.getScheme().equals(TRANSPORT_SCHEME)) {
            String msg = String.format("Unexpected scheme in Transport URI %s: should be %s", s, TRANSPORT_SCHEME);
            log.error(msg);
            return new ReplicationResult(false, 0, msg);
        }
        s = (String)ctx.getConfig().getProperties().get(PN_DIRECTORY, String.class);
        if (s == null) {
            String msg = "Target directory not specified.";
            log.error(msg);
            return new ReplicationResult(false, 0, msg);
        }
        File directory = new File(s);
        if (!directory.isDirectory()) {
            String msg = String.format("Target is not a directory: %s", s);
            log.error(msg);
            return new ReplicationResult(false, 0, msg);
        }
        if (tx.getAction().getType() == ReplicationActionType.DELETE || tx.getAction().getType() == ReplicationActionType.DEACTIVATE) {
            return ReplicationResult.OK;
        }
        ReplicationContent content = tx.getContent();
        String contentType = content.getContentType();
        if (tx.getAction().getType() == ReplicationActionType.TEST) {
            throw new ReplicationException("Test replication not supported by this transport handler.");
        }
        if (tx.getAction().getType() == ReplicationActionType.REVERSE) {
            throw new ReplicationException("Reverse replication not supported by this transport handler.");
        }
        if (content == ReplicationContent.VOID) {
            log.info("Nothing to replicate for " + tx.getAction().getPath());
            return new ReplicationResult(true, 0, "Done");
        }
        if (!contentType.equals(MT_ZIP)) {
            String msg = String.format("Unexpected replication content type: %s", contentType);
            throw new ReplicationException(msg);
        }
        ZipInputStream in = null;
        try {
            try {
                in = new ZipInputStream(content.getInputStream());
                this.extractZip(directory, in, log);
            }
            catch (IOException e) {
                String msg = String.format("Unable to deserialize replication content: %s", e.getMessage());
                throw new ReplicationException(msg, e);
            }
            Object var13_16 = null;
        }
        catch (Throwable throwable) {
            Object var13_17 = null;
            IOUtils.closeQuietly((InputStream)in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        return ReplicationResult.OK;
    }

    private void extractZip(File directory, ZipInputStream in, ReplicationLog log) throws IOException {
        ZipEntry entry;
        while ((entry = in.getNextEntry()) != null) {
            String name = entry.getName();
            if (name.startsWith("/")) {
                name = name.substring(1);
            }
            File target = new File(directory, name);
            log.debug("Extracting entry %s to %s", entry.getName(), target.getPath());
            FileUtils.writeByteArrayToFile((File)target, (byte[])IOUtils.toByteArray((InputStream)in));
        }
    }

    @Override
    public ReplicationResult poll(TransportContext ctx, ReplicationTransaction tx, List<ReplicationContent> result, ReplicationContentFactory factory) throws ReplicationException {
        throw new ReplicationException("Not implemented");
    }
}

