/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.retriever.impl;

import com.day.cq.retriever.impl.AttributeInfo;
import com.day.cq.retriever.impl.AttributeInfoList;
import com.day.cq.rewriter.pipeline.AbstractContentHandler;
import com.day.cq.rewriter.pipeline.AttributesImpl;
import com.day.cq.rewriter.pipeline.Transformer;
import com.day.cq.rewriter.processor.ProcessingComponentConfiguration;
import com.day.cq.rewriter.processor.ProcessingContext;
import java.net.URI;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AbsoluteLinksTransformer
extends AbstractContentHandler
implements Transformer {
    private final URI baseUri;
    private final AttributeInfoList attribInfo = new AttributeInfoList();

    public AbsoluteLinksTransformer(String baseUri) {
        this.baseUri = URI.create(baseUri);
    }

    public void init(ProcessingContext pc, ProcessingComponentConfiguration config) {
    }

    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        for (int i = 0; i < attributes.getLength(); ++i) {
            String aValue;
            String aName = attributes.getLocalName(i);
            String newValue = this.processAttributeValue(localName, aName, aValue = attributes.getValue(i));
            if (newValue == null) continue;
            attributes = AttributesImpl.update((Attributes)attributes, (String)aName, (String)newValue);
        }
        super.startElement(uri, localName, name, attributes);
    }

    String processAttributeValue(String elementName, String attributeName, String value) {
        String result = null;
        AttributeInfo ai = this.attribInfo.get(elementName, attributeName);
        if (ai != null && this.processUri(value)) {
            try {
                result = this.baseUri.resolve(value).toString();
            }
            catch (IllegalArgumentException e) {
                result = this.baseUri.resolve(".").toString() + value;
            }
        }
        return result;
    }

    private boolean processUri(String uri) {
        if (uri == null || uri.length() == 0) {
            return false;
        }
        if (uri.charAt(0) == '#') {
            return false;
        }
        return uri.indexOf(58) <= 0;
    }
}

