/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.retriever.impl;

import com.day.cq.retriever.RetrieverStorage;
import com.day.cq.rewriter.pipeline.Generator;
import com.day.cq.rewriter.processor.ProcessingComponentConfiguration;
import com.day.cq.rewriter.processor.ProcessingContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.sling.commons.html.HtmlParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class HttpClientGenerator
implements Generator {
    private final HtmlParser parser;
    private final HttpClient client;
    private ContentHandler contentHandler;

    public HttpClientGenerator(HtmlParser parser, RetrieverStorage storage) {
        this.parser = parser;
        this.client = new HttpClient();
        this.client.getParams().setAuthenticationPreemptive(true);
        this.client.getState().setCredentials(new AuthScope(null, -1, null), (Credentials)(this.getCredentials(storage) != null ? this.getCredentials(storage) : new UsernamePasswordCredentials("admin", "admin")));
    }

    public void finished() throws IOException, SAXException {
    }

    public void retrieve(String uri) throws IOException {
        GetMethod m = new GetMethod(uri);
        m.setDoAuthentication(true);
        this.client.executeMethod((HttpMethod)m);
        String charset = m.getResponseCharSet();
        if (charset == null) {
            charset = "UTF-8";
        }
        InputStream is = m.getResponseBodyAsStream();
        try {
            this.parser.parse(is, charset, this.contentHandler);
        }
        catch (SAXException se) {
            IOException ioe = new IOException("Unable to parse content.");
            ioe.initCause(se);
            throw ioe;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ignore) {}
        }
    }

    public PrintWriter getWriter() {
        return null;
    }

    public void setContentHandler(ContentHandler c) {
        this.contentHandler = c;
    }

    public void init(ProcessingContext pc, ProcessingComponentConfiguration config) {
    }

    private Credentials getCredentials(RetrieverStorage storage) {
        Credentials credentials = null;
        if (storage != null) {
            try {
                Field credentialsField = storage.getClass().getDeclaredField("credentials");
                credentialsField.setAccessible(true);
                credentials = (Credentials)credentialsField.get(storage);
            }
            catch (IllegalAccessException e) {
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        return credentials;
    }
}

