/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.retriever.impl;

import com.day.cq.retriever.RetrieverService;
import com.day.cq.retriever.RetrieverStorage;
import com.day.cq.retriever.impl.AbsoluteLinksTransformer;
import com.day.cq.retriever.impl.HttpClientGenerator;
import com.day.cq.retriever.impl.SimpleSaxWriter;
import com.day.cq.retriever.impl.StorageTransformer;
import java.io.StringWriter;
import org.apache.sling.commons.html.HtmlParser;
import org.xml.sax.ContentHandler;

public class RetrieverServiceImpl
implements RetrieverService {
    protected HtmlParser parser;

    public void retrieve(String uri, String baseUri, RetrieverStorage storage) throws Exception {
        StringWriter sw = new StringWriter();
        StorageTransformer st = new StorageTransformer(storage);
        st.setContentHandler((ContentHandler)((Object)new SimpleSaxWriter(sw)));
        String base = baseUri != null && baseUri.length() > 0 ? baseUri : uri;
        AbsoluteLinksTransformer alt = new AbsoluteLinksTransformer(base);
        alt.setContentHandler((ContentHandler)((Object)st));
        HttpClientGenerator g = new HttpClientGenerator(this.parser, storage);
        g.setContentHandler((ContentHandler)((Object)alt));
        g.retrieve(uri);
        storage.storeContent(sw.toString());
    }

    String getBaseUri(String uri) {
        int lastSlash = uri.lastIndexOf(47);
        if (lastSlash > 0) {
            uri = uri.substring(0, lastSlash);
        }
        return uri;
    }

    protected void bindParser(HtmlParser htmlParser) {
        this.parser = htmlParser;
    }

    protected void unbindParser(HtmlParser htmlParser) {
        if (this.parser == htmlParser) {
            this.parser = null;
        }
    }
}

