/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.retriever.impl;

import com.day.cq.rewriter.pipeline.Serializer;
import com.day.cq.rewriter.processor.ProcessingComponentConfiguration;
import com.day.cq.rewriter.processor.ProcessingContext;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class SAXWriter
implements Serializer,
LexicalHandler {
    private PrintWriter delegatee;
    private List<String> emptyTags;
    private static final List<String> DEFAULT_EMPTY_TAGS = new ArrayList<String>();

    public void init(ProcessingContext pipelineContext, ProcessingComponentConfiguration config) throws IOException {
        PrintWriter writer = pipelineContext.getWriter();
        if (writer == null) {
            throw new IllegalArgumentException("Writer must not be null");
        }
        this.delegatee = writer;
        this.emptyTags = DEFAULT_EMPTY_TAGS;
    }

    public void endDocument() throws SAXException {
        this.delegatee.flush();
    }

    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        this.delegatee.write(60);
        this.delegatee.write(localName);
        for (int i = 0; i < atts.getLength(); ++i) {
            this.delegatee.write(32);
            this.delegatee.write(atts.getLocalName(i));
            String value = atts.getValue(i);
            if (value == null) continue;
            this.delegatee.write(61);
            int quoteChar = 34;
            this.delegatee.write(34);
            this.delegatee.write(value);
            this.delegatee.write(34);
        }
        this.delegatee.write(">");
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        if (!this.emptyTags.contains(localName)) {
            this.delegatee.write("</");
            this.delegatee.write(localName);
            this.delegatee.write(62);
        }
    }

    public void characters(char[] buffer, int offset, int length) throws SAXException {
        this.delegatee.write(buffer, offset, length);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startDocument() throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        this.delegatee.write("<!-- ");
        this.delegatee.write(ch, start, length);
        this.delegatee.write(" -->");
    }

    public void endCDATA() throws SAXException {
    }

    public void endDTD() throws SAXException {
    }

    public void endEntity(String name) throws SAXException {
    }

    public void startCDATA() throws SAXException {
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    public void startEntity(String name) throws SAXException {
    }

    static {
        DEFAULT_EMPTY_TAGS.add("br");
        DEFAULT_EMPTY_TAGS.add("area");
        DEFAULT_EMPTY_TAGS.add("link");
        DEFAULT_EMPTY_TAGS.add("img");
        DEFAULT_EMPTY_TAGS.add("param");
        DEFAULT_EMPTY_TAGS.add("hr");
        DEFAULT_EMPTY_TAGS.add("input");
        DEFAULT_EMPTY_TAGS.add("col");
        DEFAULT_EMPTY_TAGS.add("base");
        DEFAULT_EMPTY_TAGS.add("meta");
    }
}

