/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.retriever.impl;

import com.day.cq.retriever.RetrieverStorage;
import com.day.cq.retriever.impl.AttributeInfo;
import com.day.cq.retriever.impl.AttributeInfoList;
import com.day.cq.rewriter.pipeline.AbstractContentHandler;
import com.day.cq.rewriter.pipeline.AttributesImpl;
import com.day.cq.rewriter.pipeline.Transformer;
import com.day.cq.rewriter.processor.ProcessingComponentConfiguration;
import com.day.cq.rewriter.processor.ProcessingContext;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class StorageTransformer
extends AbstractContentHandler
implements Transformer {
    private final AttributeInfoList attribInfo = new AttributeInfoList();
    private final RetrieverStorage storage;

    public StorageTransformer(RetrieverStorage storage) {
        this.storage = storage;
    }

    public void init(ProcessingContext pc, ProcessingComponentConfiguration config) {
    }

    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        for (int i = 0; i < attributes.getLength(); ++i) {
            String aValue;
            String aName = attributes.getLocalName(i);
            String newValue = this.processAttributeValue(localName, aName, aValue = attributes.getValue(i), attributes);
            if (newValue == null) continue;
            attributes = AttributesImpl.update((Attributes)attributes, (String)aName, (String)newValue);
        }
        super.startElement(uri, localName, name, attributes);
    }

    protected String processAttributeValue(String elementName, String attributeName, String attributeValue, Attributes attributes) throws SAXException {
        String result = null;
        AttributeInfo ai = this.attribInfo.get(elementName, attributeName);
        if (ai != null && ai.downloadResource) {
            try {
                result = this.storage.maybeDownloadResource(elementName, attributeName, attributeValue, attributes);
            }
            catch (Exception e) {
                throw new SAXException("Exception in storage.maybeDownloadResource: " + e, e);
            }
        }
        return result;
    }
}

