/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.rewriter.htmlparser;

import com.day.cq.rewriter.htmlparser.AttributeList;
import com.day.cq.rewriter.htmlparser.AttributeListImpl;
import java.io.CharArrayWriter;
import java.util.Iterator;

@Deprecated
class TagTokenizer {
    private final CharArrayWriter tagName = new CharArrayWriter(30);
    private final CharArrayWriter attName = new CharArrayWriter(30);
    private final CharArrayWriter attValue = new CharArrayWriter(30);
    private final AttributeListImpl attributes = new AttributeListImpl();
    private static final int START = 0;
    private static final int TAG = 1;
    private static final int NAME = 2;
    private static final int INSIDE = 3;
    private static final int ATTNAME = 4;
    private static final int EQUAL = 5;
    private static final int ATTVALUE = 6;
    private static final int STRING = 7;
    private static final int ENDSLASH = 8;
    private static final int END = 9;
    private char quoteChar = (char)34;
    private boolean endTag;
    private boolean endSlash;
    private boolean hasAttributeValue;

    TagTokenizer() {
    }

    public void tokenize(char[] buf, int off, int len) {
        this.reset();
        int parseState = 0;
        block11: for (int i = 0; i < len; ++i) {
            char c = buf[off + i];
            switch (parseState) {
                case 0: {
                    if (c != '<') continue block11;
                    parseState = 1;
                    continue block11;
                }
                case 1: {
                    if (c == '/') {
                        this.endTag = true;
                        parseState = 2;
                        continue block11;
                    }
                    if (c == '\"' || c == '\'') {
                        this.quoteChar = c;
                        parseState = 7;
                        continue block11;
                    }
                    if (Character.isWhitespace(c)) {
                        parseState = 3;
                        continue block11;
                    }
                    this.tagName.write(c);
                    parseState = 2;
                    continue block11;
                }
                case 2: {
                    if (Character.isWhitespace(c)) {
                        parseState = 3;
                        continue block11;
                    }
                    if (c == '\"' || c == '\'') {
                        this.quoteChar = c;
                        parseState = 7;
                        continue block11;
                    }
                    if (c == '>') {
                        parseState = 9;
                        continue block11;
                    }
                    if (c == '/') {
                        parseState = 8;
                        continue block11;
                    }
                    this.tagName.write(c);
                    continue block11;
                }
                case 3: {
                    if (c == '>') {
                        this.attributeEnded();
                        parseState = 9;
                        continue block11;
                    }
                    if (c == '/') {
                        this.attributeEnded();
                        parseState = 8;
                        continue block11;
                    }
                    if (c == '\"' || c == '\'') {
                        this.attributeValueStarted();
                        this.quoteChar = c;
                        parseState = 7;
                        continue block11;
                    }
                    if (c == '=') {
                        parseState = 5;
                        continue block11;
                    }
                    if (Character.isWhitespace(c)) continue block11;
                    this.attName.write(c);
                    parseState = 4;
                    continue block11;
                }
                case 4: {
                    if (c == '>') {
                        this.attributeEnded();
                        parseState = 9;
                        continue block11;
                    }
                    if (c == '/') {
                        this.attributeEnded();
                        parseState = 8;
                        continue block11;
                    }
                    if (c == '=') {
                        parseState = 5;
                        continue block11;
                    }
                    if (c == '\"' || c == '\'') {
                        this.quoteChar = c;
                        parseState = 7;
                        continue block11;
                    }
                    if (Character.isWhitespace(c)) {
                        parseState = 3;
                        continue block11;
                    }
                    this.attName.write(c);
                    continue block11;
                }
                case 5: {
                    if (c == '>') {
                        this.attributeEnded();
                        parseState = 9;
                        continue block11;
                    }
                    if (c == '\"' || c == '\'') {
                        this.attributeValueStarted();
                        this.quoteChar = c;
                        parseState = 7;
                        continue block11;
                    }
                    if (Character.isWhitespace(c)) continue block11;
                    this.attributeValueStarted();
                    this.attValue.write(c);
                    parseState = 6;
                    continue block11;
                }
                case 6: {
                    if (Character.isWhitespace(c)) {
                        this.attributeEnded();
                        parseState = 3;
                        continue block11;
                    }
                    if (c == '\"' || c == '\'') {
                        this.attributeEnded();
                        this.quoteChar = c;
                        parseState = 7;
                        continue block11;
                    }
                    if (c == '>') {
                        this.attributeEnded();
                        parseState = 9;
                        continue block11;
                    }
                    this.attValue.write(c);
                    continue block11;
                }
                case 7: {
                    if (c == this.quoteChar) {
                        this.attributeEnded();
                        parseState = 3;
                        continue block11;
                    }
                    this.attValue.write(c);
                    continue block11;
                }
                case 8: {
                    if (c == '>') {
                        this.endSlash = true;
                        parseState = 9;
                        continue block11;
                    }
                    if (c == '\"' || c == '\'') {
                        this.quoteChar = c;
                        parseState = 7;
                        continue block11;
                    }
                    if (c != '/' && !Character.isWhitespace(c)) {
                        this.attName.write(c);
                        parseState = 4;
                        continue block11;
                    }
                    parseState = 3;
                    continue block11;
                }
            }
        }
    }

    public boolean endTag() {
        return this.endTag;
    }

    public boolean endSlash() {
        return this.endSlash;
    }

    public String tagName() {
        return this.tagName.toString();
    }

    public AttributeList attributes() {
        return this.attributes;
    }

    private void reset() {
        this.tagName.reset();
        this.attributes.reset();
        this.endTag = false;
        this.endSlash = false;
    }

    private void attributeEnded() {
        if (this.attName.size() > 0) {
            if (this.hasAttributeValue) {
                this.attributes.addAttribute(this.attName.toString().toLowerCase(), this.attValue.toString(), this.quoteChar);
            } else {
                this.attributes.addAttribute(this.attName.toString().toLowerCase(), this.quoteChar);
            }
            this.attName.reset();
            this.attValue.reset();
            this.hasAttributeValue = false;
        }
    }

    private void attributeValueStarted() {
        this.hasAttributeValue = true;
    }

    public String toHtmlString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<" + this.tagName());
        Iterator<String> attNames = this.attributes().attributeNames();
        while (attNames.hasNext()) {
            String attName = attNames.next();
            String attValue = this.attributes().getQuotedValue(attName);
            sb.append(" ");
            sb.append(attName);
            if (attValue == null) continue;
            sb.append('=');
            sb.append(attValue);
        }
        if (this.endSlash) {
            sb.append(" /");
        }
        sb.append(">");
        return sb.toString();
    }
}

