/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.rewriter.linkchecker;

import java.util.Calendar;

public class LinkInfo {
    public static final int X_STATUS_NOT_CHECKED = 0;
    public static final int X_STATUS_UNSUPPORTED = -1;
    public static final int X_STATUS_URI_SYNTAX_ERROR = -2;
    public static final int X_STATUS_CONNECT_ERROR = -3;
    public static final int X_STATUS_NO_ROUTE_TO_HOST = -4;
    public static final int X_STATUS_UNKOWN_HOST = -5;
    public static final int X_STATUS_IO_ERROR = -6;
    public static final int X_STATUS_SSL_ERROR = -7;
    private final String url;
    private Calendar lastChecked;
    private Calendar lastAccessed;
    private Calendar lastAvailable;
    private boolean valid;
    private int lastStatus;

    public LinkInfo(String url) {
        this.url = url;
        this.lastAccessed = Calendar.getInstance();
        this.valid = true;
    }

    public LinkInfo(LinkInfo base) {
        this.url = base.url;
        this.lastChecked = base.lastChecked;
        this.lastAccessed = base.lastAccessed;
        this.lastAvailable = base.lastAvailable;
        this.lastStatus = base.lastStatus;
        this.valid = base.valid;
    }

    public Calendar getLastAccessed() {
        return this.lastAccessed;
    }

    public void setLastAccessed(Calendar lastAccessed) {
        this.lastAccessed = lastAccessed;
    }

    public Calendar getLastChecked() {
        return this.lastChecked;
    }

    public void setLastChecked(Calendar lastChecked) {
        this.lastChecked = lastChecked;
    }

    public Calendar getLastAvailable() {
        return this.lastAvailable;
    }

    public void setLastAvailable(Calendar lastAvailable) {
        this.lastAvailable = lastAvailable;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public int getLastStatus() {
        return this.lastStatus;
    }

    public String getLastStatusAsString() {
        switch (this.lastStatus) {
            case -3: {
                return "No Connection";
            }
            case -6: {
                return "I/O Error";
            }
            case -7: {
                return "SSL Error";
            }
            case -4: {
                return "No Route to Host";
            }
            case 0: {
                return "";
            }
            case -5: {
                return "Unknown Host";
            }
            case -1: {
                return "Unsupported Protocol";
            }
            case -2: {
                return "URI Syntax Error";
            }
        }
        return String.valueOf(this.lastStatus);
    }

    public void setLastStatus(int lastStatus) {
        this.lastStatus = lastStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinkInfo linkInfo = (LinkInfo)o;
        if (this.valid != linkInfo.valid) {
            return false;
        }
        if (this.lastStatus != linkInfo.lastStatus) {
            return false;
        }
        if (this.lastAccessed != null ? !this.lastAccessed.equals(linkInfo.lastAccessed) : linkInfo.lastAccessed != null) {
            return false;
        }
        if (this.lastAvailable != null ? !this.lastAvailable.equals(linkInfo.lastAvailable) : linkInfo.lastAvailable != null) {
            return false;
        }
        if (this.lastChecked != null ? !this.lastChecked.equals(linkInfo.lastChecked) : linkInfo.lastChecked != null) {
            return false;
        }
        return this.url.equals(linkInfo.url);
    }

    public boolean isSame(LinkInfo linkInfo) {
        if (this.valid != linkInfo.valid) {
            return false;
        }
        if (this.lastStatus != linkInfo.lastStatus) {
            return false;
        }
        if (this.lastAvailable != null ? !this.lastAvailable.equals(linkInfo.lastAvailable) : linkInfo.lastAvailable != null) {
            return false;
        }
        if (this.lastChecked != null ? !this.lastChecked.equals(linkInfo.lastChecked) : linkInfo.lastChecked != null) {
            return false;
        }
        return this.url.equals(linkInfo.url);
    }

    public int hashCode() {
        int result = this.url.hashCode();
        result = 31 * result + (this.lastChecked != null ? this.lastChecked.hashCode() : 0);
        result = 31 * result + (this.lastAccessed != null ? this.lastAccessed.hashCode() : 0);
        result = 31 * result + (this.lastAvailable != null ? this.lastAvailable.hashCode() : 0);
        result = 31 * result + (this.valid ? 1 : 0);
        result = 31 * result + this.lastStatus;
        return result;
    }
}

