/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.rewriter.linkchecker.impl;

import com.day.cq.rewriter.linkchecker.LinkCheckerExtension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

public class ExtensionList {
    private final ComponentContext componentContext;
    private final Map<Object, LinkCheckerExtension> extensionMap = new HashMap<Object, LinkCheckerExtension>();
    private final List<LinkCheckerExtension> extensions = new ArrayList<LinkCheckerExtension>();
    private LinkCheckerExtension[] cachedExtensions = new LinkCheckerExtension[0];

    public ExtensionList(ComponentContext context) {
        this.componentContext = context;
    }

    public void addExtension(ServiceReference ref) {
        Object serviceId = ref.getProperty("service.id");
        LinkCheckerExtension extension = (LinkCheckerExtension)this.componentContext.locateService("extension", ref);
        if (extension != null) {
            this.extensionMap.put(serviceId, extension);
            this.extensions.add(extension);
            this.cachedExtensions = this.extensions.toArray(new LinkCheckerExtension[this.extensions.size()]);
        }
    }

    public void removeExtension(ServiceReference ref) {
        Object serviceId = ref.getProperty("service.id");
        LinkCheckerExtension extension = this.extensionMap.remove(serviceId);
        if (extension != null) {
            this.extensions.remove(extension);
            this.cachedExtensions = this.extensions.toArray(new LinkCheckerExtension[this.extensions.size()]);
        }
    }

    public LinkCheckerExtension[] getExtensions() {
        return this.cachedExtensions;
    }
}

