/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.rewriter.linkchecker.impl;

import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.rewriter.linkchecker.LinkInfo;
import com.day.cq.rewriter.linkchecker.LinkInfoStorage;
import com.day.text.Text;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkInfoStorageImpl
implements LinkInfoStorage,
Runnable,
EventListener {
    private static final long LAST_ACCESS_ACCURANCY = 600000L;
    private static final Logger logger = LoggerFactory.getLogger(LinkInfoStorageImpl.class);
    private static final String PN_MAX_LINKS = "maxLinks";
    private static final String PN_LAST_ACCESSED = "lastAccessed";
    private static final String PN_LAST_CHECKED = "lastChecked";
    private static final String PN_LAST_AVAILABLE = "lastAvailable";
    private static final String PN_LAST_STATUS = "lastStatus";
    private static final String PN_VALID = "valid";
    private static final String LINKCHECKER_RESOURCETYPE = "cq/linkchecker/components/linkchecker";
    private static final String REPOSITORY_PATH = "service.repository_path";
    protected String storageRootPath;
    protected Session readSession;
    protected Session writeSession;
    private final Map<String, Entry> infos = new HashMap<String, Entry>();
    private final Map<String, HostInfo> hostInfos = new HashMap<String, HostInfo>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock writeBackLock = new ReentrantLock();
    private SlingRepository repository;

    protected void activate(ComponentContext context) throws RepositoryException {
        Dictionary props = context.getProperties();
        this.infos.clear();
        this.readSession = this.repository.loginAdministrative(this.repository.getDefaultWorkspace());
        this.writeSession = this.repository.loginAdministrative(this.repository.getDefaultWorkspace());
        this.storageRootPath = (String)props.get(REPOSITORY_PATH);
        this.init();
        this.upgradeStorage();
        this.fillCache();
        this.writeSession.getWorkspace().getObservationManager().addEventListener((EventListener)this, 19, this.storageRootPath, true, null, null, true);
        logger.debug("LinkInfoStorage service activated");
    }

    private void upgradeStorage() {
        try {
            Node root = this.getStorageRoot(this.writeSession);
            if (root != null) {
                NodeIterator iter = root.getNodes();
                while (iter.hasNext()) {
                    Node node = (Node)iter.next();
                    if (!node.hasProperty("url")) continue;
                    String url = node.getProperty("url").getString();
                    logger.debug("Converting legacy link info for {}", (Object)url);
                    LinkInfo info = LinkInfoStorageImpl.createInfo(node, url);
                    Entry e = new Entry(info);
                    if (e.hostname != null) {
                        HostInfo hInfo = this.hostInfos.get(e.hostname);
                        if (hInfo == null) {
                            hInfo = new HostInfo();
                            this.hostInfos.put(e.hostname, hInfo);
                        }
                        if (hInfo.maxLinks == hInfo.numLinks) {
                            logger.warn("No more external links allowed for host {}. Maximum of {} reached. rejecting", (Object)e.hostname, (Object)hInfo.maxLinks);
                        } else {
                            hInfo.numLinks++;
                            e.modified = true;
                            this.infos.put(e.relPath, e);
                        }
                    }
                    node.remove();
                }
                if (!this.infos.isEmpty()) {
                    logger.debug("Saving {} removed nodes....", (Object)this.infos.size());
                    root.getSession().save();
                    logger.debug("Saving converted link infos.");
                    this.sync();
                    logger.debug("Upgrade done.");
                }
            }
        }
        catch (RepositoryException e) {
            logger.error("Error during upgrade link checker information: " + e.getMessage(), (Throwable)e);
        }
    }

    protected void init() throws RepositoryException {
        Node storageRoot = JcrUtil.createPath((String)this.storageRootPath, (String)"sling:Folder", (String)"sling:Folder", (Session)this.writeSession, (boolean)false);
        if (!storageRoot.hasProperty("sling:resourceType") || LINKCHECKER_RESOURCETYPE.equals(storageRoot.getProperty("sling:resourceType"))) {
            storageRoot.setProperty("sling:resourceType", LINKCHECKER_RESOURCETYPE);
        }
        if (this.writeSession.hasPendingChanges()) {
            this.writeSession.save();
        }
    }

    protected void deactivate(ComponentContext componentContext) {
        this.writeBackLock.lock();
        if (this.writeSession != null) {
            try {
                this.writeSession.getWorkspace().getObservationManager().removeEventListener((EventListener)this);
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
            this.writeSession.logout();
            this.writeSession = null;
        }
        this.writeBackLock.unlock();
        this.lock.writeLock().lock();
        if (this.readSession != null) {
            this.readSession.logout();
            this.readSession = null;
        }
        this.infos.clear();
        this.lock.writeLock().unlock();
        logger.debug("LinkInfoStorage service shut down");
    }

    @Override
    public String[] getLinks() {
        ArrayList<String> links = new ArrayList<String>();
        this.lock.readLock().lock();
        for (Entry e : this.infos.values()) {
            if (e.info == null) continue;
            links.add(e.info.getUrl());
        }
        this.lock.readLock().unlock();
        Collections.sort(links);
        return links.toArray(new String[links.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinkInfo getLinkInfo(String url) {
        this.lock.readLock().lock();
        try {
            Entry e = this.infos.get(url);
            LinkInfo linkInfo = e == null || e.info == null ? null : new LinkInfo(e.info);
            return linkInfo;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putLinkInfo(LinkInfo info) {
        info = new LinkInfo(info);
        String key = info.getUrl();
        this.lock.writeLock().lock();
        try {
            Entry e = this.infos.get(key);
            if (e == null || e.info == null) {
                e = new Entry(info);
                if (e.hostname == null) {
                    return;
                }
                HostInfo hostInfo = this.hostInfos.get(e.hostname);
                if (hostInfo == null) {
                    hostInfo = new HostInfo();
                    this.hostInfos.put(e.hostname, hostInfo);
                }
                if (hostInfo.numLinks == hostInfo.maxLinks) {
                    logger.warn("No more external links allowed for host {}. Maximum of {} reached.", (Object)e.hostname, (Object)hostInfo.maxLinks);
                    return;
                }
                hostInfo.numLinks++;
                e.modified = true;
                this.infos.put(key, e);
            } else if (!e.info.isSame(info)) {
                e.info = info;
                e.modified = true;
            } else {
                long t2;
                long t1 = e.info.getLastAccessed() == null ? 0L : e.info.getLastAccessed().getTimeInMillis();
                long l = t2 = info.getLastAccessed() == null ? 0L : info.getLastAccessed().getTimeInMillis();
                if (t2 - t1 > 600000L) {
                    e.info = info;
                    e.modified = true;
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void deleteLinkInfo(LinkInfo info) {
        if (info == null) {
            throw new IllegalArgumentException("LinkInfo must not be null.");
        }
        this.deleteLinkInfo(info.getUrl());
    }

    @Override
    public void deleteLinkInfo(String url) {
        this.lock.writeLock().lock();
        Entry e = this.infos.get(url);
        if (e != null) {
            e.info = null;
            HostInfo hInfo = this.hostInfos.get(e.hostname);
            if (hInfo != null) {
                hInfo.numLinks--;
            }
        }
        this.lock.writeLock().unlock();
    }

    @Override
    public void sync() {
        this.writeBackLock.lock();
        this.writeBack();
        this.writeBackLock.unlock();
    }

    @Override
    public void run() {
        try {
            if (this.writeBackLock.tryLock()) {
                this.writeBack();
                this.writeBackLock.unlock();
            }
        }
        catch (Throwable t) {
            logger.error("Unhandled Throwable in " + this.getClass().getSimpleName(), t);
        }
    }

    private void writeBack() {
        if (this.writeSession == null) {
            return;
        }
        HashSet<String> toDelete = new HashSet<String>();
        HashMap<String, LinkInfo> toUpdate = new HashMap<String, LinkInfo>();
        this.lock.writeLock().lock();
        Iterator<Map.Entry<String, Entry>> iter = this.infos.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, Entry> e = iter.next();
            Entry entry = e.getValue();
            if (entry.info == null) {
                toDelete.add(entry.relPath);
                iter.remove();
                continue;
            }
            if (!entry.modified) continue;
            toUpdate.put(entry.relPath, entry.info);
            entry.modified = false;
        }
        this.lock.writeLock().unlock();
        if (toDelete.isEmpty() && toUpdate.isEmpty()) {
            logger.debug("no link infos modified or deleted.");
            return;
        }
        Node root = this.getStorageRoot(this.writeSession);
        if (root == null) {
            try {
                this.init();
                root = this.getStorageRoot(this.writeSession);
            }
            catch (RepositoryException e) {
                logger.error("error during re-initialization of storage root.", (Throwable)e);
            }
            if (root == null) {
                return;
            }
        }
        int retries = 3;
        while (retries-- > 0) {
            try {
                for (String string : toDelete) {
                    if (!root.hasNode(string)) continue;
                    logger.debug("deleting {}", (Object)string);
                    root.getNode(string).remove();
                }
                for (Map.Entry entry : toUpdate.entrySet()) {
                    String[] segments;
                    Node node = root;
                    for (String name : segments = Text.explode((String)((String)entry.getKey()), (int)47)) {
                        node = node.hasNode(name) ? node.getNode(name) : node.addNode(name);
                    }
                    logger.debug("updating {}", entry.getKey());
                    this.writeInfo((LinkInfo)entry.getValue(), node);
                }
                this.writeSession.save();
                logger.debug("Updated {} and deleted {} link infos.", (Object)toUpdate.size(), (Object)toDelete.size());
                return;
            }
            catch (RepositoryException e) {
                logger.error("Error during writeback of link infos.", (Throwable)e);
                try {
                    this.writeSession.refresh(false);
                }
                catch (RepositoryException e2) {
                    logger.error("Error during refresh. aborting.", (Throwable)e2);
                    return;
                }
                if (retries <= 0) continue;
                logger.error("Retring writeback in 100ms...");
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e1) {}
            }
        }
        logger.error("Unrecoverable error during write back. try restarting the service.");
    }

    public void onEvent(EventIterator eventIterator) {
        logger.debug("Modification below {} detected. reloading cache.", (Object)this.storageRootPath);
        this.fillCache();
    }

    private Node getStorageRoot(Session session) {
        try {
            if (!session.itemExists(this.storageRootPath)) {
                return null;
            }
            return (Node)session.getItem(this.storageRootPath);
        }
        catch (Exception e) {
            logger.error("error while retrieving linkchecker storage root. try restarting the service.", (Throwable)e);
            return null;
        }
    }

    private void fillCache() {
        try {
            HashMap<String, Entry> links = new HashMap<String, Entry>();
            HashMap<String, HostInfo> hInfos = new HashMap<String, HostInfo>();
            Node root = this.getStorageRoot(this.readSession);
            if (root != null) {
                NodeIterator iter = root.getNodes();
                while (iter.hasNext()) {
                    Node node = (Node)iter.next();
                    LinkInfoStorageImpl.loadProtocols(links, hInfos, node.getName() + ":/", node);
                }
            }
            this.lock.writeLock().lock();
            this.infos.clear();
            this.infos.putAll(links);
            this.hostInfos.clear();
            this.hostInfos.putAll(hInfos);
            this.lock.writeLock().unlock();
        }
        catch (RepositoryException e) {
            logger.error("Error while retrieving the link infos.", (Throwable)e);
        }
    }

    private static void loadProtocols(Map<String, Entry> links, Map<String, HostInfo> hostInfos, String parentUrl, Node parent) throws RepositoryException {
        NodeIterator iter = parent.getNodes();
        while (iter.hasNext()) {
            Node node = (Node)iter.next();
            String host = JcrUtil.unescapeIllegalJcrChars((String)node.getName());
            HostInfo hostInfo = new HostInfo();
            hostInfos.put(host, hostInfo);
            if (node.hasProperty(PN_MAX_LINKS)) {
                hostInfo.maxLinks = (int)node.getProperty(PN_MAX_LINKS).getLong();
            }
            logger.debug("Created HostInfo for {}. Max links is {}", (Object)host, (Object)hostInfo.maxLinks);
            String url = parentUrl + "/" + host;
            String relPath = parent.getName() + "/" + node.getName();
            LinkInfoStorageImpl.loadInfos(links, url, node, relPath, hostInfo);
        }
    }

    private static void loadInfos(Map<String, Entry> links, String parentUrl, Node parent, String parentPath, HostInfo hostInfo) throws RepositoryException {
        if (parent.hasProperty(PN_LAST_ACCESSED)) {
            LinkInfo info = LinkInfoStorageImpl.createInfo(parent, parentUrl);
            Entry e = new Entry(parentPath, info);
            links.put(parentUrl, e);
            hostInfo.numLinks++;
        }
        NodeIterator iter = parent.getNodes();
        while (iter.hasNext()) {
            Node node = (Node)iter.next();
            String urlSegment = JcrUtil.unescapeIllegalJcrChars((String)node.getName());
            if (urlSegment.equals("/")) {
                urlSegment = "";
            }
            String url = parentUrl + "/" + urlSegment;
            String relPath = parentPath + "/" + node.getName();
            LinkInfoStorageImpl.loadInfos(links, url, node, relPath, hostInfo);
        }
    }

    private void writeInfo(LinkInfo info, Node node) throws RepositoryException {
        node.setProperty(PN_LAST_ACCESSED, info.getLastAccessed());
        node.setProperty(PN_LAST_CHECKED, info.getLastChecked());
        node.setProperty(PN_LAST_AVAILABLE, info.getLastAvailable());
        node.setProperty(PN_LAST_STATUS, (long)info.getLastStatus());
        node.setProperty(PN_VALID, info.isValid());
    }

    private static LinkInfo createInfo(Node node, String url) throws RepositoryException {
        LinkInfo info = new LinkInfo(url);
        if (node.hasProperty(PN_LAST_ACCESSED)) {
            info.setLastAccessed(node.getProperty(PN_LAST_ACCESSED).getDate());
        }
        if (node.hasProperty(PN_LAST_CHECKED)) {
            info.setLastChecked(node.getProperty(PN_LAST_CHECKED).getDate());
        }
        if (node.hasProperty(PN_LAST_AVAILABLE)) {
            info.setLastAvailable(node.getProperty(PN_LAST_AVAILABLE).getDate());
        }
        if (node.hasProperty(PN_VALID)) {
            info.setValid(node.getProperty(PN_VALID).getBoolean());
        }
        if (node.hasProperty(PN_LAST_STATUS)) {
            info.setLastStatus((int)node.getProperty(PN_LAST_STATUS).getLong());
        }
        return info;
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    private static class HostInfo {
        private int numLinks;
        private int maxLinks = 128;

        private HostInfo() {
        }
    }

    private static class Entry {
        private String hostname;
        private String relPath;
        private LinkInfo info;
        private boolean modified;

        private Entry(LinkInfo info) {
            String[] segments;
            this.info = info;
            StringBuffer path = new StringBuffer();
            String url = info.getUrl();
            int idx = url.indexOf("://");
            if (idx < 0) {
                segments = Text.explode((String)url, (int)47);
            } else {
                segments = Text.explode((String)url.substring(idx + 3), (int)47);
                if (segments.length > 0) {
                    this.hostname = segments[0];
                }
                path.append(url.substring(0, idx));
            }
            for (String s : segments) {
                path.append('/').append(JcrUtil.escapeIllegalJcrChars((String)s));
            }
            if (url.endsWith("/")) {
                path.append("/").append(JcrUtil.escapeIllegalJcrChars((String)"/"));
            }
            this.relPath = path.toString();
        }

        private Entry(String relPath, LinkInfo info) {
            this.relPath = relPath;
            this.info = info;
        }
    }
}

