/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.rewriter.processor.impl;

import com.day.cq.rewriter.pipeline.Generator;
import com.day.cq.rewriter.pipeline.RewriterTransformerFactory;
import com.day.cq.rewriter.pipeline.Serializer;
import com.day.cq.rewriter.pipeline.Transformer;
import com.day.cq.rewriter.processor.Processor;
import com.day.cq.rewriter.processor.impl.GeneratorFactoryWrapper;
import com.day.cq.rewriter.processor.impl.ProcessorFactoryWrapper;
import com.day.cq.rewriter.processor.impl.RewriterTransformerFactoryWrapper;
import com.day.cq.rewriter.processor.impl.SerializerFactoryWrapper;
import com.day.cq.rewriter.processor.impl.TransformerFactoryWrapper;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sling.rewriter.GeneratorFactory;
import org.apache.sling.rewriter.ProcessorFactory;
import org.apache.sling.rewriter.SerializerFactory;
import org.apache.sling.rewriter.TransformerFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.ComponentFactory;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedFactoryCache {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ExtendedFactoryCache.class.getName());
    private HashingServiceTrackerCustomizer oldGeneratorTracker;
    private HashingServiceTrackerCustomizer oldSerializerTracker;
    private HashingServiceTrackerCustomizer oldTransformerTracker;
    private RewriterTransformerFactoryServiceTracker oldRewritingTransformerTracker;
    private HashingServiceTrackerCustomizer oldProcessorTracker;

    protected void activate(ComponentContext ctx) throws InvalidSyntaxException {
        BundleContext context = ctx.getBundleContext();
        this.oldGeneratorTracker = new HashingServiceTrackerCustomizer(context, ComponentType.GENERATOR, context.createFilter("(component.factory=" + Generator.class.getName() + "/*)"));
        this.oldSerializerTracker = new HashingServiceTrackerCustomizer(context, ComponentType.SERIALIZER, context.createFilter("(component.factory=" + Serializer.class.getName() + "/*)"));
        this.oldTransformerTracker = new HashingServiceTrackerCustomizer(context, ComponentType.TRANSFORMER, context.createFilter("(component.factory=" + Transformer.class.getName() + "/*)"));
        this.oldProcessorTracker = new HashingServiceTrackerCustomizer(context, ComponentType.PROCESSOR, context.createFilter("(component.factory=" + Processor.class.getName() + "/*)"));
        this.oldRewritingTransformerTracker = new RewriterTransformerFactoryServiceTracker(context);
        this.oldGeneratorTracker.open();
        this.oldSerializerTracker.open();
        this.oldTransformerTracker.open();
        this.oldRewritingTransformerTracker.open();
        this.oldProcessorTracker.open();
    }

    protected void deactivate(ComponentContext ctx) {
        this.oldGeneratorTracker.close();
        this.oldSerializerTracker.close();
        this.oldTransformerTracker.close();
        this.oldRewritingTransformerTracker.close();
        this.oldProcessorTracker.close();
        this.oldGeneratorTracker = null;
        this.oldProcessorTracker = null;
        this.oldRewritingTransformerTracker = null;
        this.oldTransformerTracker = null;
        this.oldSerializerTracker = null;
    }

    private static final class RewriterTransformerFactoryServiceTracker
    extends ServiceTracker {
        private final Map<ServiceReference, ServiceRegistration> services = new ConcurrentHashMap<ServiceReference, ServiceRegistration>();
        private final BundleContext context;

        public RewriterTransformerFactoryServiceTracker(BundleContext bc) {
            super(bc, RewriterTransformerFactory.class.getName(), null);
            this.context = bc;
        }

        public Object addingService(ServiceReference reference) {
            RewriterTransformerFactory rtf = (RewriterTransformerFactory)this.context.getService(reference);
            if (rtf != null) {
                String[] keys;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Found rewriter transformer factory {}.", (Object)rtf);
                }
                Hashtable<String, Object> props = new Hashtable<String, Object>();
                for (String key : keys = reference.getPropertyKeys()) {
                    if (key.equals("service.id") || key.equals("objectClass") || key.equals("component.factory") || key.equals("component.name")) continue;
                    ((Dictionary)props).put(key, reference.getProperty(key));
                }
                ((Dictionary)props).put("pipeline.mode", "global");
                ServiceRegistration reg = this.context.registerService(TransformerFactory.class.getName(), (Object)new RewriterTransformerFactoryWrapper(rtf), props);
                this.services.put(reference, reg);
            }
            return rtf;
        }

        public void removedService(ServiceReference reference, Object service) {
            ServiceRegistration reg = this.services.remove(reference);
            if (reg != null) {
                reg.unregister();
            }
            this.context.ungetService(reference);
        }
    }

    private static final class HashingServiceTrackerCustomizer
    extends ServiceTracker {
        private final Map<String, ServiceRegistration> services = new ConcurrentHashMap<String, ServiceRegistration>();
        private final BundleContext context;
        private final ComponentType componentType;

        public HashingServiceTrackerCustomizer(BundleContext bc, ComponentType componentType, Filter filter) {
            super(bc, filter, null);
            this.componentType = componentType;
            this.context = bc;
        }

        private String getType(ServiceReference ref) {
            String factory = (String)ref.getProperty("component.factory");
            int pos = factory.lastIndexOf(47);
            if (pos != -1) {
                String type = factory.substring(pos + 1);
                return type;
            }
            return null;
        }

        public Object addingService(ServiceReference reference) {
            ComponentFactory factory;
            String type = this.getType(reference);
            ComponentFactory componentFactory = factory = type == null ? null : (ComponentFactory)this.context.getService(reference);
            if (factory != null) {
                String[] keys;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Found service {}, type={}.", (Object)factory, (Object)type);
                }
                Hashtable<String, Object> props = new Hashtable<String, Object>();
                for (String key : keys = reference.getPropertyKeys()) {
                    if (key.equals("service.id") || key.equals("objectClass") || key.equals("component.factory") || key.equals("component.name")) continue;
                    ((Dictionary)props).put(key, reference.getProperty(key));
                }
                ((Dictionary)props).put("pipeline.type", type);
                ServiceRegistration reg = null;
                switch (this.componentType) {
                    case GENERATOR: {
                        reg = this.context.registerService(GeneratorFactory.class.getName(), (Object)new GeneratorFactoryWrapper(type, factory), props);
                        break;
                    }
                    case TRANSFORMER: {
                        reg = this.context.registerService(TransformerFactory.class.getName(), (Object)new TransformerFactoryWrapper(type, factory), props);
                        break;
                    }
                    case SERIALIZER: {
                        reg = this.context.registerService(SerializerFactory.class.getName(), (Object)new SerializerFactoryWrapper(type, factory), props);
                        break;
                    }
                    case PROCESSOR: {
                        reg = this.context.registerService(ProcessorFactory.class.getName(), (Object)new ProcessorFactoryWrapper(type, factory), props);
                    }
                }
                if (reg != null) {
                    this.services.put(type, reg);
                }
            }
            return factory;
        }

        public void removedService(ServiceReference reference, Object service) {
            String type = this.getType(reference);
            if (type != null) {
                ServiceRegistration reg = this.services.remove(type);
                reg.unregister();
            }
            this.context.ungetService(reference);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ComponentType {
        GENERATOR,
        TRANSFORMER,
        SERIALIZER,
        PROCESSOR;

    }
}

