/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.rewriter.xml;

import com.day.cq.rewriter.pipeline.Transformer;
import com.day.cq.rewriter.processor.ProcessingComponentConfiguration;
import com.day.cq.rewriter.processor.ProcessingContext;
import com.day.cq.rewriter.xml.SourceResolverImpl;
import com.day.cq.rewriter.xml.XSLTProcessorException;
import com.day.cq.rewriter.xml.XSLTProcessorImpl;
import java.io.IOException;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.cocoon.xml.sax.AbstractSAXPipe;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.sling.api.resource.Resource;
import org.osgi.service.component.ComponentContext;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class XSLTTransformer
extends AbstractSAXPipe
implements Transformer {
    protected TransformerHandler transformerHandler;
    private Source inputSource;
    private SourceResolver resolver;
    private XSLTProcessorImpl xsltProcessor;
    private SAXException exceptionDuringSetConsumer;
    private Resource resource;

    public void init(ProcessingContext context, ProcessingComponentConfiguration config) throws IOException {
        String src = (String)config.getConfiguration().get("source");
        if (src == null) {
            throw new RuntimeException("Source is missing.");
        }
        this.resolver = new SourceResolverImpl(context.getRequest().getResourceResolver(), context.getRequest(), context.getResponse());
        this.inputSource = this.resolver.resolveURI(src);
        this.xsltProcessor = new XSLTProcessorImpl(this.resolver);
        this.resource = context.getRequest().getResource();
    }

    public void setContentHandler(ContentHandler ch) {
        try {
            this.transformerHandler = this.xsltProcessor.getTransformerHandler(this.inputSource);
        }
        catch (XSLTProcessorException se) {
            this.exceptionDuringSetConsumer = new SAXException("Unable to get transformer handler for " + this.inputSource.getURI(), se);
            return;
        }
        super.setContentHandler((ContentHandler)this.transformerHandler);
        SAXResult result = new SAXResult(ch);
        if (ch instanceof LexicalHandler) {
            result.setLexicalHandler((LexicalHandler)((Object)ch));
        }
        this.transformerHandler.setResult(result);
        this.transformerHandler.getTransformer().setParameter("resource", this.resource.getPath());
    }

    protected void deactivate(ComponentContext context) {
        if (this.inputSource != null) {
            this.resolver.release(this.inputSource);
            this.inputSource = null;
        }
        this.resolver = null;
        this.transformerHandler = null;
        this.exceptionDuringSetConsumer = null;
    }

    public void startDocument() throws SAXException {
        if (this.exceptionDuringSetConsumer != null) {
            throw this.exceptionDuringSetConsumer;
        }
        super.startDocument();
    }
}

