/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.source.factories;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.SourceUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.AbstractSource;
import org.apache.excalibur.source.validity.TimeStampValidity;

public class ResourceSource
extends AbstractSource
implements Source {
    private URL m_location;
    private String m_mimeType;

    public ResourceSource(String systemId) throws MalformedURLException {
        int pos = SourceUtil.indexOfSchemeColon(systemId);
        if (pos == -1 || !systemId.startsWith("://", pos)) {
            throw new MalformedURLException("Invalid format for ResourceSource : " + systemId);
        }
        this.setSystemId(systemId);
        this.m_location = this.getClassLoader().getResource(systemId.substring(pos + 3));
        this.setScheme(systemId.substring(0, pos));
    }

    public boolean exists() {
        return this.m_location != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getInfos() {
        super.getInfos();
        this.m_mimeType = null;
        if (this.m_location == null) {
            return;
        }
        URLConnection connection = null;
        try {
            try {
                connection = this.m_location.openConnection();
            }
            catch (IOException ioe) {
                if (connection != null) {
                    try {
                        connection.getInputStream().close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return;
            }
            this.setLastModified(connection.getLastModified());
            this.setContentLength(connection.getContentLength());
            this.m_mimeType = connection.getContentType();
        }
        finally {
            if (connection != null) {
                try {
                    connection.getInputStream().close();
                }
                catch (IOException e) {}
            }
        }
    }

    public String getMimeType() {
        return this.m_mimeType;
    }

    public InputStream getInputStream() throws IOException, SourceException {
        if (!this.exists()) {
            throw new SourceNotFoundException(this.getURI());
        }
        return this.m_location.openStream();
    }

    public SourceValidity getValidity() {
        return new TimeStampValidity(this.getLastModified());
    }

    protected ClassLoader getClassLoader() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        return loader;
    }
}

