/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.source.validity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.excalibur.source.SourceValidity;

public final class AggregatedValidity
implements SourceValidity {
    final ArrayList m_list = new ArrayList();

    public void add(SourceValidity validity) {
        this.m_list.add(validity);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("SourceValidity ");
        Iterator i = this.m_list.iterator();
        while (i.hasNext()) {
            sb.append(i.next());
            if (!i.hasNext()) continue;
            sb.append(':');
        }
        return sb.toString();
    }

    public List getValidities() {
        return Collections.unmodifiableList(this.m_list);
    }

    SourceValidity getValidity(int index) {
        return (SourceValidity)this.m_list.get(index);
    }

    public int isValid() {
        Iterator i = this.m_list.iterator();
        while (i.hasNext()) {
            int v = ((SourceValidity)i.next()).isValid();
            if (v >= 1) continue;
            return v;
        }
        return 1;
    }

    public int isValid(SourceValidity validity) {
        if (validity instanceof AggregatedValidity) {
            AggregatedValidity other = (AggregatedValidity)validity;
            ArrayList otherList = other.m_list;
            if (this.m_list.size() != otherList.size()) {
                return -1;
            }
            Iterator i = this.m_list.iterator();
            Iterator j = otherList.iterator();
            while (i.hasNext()) {
                SourceValidity srcA = (SourceValidity)i.next();
                SourceValidity srcB = (SourceValidity)j.next();
                int result = srcA.isValid();
                if (result == -1) {
                    return -1;
                }
                if (result != 0 || (result = srcA.isValid(srcB)) >= 1) continue;
                return result;
            }
            return 1;
        }
        return -1;
    }
}

