/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.rewriter.linkchecker;

import com.day.cq.rewriter.linkchecker.LinkRewriteConfig;
import java.net.URI;
import java.net.URISyntaxException;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkCheckerSettings {
    private static final Logger log = LoggerFactory.getLogger(LinkCheckerSettings.class);
    public static final String REQUEST_ATTRIBUTE_NAME = LinkCheckerSettings.class.getName();
    private SlingHttpServletRequest request;
    private LinkRewriteConfig invalidConfig;
    private LinkRewriteConfig expiredConfig;
    private LinkRewriteConfig predatedConfig;
    private String baseRef;
    private boolean ignoreInternals;
    private boolean ignoreExternals;
    private URI contextUri;
    private URI baseUri;

    public static LinkCheckerSettings fromRequest(SlingHttpServletRequest request) {
        LinkCheckerSettings settings = (LinkCheckerSettings)request.getAttribute(REQUEST_ATTRIBUTE_NAME);
        if (settings == null) {
            settings = new LinkCheckerSettings();
            request.setAttribute(REQUEST_ATTRIBUTE_NAME, (Object)settings);
        }
        return settings;
    }

    public void init(SlingHttpServletRequest request) {
        this.request = request;
    }

    public SlingHttpServletRequest getRequest() {
        return this.request;
    }

    public ResourceResolver getResourceResolver() {
        return this.request.getResourceResolver();
    }

    public String getContextPath() {
        return this.request.getContextPath();
    }

    public URI getContextURI() {
        if (this.contextUri == null) {
            try {
                String context = this.request.getContextPath() + "/";
                URI uri = new URI(this.request.getRequestURL().toString());
                this.contextUri = new URI(uri.getScheme(), uri.getRawUserInfo(), uri.getHost(), uri.getPort(), context, null, null);
            }
            catch (URISyntaxException e) {
                log.warn("Ignoring malformed context URI: {}", (Object)e.toString());
            }
        }
        return this.contextUri;
    }

    public LinkRewriteConfig getInvalidConfig() {
        return this.invalidConfig;
    }

    public void setInvalidConfig(LinkRewriteConfig config) {
        this.invalidConfig = config;
    }

    public LinkRewriteConfig getExpiredConfig() {
        return this.expiredConfig;
    }

    public void setExpiredConfig(LinkRewriteConfig config) {
        this.expiredConfig = config;
    }

    public LinkRewriteConfig getPredatedConfig() {
        return this.predatedConfig;
    }

    public void setPredatedConfig(LinkRewriteConfig config) {
        this.predatedConfig = config;
    }

    public String getRequestURI() {
        return this.request.getRequestURI();
    }

    public String getParentRequestURI() {
        String prefix;
        int pos;
        Node n;
        Resource parent;
        String requestURI = this.getRequestURI();
        if (requestURI == null) {
            return "";
        }
        String parentRequestURI = requestURI;
        boolean doFallback = true;
        if (this.request.getResource().adaptTo(Item.class) != null && (parent = ResourceUtil.getParent((Resource)this.request.getResource())) != null && (n = (Node)parent.adaptTo(Node.class)) != null) {
            int index = 1;
            try {
                while (!n.isNodeType("nt:hierarchyNode")) {
                    n = n.getParent();
                    ++index;
                }
                ++index;
                int pos2 = requestURI.length();
                for (int i = 0; i < index; ++i) {
                    pos2 = requestURI.lastIndexOf(47, pos2 - 1);
                }
                if (pos2 > 0) {
                    parentRequestURI = requestURI.substring(0, pos2 + 1);
                    doFallback = false;
                }
            }
            catch (RepositoryException e) {
                // empty catch block
            }
        }
        if (doFallback && (pos = requestURI.lastIndexOf(47)) > 0) {
            parentRequestURI = requestURI.substring(0, pos + 1);
        }
        if ((prefix = this.getContextPath()) != null && prefix.length() > 0 && parentRequestURI.startsWith(prefix) && (parentRequestURI.length() == prefix.length() || parentRequestURI.charAt(prefix.length()) == '/')) {
            return parentRequestURI.substring(prefix.length());
        }
        return parentRequestURI;
    }

    public String getBaseRef() {
        return this.baseRef;
    }

    public URI getBaseURI() {
        if (this.baseUri == null) {
            String base = this.baseRef;
            if (base == null) {
                StringBuffer url = this.request.getRequestURL();
                if (url.indexOf("/jcr:content") > 0) {
                    base = url.substring(0, url.indexOf("/jcr:content"));
                } else if (this.request.getQueryString() != null) {
                    url.append('?');
                    url.append(this.request.getQueryString());
                    base = url.toString();
                } else {
                    base = url.toString();
                }
            }
            try {
                this.baseUri = new URI(base);
            }
            catch (URISyntaxException e) {
                log.warn("Ignoring malformed base URI: {}", (Object)e.toString());
                return null;
            }
        }
        return this.baseUri;
    }

    public void setBaseRef(String baseRef) {
        this.baseRef = baseRef;
        this.baseUri = null;
    }

    public boolean isIgnoreInternals() {
        return this.ignoreInternals;
    }

    public boolean setIgnoreInternals(boolean ignoreInternals) {
        boolean ret = this.ignoreInternals;
        this.ignoreInternals = ignoreInternals;
        return ret;
    }

    public boolean isIgnoreExternals() {
        return this.ignoreExternals;
    }

    public boolean setIgnoreExternals(boolean ignoreExternals) {
        boolean ret = this.ignoreExternals;
        this.ignoreExternals = ignoreExternals;
        return ret;
    }
}

