/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.rewriter.linkchecker.impl;

import com.day.cq.rewriter.linkchecker.Link;
import com.day.cq.rewriter.linkchecker.LinkChecker;
import com.day.cq.rewriter.linkchecker.LinkCheckerExtension;
import com.day.cq.rewriter.linkchecker.LinkCheckerSettings;
import com.day.cq.rewriter.linkchecker.LinkCheckerSettingsProvider;
import com.day.cq.rewriter.linkchecker.LinkInfo;
import com.day.cq.rewriter.linkchecker.LinkInfoStorage;
import com.day.cq.rewriter.linkchecker.LinkRewriteConfig;
import com.day.cq.rewriter.linkchecker.LinkValidity;
import com.day.cq.rewriter.linkchecker.impl.ExtensionList;
import com.day.cq.rewriter.linkchecker.impl.LinkImpl;
import com.day.text.Text;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkCheckerImpl
implements LinkChecker,
Runnable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BAD_LINK_TOLERANCE_INTERVAL = "service.bad_link_tolerance_interval";
    private static final String CHECK_OVERRIDE_PATTERNS = "service.check_override_patterns";
    private static final String CACHE_BROKEN_INTERNAL_LINKS = "service.cache_broken_internal_links";
    private static final String SPECIAL_LINK_PREFIX = "service.special_link_prefix";
    private static final String SPECIAL_LINK_PATTERNS = "service.special_link_patterns";
    protected static final LinkRewriteConfig DEFAULT_CONFIG = new LinkRewriteConfig(true, "", "");
    protected LinkInfoStorage storage;
    protected LinkCheckerSettingsProvider settingsProvider;
    private int badLinkToleranceInterval;
    private List<Pattern> checkOverridePatterns = new LinkedList<Pattern>();
    protected ExtensionList extensionList;
    private List<ServiceReference> delayedExtensionList = new LinkedList<ServiceReference>();
    private final Set<String> brokenInternalLinkCache = Collections.synchronizedSet(new HashSet());
    private boolean cacheBrokenInternalLinks = false;
    private String[] specialLinkPrefix = new String[0];
    private List<Pattern> specialLinkPatterns = new LinkedList<Pattern>();

    @Override
    public void run() {
        this.brokenInternalLinkCache.clear();
    }

    LinkImpl parseLink(String href, LinkCheckerSettings settings) {
        LinkImpl link = new LinkImpl(href, this.isSpecial(href));
        if (link.isSpecial()) {
            return link;
        }
        try {
            URI context;
            URI uri;
            int pos = href.indexOf(35);
            String fragment = null;
            if (pos > 0) {
                fragment = href.substring(pos + 1);
                href = href.substring(0, pos);
            }
            try {
                uri = new URI(href);
            }
            catch (URISyntaxException e) {
                if (href.startsWith("/")) {
                    this.logger.debug("auto escaping invalid uri: " + e.getMessage());
                    uri = new URI(Text.escape((String)href, (char)'%', (boolean)true));
                }
                throw e;
            }
            if (fragment != null) {
                uri = new URI(uri.getScheme(), uri.getSchemeSpecificPart(), fragment);
            }
            link.setUri(uri);
            URI base = settings.getBaseURI();
            if (base != null) {
                uri = base.resolve(uri);
            }
            if ((context = settings.getContextURI()) != null) {
                uri = context.relativize(uri);
            }
            link.setRelUri(uri);
        }
        catch (URISyntaxException e) {
            this.logger.warn("Ignoring malformed URI: {}", (Object)e.toString());
        }
        return link;
    }

    @Override
    public LinkValidity getLinkValidity(String url, LinkCheckerSettings settings) {
        return this.getLink(url, settings).getValidity();
    }

    @Override
    public Link getLink(String href, LinkCheckerSettings settings) {
        LinkImpl link = this.parseLink(href, settings);
        URI uri = link.getRelUri();
        if (link.isSpecial()) {
            return link.setValidity(LinkValidity.VALID);
        }
        if (uri == null) {
            return link.setValidity(LinkValidity.INVALID);
        }
        if (settings.isIgnoreExternals() && settings.isIgnoreInternals()) {
            return link.setValidity(LinkValidity.VALID);
        }
        if (this.matchesCheckOverridePatterns(link.getUri())) {
            return link.setValidity(LinkValidity.VALID);
        }
        if (uri.isAbsolute()) {
            LinkValidity validity;
            if (settings.isIgnoreExternals()) {
                return link.setValidity(LinkValidity.VALID);
            }
            LinkInfo info = this.storage.getLinkInfo(uri.toString());
            if (info == null) {
                info = new LinkInfo(uri.toString());
                validity = LinkValidity.PENDING;
            } else if (info.getLastChecked() == null) {
                validity = LinkValidity.PENDING;
            } else if (info.isValid()) {
                validity = LinkValidity.VALID;
            } else if (info.getLastAvailable() == null) {
                validity = LinkValidity.INVALID;
            } else {
                Calendar threshold = Calendar.getInstance();
                threshold.add(10, -this.badLinkToleranceInterval);
                validity = info.getLastAvailable().after(threshold) ? LinkValidity.VALID : LinkValidity.INVALID;
            }
            if (!uri.getScheme().equals("http")) {
                validity = LinkValidity.VALID;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("External link {} -> {} is " + (Object)((Object)validity), (Object)settings.getRequestURI(), (Object)uri);
            }
            info.setLastAccessed(Calendar.getInstance());
            info.addReferrer(settings.getRequest().getPathInfo());
            this.storage.putLinkInfo(info);
            return link.setValidity(validity);
        }
        if (uri.getPath() == null) {
            return link.setValidity(LinkValidity.VALID);
        }
        if (uri.getPath().startsWith("/")) {
            return link.setValidity(LinkValidity.VALID);
        }
        link.setContextRelative(true);
        if (settings.isIgnoreInternals()) {
            return link.setValidity(LinkValidity.VALID);
        }
        String path = "/" + uri.getPath();
        try {
            ResourceResolver resolver = settings.getResourceResolver();
            String key = settings.getRequest().getRemoteUser() + path;
            if (this.cacheBrokenInternalLinks && this.brokenInternalLinkCache.contains(key)) {
                return link.setValidity(LinkValidity.INVALID);
            }
            Resource resource = resolver.resolve((HttpServletRequest)settings.getRequest(), path);
            if (resource == null || ResourceUtil.isNonExistingResource((Resource)resource)) {
                if (this.cacheBrokenInternalLinks) {
                    this.brokenInternalLinkCache.add(key);
                }
                return link.setValidity(LinkValidity.INVALID);
            }
            for (LinkCheckerExtension extension : this.extensionList.getExtensions()) {
                LinkValidity validity = extension.getLinkValidity(resource);
                if (validity == LinkValidity.VALID) continue;
                return link.setValidity(validity);
            }
            return link.setValidity(LinkValidity.VALID);
        }
        catch (SlingException e) {
            this.logger.warn("Error during link checking: " + path, (Throwable)e);
            return link.setValidity(LinkValidity.INVALID);
        }
    }

    private boolean matchesCheckOverridePatterns(URI uri) {
        String link = uri.toString();
        for (Pattern pattern : this.checkOverridePatterns) {
            if (!pattern.matcher(link).find()) continue;
            return true;
        }
        return false;
    }

    @Override
    public LinkCheckerSettings createSettings(SlingHttpServletRequest request) {
        LinkCheckerSettings settings = LinkCheckerSettings.fromRequest(request);
        if (settings.getRequest() != null) {
            return settings;
        }
        settings.init(request);
        LinkCheckerSettings config = null;
        LinkCheckerSettingsProvider provider = this.settingsProvider;
        if (provider != null) {
            config = provider.createSettings(request);
        }
        if (config == null) {
            config = new LinkCheckerSettings();
            config.setExpiredConfig(DEFAULT_CONFIG);
            config.setInvalidConfig(DEFAULT_CONFIG);
            config.setPredatedConfig(DEFAULT_CONFIG);
        }
        if (settings.getInvalidConfig() == null) {
            settings.setInvalidConfig(config.getInvalidConfig());
        }
        if (settings.getExpiredConfig() == null) {
            settings.setExpiredConfig(config.getExpiredConfig());
        }
        if (settings.getPredatedConfig() == null) {
            settings.setPredatedConfig(config.getPredatedConfig());
        }
        return settings;
    }

    @Override
    public boolean isSpecial(String url) {
        if (url == null) {
            return true;
        }
        for (String prefix : this.specialLinkPrefix) {
            if (!url.startsWith(prefix)) continue;
            return true;
        }
        for (Pattern p : this.specialLinkPatterns) {
            if (!p.matcher(url).find()) continue;
            return true;
        }
        return false;
    }

    private String[] getFilteredList(Dictionary<String, Object> props, String propName) {
        Object prop = props.get(propName);
        ArrayList<String> filteredList = new ArrayList<String>();
        if (prop != null) {
            String[] list;
            for (String item : list = prop instanceof String[] ? (String[])prop : prop.toString().split("\\s+")) {
                if (item == null || item.trim().length() <= 0) continue;
                filteredList.add(item);
            }
        }
        return filteredList.toArray(new String[filteredList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(ComponentContext context) throws RepositoryException {
        Dictionary props = context.getProperties();
        this.badLinkToleranceInterval = Integer.valueOf(props.get(BAD_LINK_TOLERANCE_INTERVAL).toString());
        String[] patterns = this.getFilteredList(props, CHECK_OVERRIDE_PATTERNS);
        this.checkOverridePatterns.clear();
        for (String pattern : patterns) {
            try {
                this.checkOverridePatterns.add(Pattern.compile(pattern));
            }
            catch (PatternSyntaxException e) {
                this.logger.warn("Invalid link check override pattern: {}", (Object)pattern);
            }
        }
        this.cacheBrokenInternalLinks = (Boolean)props.get(CACHE_BROKEN_INTERNAL_LINKS);
        this.specialLinkPrefix = this.getFilteredList(props, SPECIAL_LINK_PREFIX);
        patterns = this.getFilteredList(props, SPECIAL_LINK_PATTERNS);
        this.specialLinkPatterns.clear();
        for (String pattern : patterns) {
            try {
                this.specialLinkPatterns.add(Pattern.compile(pattern));
            }
            catch (PatternSyntaxException e) {
                this.logger.warn("Invalid special link pattern: {}", (Object)pattern);
            }
        }
        LinkCheckerImpl linkCheckerImpl = this;
        synchronized (linkCheckerImpl) {
            this.extensionList = new ExtensionList(context);
            for (ServiceReference ref : this.delayedExtensionList) {
                this.extensionList.addExtension(ref);
            }
            this.delayedExtensionList.clear();
        }
        this.logger.debug("LinkChecker service activated");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deactivate(ComponentContext componentContext) {
        this.logger.debug("LinkChecker service shut down");
        LinkCheckerImpl linkCheckerImpl = this;
        synchronized (linkCheckerImpl) {
            this.extensionList = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindExtension(ServiceReference ref) {
        LinkCheckerImpl linkCheckerImpl = this;
        synchronized (linkCheckerImpl) {
            if (this.extensionList == null) {
                this.delayedExtensionList.add(ref);
            } else {
                this.extensionList.addExtension(ref);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindExtension(ServiceReference ref) {
        LinkCheckerImpl linkCheckerImpl = this;
        synchronized (linkCheckerImpl) {
            if (this.extensionList != null) {
                this.extensionList.removeExtension(ref);
            }
            this.delayedExtensionList.remove(ref);
        }
    }

    protected void bindStorage(LinkInfoStorage linkInfoStorage) {
        this.storage = linkInfoStorage;
    }

    protected void unbindStorage(LinkInfoStorage linkInfoStorage) {
        if (this.storage == linkInfoStorage) {
            this.storage = null;
        }
    }

    protected void bindSettingsProvider(LinkCheckerSettingsProvider linkCheckerSettingsProvider) {
        this.settingsProvider = linkCheckerSettingsProvider;
    }

    protected void unbindSettingsProvider(LinkCheckerSettingsProvider linkCheckerSettingsProvider) {
        if (this.settingsProvider == linkCheckerSettingsProvider) {
            this.settingsProvider = null;
        }
    }
}

