/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.rewriter.linkchecker.impl;

import com.day.cq.jcrclustersupport.ClusterAware;
import com.day.cq.rewriter.linkchecker.ExternalLinkChecker;
import com.day.cq.rewriter.linkchecker.LinkCheckerConfigProvider;
import com.day.cq.rewriter.linkchecker.LinkInfo;
import com.day.cq.rewriter.linkchecker.LinkInfoStorage;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.net.UnknownServiceException;
import java.util.Calendar;
import java.util.Dictionary;
import javax.jcr.RepositoryException;
import javax.net.ssl.SSLException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkCheckerTask
implements Runnable,
ExternalLinkChecker,
ClusterAware {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Boolean isMasterInstance = Boolean.FALSE;
    private static final int DEFAULT_GOOD_LINK_TEST_INTERVAL = 24;
    private static final String GOOD_LINK_TEST_INTERVAL = "good_link_test_interval";
    private static final int DEFAULT_BAD_LINK_TEST_INTERVAL = 1;
    private static final String BAD_LINK_TEST_INTERVAL = "bad_link_test_interval";
    private static final int DEFAULT_LINK_UNUSED_INTERVAL = 168;
    private static final String LINK_UNUSED_INTERVAL = "link_unused_interval";
    private static final int DEFAULT_CONNECTION_TIMEOUT = 10000;
    private static final String CONNECTION_TIMEOUT = "connection.timeout";
    protected LinkInfoStorage storage;
    protected LinkCheckerConfigProvider configProvider;
    protected int goodLinkTestInterval;
    protected int badLinkTestInterval;
    protected int linkUnusedInterval;
    private HttpClient httpClient;

    protected void activate(ComponentContext context) throws RepositoryException {
        Dictionary props = context.getProperties();
        this.goodLinkTestInterval = OsgiUtil.toInteger(props.get(GOOD_LINK_TEST_INTERVAL), (int)24);
        this.badLinkTestInterval = OsgiUtil.toInteger(props.get(BAD_LINK_TEST_INTERVAL), (int)1);
        this.linkUnusedInterval = OsgiUtil.toInteger(props.get(LINK_UNUSED_INTERVAL), (int)168);
        MultiThreadedHttpConnectionManager conMgr = new MultiThreadedHttpConnectionManager();
        this.httpClient = new HttpClient((HttpConnectionManager)conMgr);
        int connectionTimeout = OsgiUtil.toInteger(props.get(CONNECTION_TIMEOUT), (int)10000);
        if (connectionTimeout >= 5000) {
            this.httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(connectionTimeout);
        }
        this.log.info("LinkChecker service activated");
    }

    protected void deactivate(ComponentContext componentContext) {
        if (this.httpClient != null) {
            ((MultiThreadedHttpConnectionManager)this.httpClient.getHttpConnectionManager()).shutdown();
            this.httpClient = null;
        }
        this.log.info("LinkChecker service shut down");
    }

    public void run() {
        if (!this.isMasterInstance.booleanValue() || this.configProvider.getConfig().getDisableChecking()) {
            return;
        }
        this.checkLinks();
    }

    public void checkLinks() {
        String[] links;
        if (!this.isMasterInstance.booleanValue()) {
            return;
        }
        for (String link : links = this.storage.getLinks()) {
            this.checkLink(link, false);
        }
    }

    public LinkInfo checkLink(String link, boolean force) {
        boolean check;
        LinkInfo info = this.storage.getLinkInfo(link);
        if (info == null) {
            return null;
        }
        Calendar now = Calendar.getInstance();
        if (this.hoursPassed(info.getLastAccessed(), this.linkUnusedInterval)) {
            this.storage.deleteLinkInfo(info);
            return null;
        }
        boolean bl = check = info.getLastChecked() == null || info.isValid() && this.hoursPassed(info.getLastChecked(), this.goodLinkTestInterval) || !info.isValid() && this.hoursPassed(info.getLastChecked(), this.badLinkTestInterval);
        if (check || force) {
            int status;
            try {
                this.log.debug("Checking URL {}", (Object)link);
                status = this.check(link);
                if (status == 404 || status == 301) {
                    this.log.info("Checked URL {}: {} (invalid)", (Object)link, (Object)status);
                    info.setValid(false);
                } else if (status == 200 || status == 302) {
                    this.log.info("Checked URL {}: {} (valid)", (Object)link, (Object)status);
                    info.setValid(true);
                    info.setLastAvailable(now);
                }
            }
            catch (SSLException e) {
                status = -7;
                this.log.error("Failed to validate URL {}: {}", (Object)link, (Object)e.toString());
            }
            catch (UnknownServiceException e) {
                status = -1;
                this.log.error("Failed to validate URL {}: {}", (Object)link, (Object)e.toString());
            }
            catch (NoRouteToHostException e) {
                status = -4;
                this.log.error("Failed to validate URL {}: {}", (Object)link, (Object)e.toString());
            }
            catch (UnknownHostException e) {
                status = -5;
                this.log.error("Failed to validate URL {}: {}", (Object)link, (Object)e.toString());
            }
            catch (ConnectException e) {
                status = -3;
                this.log.error("Failed to validate URL {}: {}", (Object)link, (Object)e.toString());
            }
            catch (URISyntaxException e) {
                status = -2;
                info.setValid(false);
                this.log.error("Failed to validate URL {}: {}", (Object)link, (Object)e.toString());
            }
            catch (IOException e) {
                status = -6;
                this.log.error("Failed to validate URL {}: {}", (Object)link, (Object)e.toString());
            }
            info.setLastStatus(status);
            info.setLastChecked(now);
            this.storage.putLinkInfo(info);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int check(String url) throws UnknownServiceException, URISyntaxException, ConnectException, NoRouteToHostException, UnknownHostException, IOException {
        HeadMethod method;
        URI uri = new URI(url);
        try {
            method = new HeadMethod(uri.toString());
        }
        catch (Exception e) {
            throw new UnknownServiceException(e.getMessage());
        }
        try {
            int status = this.httpClient.executeMethod((HttpMethod)method);
            if (status == 200 || status == 302) {
                int n = status;
                return n;
            }
        }
        finally {
            method.releaseConnection();
        }
        try {
            method = new GetMethod(uri.toString());
        }
        catch (Exception e) {
            throw new UnknownServiceException(e.getMessage());
        }
        try {
            int n = this.httpClient.executeMethod((HttpMethod)method);
            return n;
        }
        finally {
            method.releaseConnection();
        }
    }

    private boolean hoursPassed(Calendar calendar, int hours) {
        if (calendar == null) {
            return true;
        }
        Calendar now = Calendar.getInstance();
        Calendar check = (Calendar)calendar.clone();
        check.add(10, hours);
        return now.after(check);
    }

    public void bindRepository(String repositoryId, String clusterId, boolean isMaster) {
        this.isMasterInstance = isMaster;
    }

    public void unbindRepository() {
        this.isMasterInstance = Boolean.FALSE;
    }

    protected void bindStorage(LinkInfoStorage linkInfoStorage) {
        this.storage = linkInfoStorage;
    }

    protected void unbindStorage(LinkInfoStorage linkInfoStorage) {
        if (this.storage == linkInfoStorage) {
            this.storage = null;
        }
    }

    protected void bindConfigProvider(LinkCheckerConfigProvider linkCheckerConfigProvider) {
        this.configProvider = linkCheckerConfigProvider;
    }

    protected void unbindConfigProvider(LinkCheckerConfigProvider linkCheckerConfigProvider) {
        if (this.configProvider == linkCheckerConfigProvider) {
            this.configProvider = null;
        }
    }
}

