/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.rewriter.linkchecker.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkCheckerTransformerConfig {
    private static final Logger log = LoggerFactory.getLogger(LinkCheckerTransformerConfig.class);
    private final boolean disableRewriting;
    private final boolean disableChecking;
    private final boolean strictExtensionCheck;
    private final boolean stripHtmlExtension;
    private final ResourceResolver adminResourceResolver;
    private final ConcurrentMap<String, String> mapCache;
    private final int maxMapCacheSize;
    private final Map<String, String> validateElements;

    public LinkCheckerTransformerConfig(boolean disableRewriting, boolean disableChecking, boolean strictExtensionCheck, boolean stripHtmlExtension, int cacheSize, String[] validateElements, ResourceResolver adminResourceResolver) {
        this.disableChecking = disableChecking;
        this.disableRewriting = disableRewriting;
        this.strictExtensionCheck = strictExtensionCheck;
        this.stripHtmlExtension = stripHtmlExtension;
        this.adminResourceResolver = adminResourceResolver;
        if (cacheSize < 50) {
            this.mapCache = null;
            this.maxMapCacheSize = 0;
        } else {
            this.mapCache = new ConcurrentHashMap<String, String>();
            this.maxMapCacheSize = cacheSize;
        }
        this.validateElements = new HashMap<String, String>();
        if (validateElements != null) {
            for (String validateElement : validateElements) {
                if (validateElement == null) continue;
                int pos = validateElement.indexOf(58);
                if (pos == -1) {
                    this.validateElements.put(validateElement, "href");
                    continue;
                }
                this.validateElements.put(validateElement.substring(0, pos), validateElement.substring(pos + 1));
            }
        }
        log.debug("maxMapCacheSize={}, validateElements={}", (Object)this.maxMapCacheSize, (Object)validateElements);
    }

    public boolean getDisableRewriting() {
        return this.disableRewriting;
    }

    public boolean getDisableChecking() {
        return this.disableChecking;
    }

    public boolean isStrictExtensionCheck() {
        return this.strictExtensionCheck;
    }

    public boolean isStripHtmlExtension() {
        return this.stripHtmlExtension;
    }

    public String getRewriteAttributeName(String elementName) {
        return this.validateElements.get(elementName.toLowerCase());
    }

    public String map(ResourceResolver userResolver, HttpServletRequest request, String path) {
        if (this.adminResourceResolver == null) {
            String result = userResolver.map(request, path);
            log.debug("No adminResourceResolver, mapping using userResolver: {} -> {}", (Object)path, (Object)result);
            return result;
        }
        if (this.mapCache == null) {
            String result = this.adminResourceResolver.map(request, path);
            log.debug("Cache disabled, mapping using adminResourceResolver: {} -> {}", (Object)path, (Object)result);
            return result;
        }
        StringBuilder sb = new StringBuilder(request.getScheme());
        sb.append(':');
        sb.append(request.getServerName());
        sb.append(':');
        sb.append(request.getServerPort());
        sb.append(path);
        String key = sb.toString();
        String result = (String)this.mapCache.get(key);
        if (result == null) {
            result = this.adminResourceResolver.map(request, path);
            if (this.mapCache.size() < this.maxMapCacheSize) {
                this.mapCache.put(key, result);
                log.debug("Got result from adminResourceResolver, cached: {} -> {}", (Object)path, (Object)result);
            } else {
                log.debug("Got result from adminResourceResolver, not cached (cache full): {} -> {}", (Object)path, (Object)result);
            }
        } else {
            log.debug("Got result from cache: {} -> {}", (Object)path, (Object)result);
        }
        return result;
    }

    public void clearCache() {
        if (this.mapCache != null) {
            this.mapCache.clear();
            log.debug("Cache cleared");
        }
    }
}

