/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.rewriter.linkchecker.impl;

import com.day.cq.rewriter.linkchecker.LinkChecker;
import com.day.cq.rewriter.linkchecker.LinkCheckerConfigProvider;
import com.day.cq.rewriter.linkchecker.impl.LinkCheckerTransformer;
import com.day.cq.rewriter.linkchecker.impl.LinkCheckerTransformerConfig;
import com.day.cq.rewriter.pipeline.RequestLinkChecker;
import com.day.cq.rewriter.pipeline.RequestRewriter;
import java.util.Dictionary;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.rewriter.Transformer;
import org.apache.sling.rewriter.TransformerFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class LinkCheckerTransformerFactory
implements TransformerFactory,
EventHandler,
LinkCheckerConfigProvider {
    private static final boolean DEFAULT_DISABLE_REWRITING = false;
    private static final String PROP_DISABLE_REWRITING = "linkcheckertransformer.disableRewriting";
    private static final boolean DEFAULT_DISABLE_CHECKING = false;
    private static final String PROP_DISABLE_CHECKING = "linkcheckertransformer.disableChecking";
    private static final int DEFAULT_MAP_CACHE_SIZE = 5000;
    private static final String PROP_MAP_CACHE_SIZE = "linkcheckertransformer.mapCacheSize";
    private static final boolean DEFAULT_STRICT_EXTENSION_CHECK = false;
    private static final String PROP_STRICT_EXTENSION_CHECK = "linkcheckertransformer.strictExtensionCheck";
    private static final boolean DEFAULT_STRIP_HTML_EXTENSION = false;
    private static final String PROP_STRIP_HTML_EXTENSION = "linkcheckertransformer.stripHtmltExtension";
    private static final String PROP_REWRITE_ELEMENTS = "linkcheckertransformer.rewriteElements";
    private LinkChecker linkChecker;
    private ResourceResolverFactory resourceResolverFactory;
    private RequestLinkChecker requestLinkChecker;
    private RequestRewriter requestRewriter;
    private LinkCheckerTransformerConfig config;
    private ResourceResolver adminResolver;

    protected void activate(ComponentContext ctx) throws LoginException {
        Dictionary props = ctx.getProperties();
        this.adminResolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
        this.config = new LinkCheckerTransformerConfig(OsgiUtil.toBoolean(props.get(PROP_DISABLE_REWRITING), (boolean)false), OsgiUtil.toBoolean(props.get(PROP_DISABLE_CHECKING), (boolean)false), OsgiUtil.toBoolean(props.get(PROP_STRICT_EXTENSION_CHECK), (boolean)false), OsgiUtil.toBoolean(props.get(PROP_STRIP_HTML_EXTENSION), (boolean)false), OsgiUtil.toInteger(props.get(PROP_MAP_CACHE_SIZE), (int)5000), OsgiUtil.toStringArray(props.get(PROP_REWRITE_ELEMENTS), (String[])new String[]{"a:href", "area:href", "form:action"}), this.adminResolver);
    }

    protected void deactivate() {
        if (this.adminResolver != null) {
            this.adminResolver.close();
            this.adminResolver = null;
        }
    }

    public Transformer createTransformer() {
        return new LinkCheckerTransformer(this.linkChecker, this.requestLinkChecker, this.requestRewriter, this.config);
    }

    public void handleEvent(Event event) {
        String path = (String)event.getProperty("path");
        if (path != null && (path.startsWith("/content") || path.startsWith("/etc/map"))) {
            this.config.clearCache();
        }
    }

    public LinkCheckerTransformerConfig getConfig() {
        return this.config;
    }

    protected void bindLinkChecker(LinkChecker linkChecker) {
        this.linkChecker = linkChecker;
    }

    protected void unbindLinkChecker(LinkChecker linkChecker) {
        if (this.linkChecker == linkChecker) {
            this.linkChecker = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindRequestLinkChecker(RequestLinkChecker requestLinkChecker) {
        this.requestLinkChecker = requestLinkChecker;
    }

    protected void unbindRequestLinkChecker(RequestLinkChecker requestLinkChecker) {
        if (this.requestLinkChecker == requestLinkChecker) {
            this.requestLinkChecker = null;
        }
    }

    protected void bindRequestRewriter(RequestRewriter requestRewriter) {
        this.requestRewriter = requestRewriter;
    }

    protected void unbindRequestRewriter(RequestRewriter requestRewriter) {
        if (this.requestRewriter == requestRewriter) {
            this.requestRewriter = null;
        }
    }
}

