/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.rewriter.processor.impl;

import org.osgi.service.component.ComponentFactory;
import org.osgi.service.component.ComponentInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractFactoryWrapper<T> {
    private static Logger LOGGER = LoggerFactory.getLogger((String)AbstractFactoryWrapper.class.getName());
    private final String componentType;
    private final ComponentFactory factory;

    public AbstractFactoryWrapper(String cType, ComponentFactory factory) {
        this.componentType = cType;
        this.factory = factory;
    }

    protected Component<T> createComponent() {
        if (this.factory == null) {
            LOGGER.debug("Requested component factory for class '{}' and type '{}' not found.", (Object)this.getClass().getName(), (Object)this.componentType);
            return null;
        }
        ComponentInstance instance = this.factory.newInstance(null);
        if (instance == null) {
            return null;
        }
        Object component = instance.getInstance();
        if (component == null) {
            LOGGER.debug("Unable to get instance '{}' of type '{}' from factory.", (Object)this.getClass().getName(), (Object)this.componentType);
            instance.dispose();
            return null;
        }
        return new Component<Object>(instance, component);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class Component<T> {
        public final ComponentInstance instance;
        public final T component;

        public Component(ComponentInstance cI, T c) {
            this.instance = cI;
            this.component = c;
        }
    }
}

