/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.rewriter.xml;

import com.day.cq.rewriter.xml.helpers.TextRecorder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.apache.cocoon.xml.sax.AbstractSAXPipe;
import org.apache.cocoon.xml.sax.AttributesImpl;
import org.apache.cocoon.xml.sax.SAXUtils;
import org.apache.excalibur.source.SourceParameters;
import org.apache.sling.rewriter.ProcessingComponentConfiguration;
import org.apache.sling.rewriter.ProcessingContext;
import org.apache.sling.rewriter.Transformer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public abstract class AbstractSAXTransformer
extends AbstractSAXPipe
implements Transformer {
    protected boolean ignoreWhitespaces;
    protected boolean ignoreEmptyCharacters;
    protected int ignoreEventsCount;
    protected int ignoreHooksCount;
    protected String namespaceURI;
    protected String defaultNamespaceURI;
    protected final Stack stack = new Stack();
    protected final Stack<ContentHandler> recorderStack = new Stack();
    private boolean isInitialized;
    private final List<String[]> namespaces = new ArrayList<String[]>(5);
    private String ourPrefix;
    protected boolean removeOurNamespacePrefixes = false;
    private LexicalHandler originalLexicalHandler;
    private ContentHandler originalContentHandler;

    public void init(ProcessingContext context, ProcessingComponentConfiguration config) throws IOException {
        if (this.defaultNamespaceURI == null) {
            this.defaultNamespaceURI = "";
        }
        this.isInitialized = false;
        this.namespaceURI = config.getConfiguration().containsKey((Object)"namespaceURI") ? config.getConfiguration().get((Object)"namespaceURI").toString() : this.defaultNamespaceURI;
        this.ignoreHooksCount = 0;
        this.ignoreEventsCount = 0;
        this.ignoreWhitespaces = true;
        this.ignoreEmptyCharacters = false;
    }

    public void setDocumentLocator(Locator locator) {
        if (this.ignoreEventsCount == 0) {
            super.setDocumentLocator(locator);
        }
    }

    public void startDocument() throws SAXException {
        if (!this.isInitialized) {
            try {
                this.setupTransforming();
            }
            catch (IOException e) {
                throw new SAXException("IOException: " + e, e);
            }
            this.isInitialized = true;
        }
        if (this.ignoreEventsCount == 0) {
            super.startDocument();
        }
    }

    public void endDocument() throws SAXException {
        if (this.ignoreEventsCount == 0) {
            super.endDocument();
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        boolean isOurPrefix = false;
        if (prefix != null) {
            this.namespaces.add(new String[]{prefix, uri});
        }
        if (this.namespaceURI.equals(uri)) {
            this.ourPrefix = prefix;
            isOurPrefix = true;
        }
        if (!(this.ignoreEventsCount != 0 || this.removeOurNamespacePrefixes && isOurPrefix)) {
            super.startPrefixMapping(prefix, uri);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        boolean isOurPrefix = false;
        if (prefix != null) {
            String[] prefixAndUri;
            int i;
            boolean found = false;
            for (i = this.namespaces.size() - 1; i >= 0; --i) {
                prefixAndUri = this.namespaces.get(i);
                if (!prefixAndUri[0].equals(prefix)) continue;
                this.namespaces.remove(i);
                found = true;
                break;
            }
            if (!found) {
                throw new SAXException("Namespace for prefix '" + prefix + "' not found.");
            }
            if (prefix.equals(this.ourPrefix)) {
                isOurPrefix = true;
                this.ourPrefix = null;
                for (i = this.namespaces.size() - 1; i >= 0; --i) {
                    prefixAndUri = this.namespaces.get(i);
                    if (!this.namespaceURI.equals(prefixAndUri[1])) continue;
                    this.ourPrefix = prefixAndUri[0];
                    break;
                }
            }
        }
        if (!(this.ignoreEventsCount != 0 || this.removeOurNamespacePrefixes && isOurPrefix)) {
            super.endPrefixMapping(prefix);
        }
    }

    public void startElement(String uri, String name, String raw, Attributes attr) throws SAXException {
        if (this.namespaceURI.equals(uri) && this.ignoreHooksCount == 0) {
            try {
                this.startTransformingElement(uri, name, raw, attr);
            }
            catch (IOException e) {
                throw new SAXException("IOException occured during processing: " + e, e);
            }
        } else if (this.ignoreEventsCount == 0) {
            super.startElement(uri, name, raw, attr);
        }
    }

    public void endElement(String uri, String name, String raw) throws SAXException {
        if (this.namespaceURI.equals(uri) && this.ignoreHooksCount == 0) {
            try {
                this.endTransformingElement(uri, name, raw);
            }
            catch (IOException e) {
                throw new SAXException("IOException occured during processing: " + e, e);
            }
        } else if (this.ignoreEventsCount == 0) {
            super.endElement(uri, name, raw);
        }
    }

    public void characters(char[] p0, int p1, int p2) throws SAXException {
        if (this.ignoreEventsCount == 0) {
            if (this.ignoreEmptyCharacters) {
                String value = new String(p0, p1, p2);
                if (value.trim().length() > 0) {
                    super.characters(p0, p1, p2);
                }
            } else {
                super.characters(p0, p1, p2);
            }
        }
    }

    public void ignorableWhitespace(char[] p0, int p1, int p2) throws SAXException {
        if (!this.ignoreWhitespaces && this.ignoreEventsCount == 0) {
            super.ignorableWhitespace(p0, p1, p2);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.ignoreEventsCount == 0) {
            super.processingInstruction(target, data);
        }
    }

    public void skippedEntity(String name) throws SAXException {
        if (this.ignoreEventsCount == 0) {
            super.skippedEntity(name);
        }
    }

    public void startDTD(String name, String public_id, String system_id) throws SAXException {
        if (this.ignoreEventsCount == 0) {
            super.startDTD(name, public_id, system_id);
        }
    }

    public void endDTD() throws SAXException {
        if (this.ignoreEventsCount == 0) {
            super.endDTD();
        }
    }

    public void startEntity(String name) throws SAXException {
        if (this.ignoreEventsCount == 0) {
            super.startEntity(name);
        }
    }

    public void endEntity(String name) throws SAXException {
        if (this.ignoreEventsCount == 0) {
            super.endEntity(name);
        }
    }

    public void startCDATA() throws SAXException {
        if (this.ignoreEventsCount == 0) {
            super.startCDATA();
        }
    }

    public void endCDATA() throws SAXException {
        if (this.ignoreEventsCount == 0) {
            super.endCDATA();
        }
    }

    public void comment(char[] ary, int start, int length) throws SAXException {
        if (this.ignoreEventsCount == 0) {
            super.comment(ary, start, length);
        }
    }

    protected void addRecorder(ContentHandler recorder) {
        if (this.recorderStack.empty()) {
            this.originalLexicalHandler = this.lexicalHandler;
            this.originalContentHandler = this.contentHandler;
        }
        this.setContentHandler(recorder);
        this.recorderStack.push(recorder);
    }

    protected Object removeRecorder() {
        ContentHandler recorder = this.recorderStack.pop();
        if (this.recorderStack.empty()) {
            this.contentHandler = this.originalContentHandler;
            this.lexicalHandler = this.originalLexicalHandler;
            this.originalLexicalHandler = null;
            this.originalContentHandler = null;
        } else {
            ContentHandler next = this.recorderStack.peek();
            this.setContentHandler(next);
        }
        return recorder;
    }

    public void startTextRecording() throws SAXException {
        this.addRecorder(new TextRecorder());
        this.sendStartPrefixMapping();
    }

    public String endTextRecording() throws SAXException {
        this.sendEndPrefixMapping();
        TextRecorder recorder = (TextRecorder)this.removeRecorder();
        String text = recorder.getText();
        return text;
    }

    public void setupTransforming() throws IOException, SAXException {
        this.stack.clear();
        this.recorderStack.clear();
        this.ignoreWhitespaces = true;
        this.ignoreEmptyCharacters = false;
    }

    public void startTransformingElement(String uri, String name, String raw, Attributes attr) throws IOException, SAXException {
        if (this.ignoreEventsCount == 0) {
            super.startElement(uri, name, raw, attr);
        }
    }

    public void endTransformingElement(String uri, String name, String raw) throws IOException, SAXException {
        if (this.ignoreEventsCount == 0) {
            super.endElement(uri, name, raw);
        }
    }

    public void sendTextEvent(String text) throws SAXException {
        this.characters(text.toCharArray(), 0, text.length());
    }

    public void sendStartElementEvent(String localname) throws SAXException {
        this.startElement("", localname, localname, SAXUtils.EMPTY_ATTRIBUTES);
    }

    public void sendStartElementEventNS(String localname) throws SAXException {
        this.startElement(this.namespaceURI, localname, this.ourPrefix + ':' + localname, SAXUtils.EMPTY_ATTRIBUTES);
    }

    public void sendStartElementEvent(String localname, Attributes attr) throws SAXException {
        this.startElement("", localname, localname, attr);
    }

    public void sendStartElementEventNS(String localname, Attributes attr) throws SAXException {
        this.startElement(this.namespaceURI, localname, this.ourPrefix + ':' + localname, attr);
    }

    public void sendEndElementEvent(String localname) throws SAXException {
        this.endElement("", localname, localname);
    }

    public void sendEndElementEventNS(String localname) throws SAXException {
        this.endElement(this.namespaceURI, localname, this.ourPrefix + ':' + localname);
    }

    public void sendParametersEvents(SourceParameters pars) throws SAXException {
        if (pars != null) {
            Iterator names = pars.getParameterNames();
            while (names.hasNext()) {
                String currentName = (String)names.next();
                Iterator values = pars.getParameterValues(currentName);
                while (values.hasNext()) {
                    String currentValue = (String)values.next();
                    this.sendStartElementEvent(currentName);
                    this.sendTextEvent(currentValue);
                    this.sendEndElementEvent(currentName);
                }
            }
        }
    }

    protected void sendStartPrefixMapping() throws SAXException {
        int l = this.namespaces.size();
        for (int i = 0; i < l; ++i) {
            String[] prefixAndUri = this.namespaces.get(i);
            super.startPrefixMapping(prefixAndUri[0], prefixAndUri[1]);
        }
    }

    protected void sendEndPrefixMapping() throws SAXException {
        int l = this.namespaces.size();
        for (int i = 0; i < l; ++i) {
            String[] prefixAndUri = this.namespaces.get(i);
            super.endPrefixMapping(prefixAndUri[0]);
        }
    }

    protected String findPrefixMapping(String uri) {
        int l = this.namespaces.size();
        for (int i = 0; i < l; ++i) {
            String[] prefixAndUri = this.namespaces.get(i);
            if (!prefixAndUri[1].equals(uri)) continue;
            return prefixAndUri[0];
        }
        return null;
    }

    protected AttributesImpl getMutableAttributes(Attributes a) {
        if (a instanceof AttributesImpl) {
            return (AttributesImpl)a;
        }
        return new AttributesImpl(a);
    }
}

