/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.rewriter.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Stack;
import org.apache.cocoon.xml.sax.AbstractSAXPipe;
import org.apache.cocoon.xml.sax.AttributesImpl;
import org.apache.cocoon.xml.sax.SAXUtils;
import org.apache.sling.commons.html.HtmlParser;
import org.apache.sling.rewriter.ProcessingComponentConfiguration;
import org.apache.sling.rewriter.ProcessingContext;
import org.apache.sling.rewriter.Transformer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class HTMLParsingTransformer
extends AbstractSAXPipe
implements Transformer {
    private static final String ATTR_TEXT = "text";
    private static final String ATTR_RICH_TEXT = "textIsRich";
    private static final String ATTR_RESOURCE_TYPE = "sling:resourceType";
    private static final String COLCTRL_RESOURCE_TYPE = "foundation/components/parsys/colctrl";
    private static final String ATTR_LAYOUT = "layout";
    private static final String ATTR_CONTROL_TYPE = "controlType";
    private static final String COLCTRL = "colctrl";
    private static final String TYPE_START = "start";
    private static final String TYPE_END = "end";
    private static final String TYPE_BREAK = "break";
    private final HtmlParser htmlParser;
    private int ignoreEndElement = 0;
    private final Stack<Boolean> isInRowStack = new Stack();

    public HTMLParsingTransformer(HtmlParser parser) {
        this.htmlParser = parser;
    }

    public void init(ProcessingContext context, ProcessingComponentConfiguration config) throws IOException {
        this.isInRowStack.push(false);
    }

    public void startElement(String uri, String loc, String raw, Attributes a) throws SAXException {
        if ("file".equals(loc) && "nt:file".equals(a.getValue("jcr:primaryType"))) {
            ++this.ignoreEndElement;
            return;
        }
        if (this.ignoreEndElement > 0) {
            ++this.ignoreEndElement;
            return;
        }
        String resourceType = a.getValue(ATTR_RESOURCE_TYPE);
        if (resourceType != null && resourceType.endsWith(COLCTRL)) {
            AttributesImpl ai = new AttributesImpl(a);
            ai.removeAttribute(ATTR_RESOURCE_TYPE);
            ai.addCDATAAttribute(ATTR_RESOURCE_TYPE, COLCTRL_RESOURCE_TYPE);
            String type = a.getValue(ATTR_CONTROL_TYPE);
            if (type == null || TYPE_START.equals(type)) {
                ai.removeAttribute(ATTR_CONTROL_TYPE);
                ai.addCDATAAttribute(ATTR_CONTROL_TYPE, TYPE_START);
                super.startElement("", COLCTRL, COLCTRL, (Attributes)ai);
                String layout = a.getValue(ATTR_LAYOUT);
                int numCols = 1;
                if (layout != null) {
                    int pos = layout.indexOf(";");
                    numCols = pos == -1 ? Integer.valueOf(layout).intValue() : Integer.valueOf(layout.substring(0, pos)).intValue();
                }
                for (int i = 0; i < numCols; ++i) {
                    super.startElement("", "col", "col", SAXUtils.EMPTY_ATTRIBUTES);
                    super.endElement("", "col", "col");
                }
                super.startElement("", "row", "row", SAXUtils.EMPTY_ATTRIBUTES);
                super.startElement("", "cell", "cell", SAXUtils.EMPTY_ATTRIBUTES);
                super.startElement("", COLCTRL, COLCTRL, (Attributes)ai);
                super.startElement("", "col", "col", SAXUtils.EMPTY_ATTRIBUTES);
                super.endElement("", "col", "col");
                this.isInRowStack.push(true);
            } else if (TYPE_BREAK.equals(type)) {
                super.endElement("", COLCTRL, COLCTRL);
                super.endElement("", "cell", "cell");
                super.startElement("", "cell", "cell", SAXUtils.EMPTY_ATTRIBUTES);
                super.startElement("", COLCTRL, COLCTRL, (Attributes)ai);
                super.startElement("", "col", "col", SAXUtils.EMPTY_ATTRIBUTES);
                super.endElement("", "col", "col");
            } else if (TYPE_END.equals(type)) {
                super.endElement("", COLCTRL, COLCTRL);
                super.endElement("", "cell", "cell");
                super.endElement("", "row", "row");
                this.isInRowStack.pop();
                super.endElement("", COLCTRL, COLCTRL);
            }
            ++this.ignoreEndElement;
            return;
        }
        if (this.isInRowStack.peek().booleanValue()) {
            super.startElement("", "row", "row", SAXUtils.EMPTY_ATTRIBUTES);
            super.startElement("", "cell", "cell", SAXUtils.EMPTY_ATTRIBUTES);
        }
        super.startElement(uri, loc, raw, a);
        this.isInRowStack.push(false);
        String text = a.getValue(ATTR_TEXT);
        if (text != null) {
            super.startElement("", ATTR_TEXT, ATTR_TEXT, (Attributes)new AttributesImpl());
            if ("true".equals(a.getValue(ATTR_RICH_TEXT)) || a.getValue(ATTR_RICH_TEXT) == null) {
                String html = "<html><body>" + text + "</body></html>";
                try {
                    this.htmlParser.parse((InputStream)new ByteArrayInputStream(html.getBytes("UTF-8")), "UTF-8", HTMLParsingTransformer.getContentFilter(this.contentHandler));
                }
                catch (UnsupportedEncodingException e) {}
            } else {
                super.characters(text.toCharArray(), 0, text.length());
            }
            super.endElement("", ATTR_TEXT, ATTR_TEXT);
        }
    }

    public void endElement(String uri, String loc, String raw) throws SAXException {
        if (this.ignoreEndElement > 0) {
            --this.ignoreEndElement;
            return;
        }
        super.endElement(uri, loc, raw);
        this.isInRowStack.pop();
        if (this.isInRowStack.peek().booleanValue()) {
            super.endElement("", "cell", "cell");
            super.endElement("", "row", "row");
        }
    }

    public void dispose() {
    }

    public static ContentHandler getContentFilter(ContentHandler ch) {
        if (ch instanceof LexicalHandler) {
            return new ExtendedContentFilter(ch);
        }
        return new ContentFilter(ch);
    }

    protected static class ExtendedContentFilter
    extends ContentFilter
    implements LexicalHandler {
        protected final LexicalHandler lh;

        public ExtendedContentFilter(ContentHandler ch) {
            super(ch);
            this.lh = (LexicalHandler)((Object)ch);
        }

        public void comment(char[] arg0, int arg1, int arg2) throws SAXException {
            this.lh.comment(arg0, arg1, arg2);
        }

        public void endCDATA() throws SAXException {
            this.lh.endCDATA();
        }

        public void endDTD() throws SAXException {
            this.lh.endDTD();
        }

        public void endEntity(String arg0) throws SAXException {
            this.lh.endEntity(arg0);
        }

        public void startCDATA() throws SAXException {
            this.lh.startCDATA();
        }

        public void startDTD(String arg0, String arg1, String arg2) throws SAXException {
            this.lh.startDTD(arg0, arg1, arg2);
        }

        public void startEntity(String arg0) throws SAXException {
            this.lh.startEntity(arg0);
        }
    }

    protected static class ContentFilter
    implements ContentHandler {
        protected final ContentHandler ch;
        private static final String NAMESPACE = "http://www.w3.org/1999/xhtml";
        private String prefix;

        public ContentFilter(ContentHandler ch) {
            this.ch = ch;
        }

        public void endElement(String uri, String loc, String raw) throws SAXException {
            if (!loc.equals("html") && !loc.equals("body")) {
                if (uri.equals(NAMESPACE)) {
                    uri = "";
                }
                this.ch.endElement(uri, loc, raw);
            }
        }

        public void startElement(String uri, String loc, String raw, Attributes a) throws SAXException {
            if (!loc.equals("html") && !loc.equals("body")) {
                if (uri.equals(NAMESPACE)) {
                    uri = "";
                }
                this.ch.startElement(uri, loc, raw, a);
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.ch.characters(ch, start, length);
        }

        public void endDocument() throws SAXException {
        }

        public void endPrefixMapping(String prefix) throws SAXException {
            if (prefix.equals(this.prefix)) {
                this.prefix = null;
            } else {
                this.ch.endPrefixMapping(prefix);
            }
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            this.ch.ignorableWhitespace(ch, start, length);
        }

        public void processingInstruction(String target, String data) throws SAXException {
            this.ch.processingInstruction(target, data);
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void skippedEntity(String name) throws SAXException {
            this.ch.skippedEntity(name);
        }

        public void startDocument() throws SAXException {
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            if (NAMESPACE.equals(uri)) {
                this.prefix = prefix;
            } else {
                this.ch.startPrefixMapping(prefix, uri);
            }
        }
    }
}

