/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.rewriter.xml;

import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import org.slf4j.Logger;

public class XSLTProcessorErrorListener
implements ErrorListener {
    private final Logger logger;
    private final String uri;
    private TransformerException warningEx;
    private TransformerException exception;

    public XSLTProcessorErrorListener(Logger logger, String uri) {
        this.logger = logger;
        this.uri = uri;
    }

    public Throwable getThrowable() {
        if (this.exception == null) {
            return null;
        }
        if (this.exception.getCause() != null) {
            return this.exception.getCause();
        }
        return this.exception;
    }

    public void warning(TransformerException ex) throws TransformerException {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn(ex.getMessage() + " at " + this.uri);
        }
        this.warningEx = ex;
    }

    public void error(TransformerException ex) throws TransformerException {
        this.logger.error(ex.getMessage() + " at " + this.uri);
        if (this.warningEx != null && ex.getCause() == null) {
            ex = this.warningEx;
        }
        this.warningEx = null;
        this.exception = ex;
        throw ex;
    }

    public void fatalError(TransformerException ex) throws TransformerException {
        this.logger.error(ex.getMessage() + " at " + this.uri);
        if (this.warningEx != null && ex.getCause() == null) {
            ex = this.warningEx;
        }
        this.warningEx = null;
        this.exception = ex;
        throw ex;
    }
}

